/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.db.directives;

import com.wily.diagnos.cmp.directives.FlagName;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.directives.builder.TracerGroupBuilder;
import com.wily.diagnos.cmp.directives.parser.DGInvalidFlagNameException;
import com.wily.diagnos.cmp.directives.parser.DGInvalidTracerNameException;
import com.wily.introscope.agent.db.directives.DatabaseDirectiveInfo;
import com.wily.introscope.agent.db.directives.IDatabaseDirective;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.IDynamicInstrumentationImplementationConstants;
import com.wily.util.classfile.IClassSchemaPolicy;
import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.classfile.InvalidMethodDescriptorException;
import com.wily.util.classfile.InvalidMethodNameException;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.validate.ValidationException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class GroupDatabaseDirective
implements IDatabaseDirective,
IDynamicInstrumentationImplementationConstants {
    private static final String kInvalidFlag = "Diagnos_Parsing_Invalid_Flag_Name_Key";
    private static final MessageFormat kTurnOnTextFormat = new MessageFormat("SetFlag: {0}\nTurnOn: {0} \n");
    private static final MessageFormat[] kTurnOnTextFormatLines = new MessageFormat[]{new MessageFormat("SetFlag: {0}"), new MessageFormat("TurnOn: {0}")};
    private static final MessageFormat kTurnOffTextFormat = new MessageFormat("SetFlag: {0}\nTurnOff: {0} \n");
    private static final MessageFormat[] kTurnOffTextFormatLines = new MessageFormat[]{new MessageFormat("SetFlag: {0}"), new MessageFormat("TurnOff: {0}")};
    final int fLineNumber;
    final String fFlagName;
    private final boolean fPermanent;
    private final String fLabel;
    private final boolean fIsActive;

    public GroupDatabaseDirective(IClassSchemaPolicy policy, IModuleFeedbackChannel moduleFeedbackChannel, DatabaseDirectiveInfo element) throws DGInvalidTracerNameException, InvalidClassNameException, InvalidMethodDescriptorException, InvalidMethodNameException {
        this.fLineNumber = element.getLineNumber();
        this.fFlagName = element.getGroupName();
        this.fPermanent = element.isPermanent();
        this.fIsActive = element.isActive();
        this.fLabel = element.getLabel();
    }

    public void IDirective_applyToSettings(CompilerSettingsBuilder builder) throws ValidationException {
        TracerGroupBuilder flag = null;
        try {
            if (this.getFlagName() != null) {
                flag = builder.getTracerGroupBuilder(this.getFlagName());
                flag.setDeclared(true);
                if (this.fIsActive) {
                    flag.setEnabled(this.fIsActive);
                } else {
                    flag.lockDisabled();
                }
            }
        }
        catch (DGInvalidFlagNameException dGInvalidFlagNameException) {
            throw new ValidationException((ILocalizableMessage)new FormattedLocalizableMessage(kInvalidFlag, this.fFlagName));
        }
    }

    private FlagName getFlagName() throws DGInvalidFlagNameException {
        return FlagName.getFlagName((String)this.fFlagName);
    }

    public int IDirective_getLineNumber() {
        return this.fLineNumber;
    }

    public String IDirective_getSource() {
        return "Database";
    }

    @Override
    public String getText() {
        if (this.fIsActive) {
            return kTurnOnTextFormat.format(new Object[]{this.fFlagName});
        }
        return kTurnOffTextFormat.format(new Object[]{this.fFlagName});
    }

    @Override
    public List getTextLines() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.fIsActive) {
            result.add(kTurnOnTextFormatLines[0].format(new Object[]{this.fFlagName}));
            result.add(kTurnOnTextFormatLines[1].format(new Object[]{this.fFlagName}));
        } else {
            result.add(kTurnOffTextFormatLines[0].format(new Object[]{this.fFlagName}));
            result.add(kTurnOffTextFormatLines[1].format(new Object[]{this.fFlagName}));
        }
        return result;
    }

    @Override
    public String getLabel() {
        return this.fLabel;
    }
}

