/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.platform.solaris;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.platform.ADefaultPlatformStatistics;
import com.wily.introscope.agent.platform.PlatformLibraryException;
import com.wily.introscope.agent.platform.PlatformLibraryNotSupportedException;
import com.wily.introscope.agent.platform.PlatformStatUnavailableException;
import com.wily.introscope.agent.platform.solaris.SolarisPlatformStatisticsBackEnd;
import com.wily.introscope.agent.platform.util.AggregateCPUUsageCalculator;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.wilyassert.Assertion;

public final class SolarisPlatformStatistics
extends ADefaultPlatformStatistics {
    private static final String[] kSupportedPlatforms = new String[]{"SolarisAmd32"};
    private final SolarisPlatformStatisticsBackEnd fBackEnd = new SolarisPlatformStatisticsBackEnd(this.IPlatformStatistics_getName());
    private AggregateCPUUsageCalculator[] fAggregateCPUUsageCalculator;

    public SolarisPlatformStatistics(String name, IAgent agent) throws PlatformLibraryException {
        super(name, agent, "libIntroscopeSolarisAmd32Stats.so");
        this.initialize();
    }

    public void checkSupportedPlatform(String platformName, String platformVersion) throws PlatformLibraryException {
        if (platformVersion != null && (platformName.startsWith("SunOS") || platformName.startsWith("Solaris"))) {
            String jvmarchitecture = System.getProperty("sun.arch.data.model");
            String jvmarch = "32";
            if (jvmarchitecture.startsWith("32")) {
                jvmarch = "32";
            } else if (jvmarchitecture.startsWith("64")) {
                jvmarch = "64";
            }
            String osarchitecture = System.getProperty("os.arch");
            if (osarchitecture != null) {
                platformName = osarchitecture.startsWith("sparc") ? "SolarisSparc" + jvmarch : "SolarisAmd" + jvmarch;
            }
        }
        if (platformName != null) {
            String[] supportedPlatforms = this.getSupportedPlatforms();
            for (int i = 0; i < supportedPlatforms.length; ++i) {
                if (!supportedPlatforms[i].equals(platformName)) continue;
                return;
            }
        }
        throw new PlatformLibraryNotSupportedException(new FormattedLocalizableMessage("Agent_Platform_Monitor_Unsupported_Platform_Message", this.IPlatformStatistics_getName(), platformName));
    }

    protected String[] getSupportedPlatforms() {
        return kSupportedPlatforms;
    }

    private void initialize() throws PlatformLibraryException {
        this.fBackEnd.initialize();
        this.registerDefaultStats();
    }

    protected void terminate() throws PlatformLibraryException {
        this.fBackEnd.terminate();
    }

    private SolarisPlatformStatisticsBackEnd getBackEnd() {
        return this.fBackEnd;
    }

    private void registerDefaultStats() {
        int cpuCount = 0;
        try {
            cpuCount = this.getBackEnd().getInstalledCPUCount();
            Assertion.wilyAssert(cpuCount >= 0);
        }
        catch (PlatformStatUnavailableException e) {
            cpuCount = 1;
        }
        this.fAggregateCPUUsageCalculator = new AggregateCPUUsageCalculator[cpuCount];
        for (int i = 0; i < cpuCount; ++i) {
            this.fAggregateCPUUsageCalculator[i] = new AggregateCPUUsageCalculator();
            long[] cpuStates = AggregateCPUUsageCalculator.kInitializedStatsArray;
            try {
                int osCPUName = this.IPlatformStatistics_mapLinearZeroBasedCPUIndexToOSName(i);
                cpuStates = this.getBackEnd().getAggregateCPUUsage(osCPUName);
            }
            catch (PlatformStatUnavailableException psue) {
                // empty catch block
            }
            this.fAggregateCPUUsageCalculator[i].setSnapshot(cpuStates);
        }
    }

    public void IPlatformStatistics_initializePlatformSpecificStatistics() throws PlatformLibraryException {
    }

    public long IPlatformStatistics_getProcessID() throws PlatformLibraryException, PlatformStatUnavailableException {
        long pid = this.fBackEnd.getProcessID();
        Assertion.wilyAssert(pid >= 0L);
        return pid;
    }

    public int IPlatformStatistics_getCPUCount() throws PlatformLibraryException, PlatformStatUnavailableException {
        int count = this.fBackEnd.getInstalledCPUCount();
        Assertion.wilyAssert(count > 0);
        return count;
    }

    public double IPlatformStatistics_getCPUUtilizationForCurrentProcess() throws PlatformLibraryException, PlatformStatUnavailableException {
        double usage = this.fBackEnd.getTotalCPUUsageByThisProcess();
        Assertion.wilyAssert(usage >= 0.0 && usage <= 100.0);
        return usage;
    }

    public int IPlatformStatistics_mapLinearZeroBasedCPUIndexToOSName(int linearZeroBasedIndex) {
        try {
            return this.getBackEnd().mapLinearZeroBasedCPUIndexToOSName(linearZeroBasedIndex);
        }
        catch (PlatformLibraryException ple) {
            this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Platform_Monitor_CPU_Name_Mapping_Failed_Message", this.IPlatformStatistics_getName(), Integer.toString(linearZeroBasedIndex)));
            return linearZeroBasedIndex;
        }
    }

    public void IPlatformStatistics_resetAggregateCPUUtilizationForProcessor(int linearZeroBasedIndex) throws PlatformLibraryException, PlatformStatUnavailableException {
        Assertion.wilyAssert(linearZeroBasedIndex >= 0 && linearZeroBasedIndex < this.fAggregateCPUUsageCalculator.length);
        if (linearZeroBasedIndex < 0 || linearZeroBasedIndex >= this.fAggregateCPUUsageCalculator.length) {
            throw new PlatformStatUnavailableException();
        }
        int osCPUName = this.IPlatformStatistics_mapLinearZeroBasedCPUIndexToOSName(linearZeroBasedIndex);
        long[] cpuStates = this.getBackEnd().getAggregateCPUUsage(osCPUName);
        this.fAggregateCPUUsageCalculator[linearZeroBasedIndex].setSnapshot(cpuStates);
    }

    public double IPlatformStatistics_getAggregateCPUUtilizationForProcessor(int linearZeroBasedIndex) throws PlatformLibraryException, PlatformStatUnavailableException {
        Assertion.wilyAssert(linearZeroBasedIndex >= 0 && linearZeroBasedIndex < this.fAggregateCPUUsageCalculator.length);
        if (linearZeroBasedIndex < 0 || linearZeroBasedIndex >= this.fAggregateCPUUsageCalculator.length) {
            throw new PlatformStatUnavailableException();
        }
        int osCPUName = this.IPlatformStatistics_mapLinearZeroBasedCPUIndexToOSName(linearZeroBasedIndex);
        long[] cpuStates = this.getBackEnd().getAggregateCPUUsage(osCPUName);
        return this.fAggregateCPUUsageCalculator[linearZeroBasedIndex].getAggregateCPUUsage(cpuStates);
    }

    public void IPlatformStatistics_resetCPUUtilizationForCurrentProcess() throws PlatformLibraryException, PlatformStatUnavailableException {
    }
}

