/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util;

import com.wily.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public final class LogFileUtilities {
    public static final char kIllegalCharReplacement = '_';
    public static final String kLogExtension = "log";
    public static final String kWellKnownLog4jLogFilePropKey = "log4j.appender.logfile.File";
    private static final String kTimestampFormatString = "yyyyMMdd-HHmmss";
    private static final SimpleDateFormat kTimestampFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
    public static final int kMaxRenameAppendFileLengthInBytes = 262144;
    private static final String kAppendFileTooLongSuffix = "old";

    private LogFileUtilities() {
    }

    public static String appendUniqueTimestampToLogFileName(String fileName) throws IOException {
        Calendar rightNow = Calendar.getInstance();
        String timestamp = kTimestampFormat.format(rightNow.getTime());
        fileName = LogFileUtilities.appendIdentifierToLogFileName(fileName, timestamp, false);
        fileName = LogFileUtilities.appendUniqueIdentifierToLogFile(fileName);
        return fileName;
    }

    public static String appendUniqueIdentifierToLogFile(String fileName) throws IOException {
        if (fileName == null) {
            return null;
        }
        File logFile = new File(fileName);
        int i = 1;
        boolean success;
        while (!(success = logFile.createNewFile())) {
            fileName = fileName.toLowerCase().endsWith(".log") ? fileName.substring(0, fileName.lastIndexOf(46)) + '_' + i + '.' + kLogExtension : fileName + '_' + i;
            logFile = new File(fileName);
            ++i;
        }
        return fileName;
    }

    private static String appendIdentifierToLogFileName(String fileName, String identifier, boolean replaceIllegalChars) {
        if (fileName == null) {
            return null;
        }
        if (replaceIllegalChars) {
            identifier = StringUtils.replaceNonAlphaNumericCharacters(identifier, '_');
        }
        fileName = fileName.toLowerCase().endsWith(".log") ? fileName.substring(0, fileName.lastIndexOf(46)) + '.' + identifier + '.' + kLogExtension : fileName + '.' + identifier + '.' + kLogExtension;
        return fileName;
    }

    public static String appendIdentifierToLogFileName(String fileName, String identifier) {
        return LogFileUtilities.appendIdentifierToLogFileName(fileName, identifier, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean renameLogFile(String oldFilename, String newFilename, boolean appendMode, int maxFileLengthInBytes) {
        File oldFile = new File(oldFilename);
        File newFile = new File(newFilename);
        FileOutputStream fos = null;
        FileInputStream fis = null;
        if (!oldFile.exists()) {
            return false;
        }
        boolean success = false;
        if (newFile.exists()) {
            if (appendMode) {
                if (oldFile.length() > (long)maxFileLengthInBytes) {
                    String renamedNewFilename = LogFileUtilities.appendIdentifierToLogFileName(newFilename, kAppendFileTooLongSuffix);
                    renamedNewFilename = LogFileUtilities.appendUniqueIdentifierToLogFile(renamedNewFilename);
                    File renamedNewFile = new File(renamedNewFilename);
                    renamedNewFile.delete();
                    newFile.renameTo(renamedNewFile);
                    success = oldFile.renameTo(newFile);
                } else {
                    fos = new FileOutputStream(newFilename, true);
                    fis = new FileInputStream(oldFile);
                    byte[] bytes = new byte[(int)oldFile.length()];
                    fis.read(bytes);
                    fos.write(bytes);
                    fis.close();
                    fos.close();
                    oldFile.delete();
                    success = true;
                }
            } else {
                newFile.delete();
                success = oldFile.renameTo(newFile);
            }
        } else {
            success = oldFile.renameTo(newFile);
        }
        boolean bl = success;
        Object var12_14 = null;
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (IOException ioe2) {
            // empty catch block
        }
        try {
            if (fos != null) {
                fos.close();
            }
        }
        catch (IOException ioe2) {
            // empty catch block
        }
        return bl;
        catch (IOException ioe) {
            boolean bl2;
            try {
                bl2 = false;
                Object var12_15 = null;
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException ioe2) {}
                throw throwable;
            }
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ioe2) {
                // empty catch block
            }
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ioe2) {
                // empty catch block
            }
            return bl2;
        }
    }

    public static void ensureLogFilePath(String desiredPath) {
        if (desiredPath != null) {
            try {
                File file = new File(desiredPath).getParentFile();
                if (file != null && !file.exists()) {
                    file.mkdirs();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

