/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.concurrent;

import com.wily.EDU.oswego.cs.dl.util.concurrent.BoundedLinkedQueue;
import com.wily.EDU.oswego.cs.dl.util.concurrent.Executor;
import com.wily.util.concurrent.DebuggableQueue;
import com.wily.util.concurrent.IExecutionQueue;
import com.wily.util.concurrent.IPriorityExecutor;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.wilyassert.Assertion;
import java.util.ArrayList;
import java.util.List;

public class PrioritizedExecutionQueue
extends DebuggableQueue
implements IExecutionQueue,
Executor {
    static final int kQueueRunningState = 1;
    static final int kQueueStoppingState = 2;
    static final int kQueueStoppedState = 4;
    static final int kQueuePausedState = 8;
    static final int kQueueCanEnqueueMask = 9;
    static final int kQueueCanRunMask = 3;
    private final Object fQueueSpaceFreed = new Object();
    private BoundedLinkedQueue fInternalQueue;
    private int fQueuePriority;
    private IPriorityExecutor fExecutor;
    private int fMaxParallelExecutors;
    private int fNumCurrentWorkers;
    private int fQueueState;
    private IModuleFeedbackChannel fFeedback;

    public PrioritizedExecutionQueue(String queueName, IModuleFeedbackChannel feedback, int priority, IPriorityExecutor executor, int maxParallelism) {
        super(queueName, feedback);
        this.fFeedback = feedback;
        this.fQueuePriority = priority;
        this.fExecutor = executor;
        this.fNumCurrentWorkers = 0;
        this.fMaxParallelExecutors = maxParallelism;
        this.fQueueState = 1;
        this.fInternalQueue = new BoundedLinkedQueue(Integer.MAX_VALUE);
    }

    private synchronized boolean enqueue(Runnable command) {
        try {
            if (!this.fInternalQueue.offer((Object)command, 0L)) {
                this.fFeedback.verbose("Failed to enqueue data to running queue " + this.fQueueName);
                this.logDroppedCommand(command);
                return false;
            }
        }
        catch (InterruptedException e) {
            this.fFeedback.verbose(e);
            this.logDroppedCommand(command);
            return false;
        }
        this.logGrowth(this.fInternalQueue.size());
        this.askForWorkers();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueAndWait(Runnable command) {
        NotifyWhenDone notifyCommand;
        NotifyWhenDone notifyWhenDone = notifyCommand = new NotifyWhenDone(command);
        synchronized (notifyWhenDone) {
            try {
                while (!this.enqueue(notifyCommand)) {
                    Object object = this.fQueueSpaceFreed;
                    synchronized (object) {
                        this.fQueueSpaceFreed.wait();
                    }
                }
                notifyCommand.wait();
            }
            catch (InterruptedException e) {
                this.fFeedback.warn("Execution queue " + this.fQueueName + " threw an exception.", e);
            }
        }
    }

    private void askForWorkers() {
        if ((this.fQueueState & 3) != 0) {
            for (int numToRequest = (availableWorkers = this.fMaxParallelExecutors - this.fNumCurrentWorkers) < (queueSize = this.fInternalQueue.size() - this.fNumCurrentWorkers) ? availableWorkers : queueSize; numToRequest > 0; --numToRequest) {
                try {
                    this.fExecutor.IPriorityExecutor_execute(new WorkerRequest(), this.fQueuePriority);
                    ++this.fNumCurrentWorkers;
                    continue;
                }
                catch (InterruptedException e) {
                    this.fFeedback.verbose(e);
                    Assertion.wilyAssert((this.fQueueState & 3) == 0, "Queue state = " + this.fQueueState);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWork() {
        Runnable command = null;
        Object object = this;
        synchronized (object) {
            if ((this.fQueueState & 3) != 0) {
                try {
                    command = (Runnable)this.fInternalQueue.poll(0L);
                }
                catch (InterruptedException e) {
                    this.fFeedback.verbose("Execution thread caught InterruptedException when polling for work");
                }
            }
        }
        if (command != null) {
            object = this.fQueueSpaceFreed;
            synchronized (object) {
                this.fQueueSpaceFreed.notifyAll();
            }
            this.logShrink(this.fInternalQueue.size());
            try {
                command.run();
            }
            catch (Throwable t) {
                this.fFeedback.error(t);
            }
        }
        object = this;
        synchronized (object) {
            --this.fNumCurrentWorkers;
            this.askForWorkers();
        }
    }

    public final int getQueuePriority() {
        return this.fQueuePriority;
    }

    public final void setQueuePriority(int priority) {
        this.fQueuePriority = priority;
    }

    public void IExecutionQueue_setMaxQueueSize(int upperLimit) {
        this.fInternalQueue.setCapacity(upperLimit);
    }

    public final void execute(Runnable command) {
        this.IExecutionQueue_enqueue(command);
    }

    public final void IExecutionQueue_enqueue(Runnable command) {
        if ((this.fQueueState & 9) != 0) {
            this.enqueue(command);
        }
    }

    public void IExecutionQueue_enqueueAndWait(Runnable command) {
        if ((this.fQueueState & 9) != 0) {
            this.enqueueAndWait(command);
        }
    }

    public void IExecutionQueue_stop() {
        this.fQueueState = 4;
    }

    public void IExecutionQueue_pause() {
        this.fQueueState = 8;
    }

    public void IExecutionQueue_drainAndStop() {
        this.fQueueState = 2;
        this.enqueueAndWait(new Marker());
        this.fQueueState = 4;
    }

    public synchronized List IExecutionQueue_drain() {
        ArrayList<Object> l = new ArrayList<Object>(this.fInternalQueue.size());
        while (true) {
            Object command;
            try {
                command = this.fInternalQueue.poll(0L);
            }
            catch (InterruptedException t) {
                return l;
            }
            if (command == null) {
                return l;
            }
            l.add(command);
        }
    }

    public synchronized void IExecutionQueue_start() {
        this.fQueueState = 1;
        this.askForWorkers();
    }

    public void IExecutionQueue_syncWithQueue() {
        if ((this.fQueueState & 9) != 0) {
            this.enqueueAndWait(new Marker());
        }
    }

    private static final class Marker
    implements Runnable {
        public void run() {
        }
    }

    private static final class NotifyWhenDone
    implements Runnable {
        Runnable fCommand;

        public NotifyWhenDone(Runnable command) {
            this.fCommand = command;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            NotifyWhenDone notifyWhenDone;
            try {
                this.fCommand.run();
                Object var2_1 = null;
                notifyWhenDone = this;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                NotifyWhenDone notifyWhenDone2 = this;
                synchronized (notifyWhenDone2) {
                    this.notifyAll();
                }
                throw throwable;
            }
            synchronized (notifyWhenDone) {
                this.notifyAll();
            }
        }
    }

    private class WorkerRequest
    implements Runnable {
        public final void run() {
            PrioritizedExecutionQueue.this.doWork();
        }

        public String toString() {
            Runnable command = (Runnable)PrioritizedExecutionQueue.this.fInternalQueue.peek();
            if (command != null) {
                return command.toString();
            }
            return "{Empty Command}";
        }
    }
}

