/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.extension;

import com.wily.util.io.IConstructorExternalizable;
import com.wily.util.io.NonSyncBufferedInputStream;
import com.wily.wilyassert.Assertion;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class InMemoryJarFile
implements IConstructorExternalizable {
    private String fName;
    private Attributes fAttributes;
    private HashMap fManifest = new HashMap();
    private HashMap fContents = new HashMap();

    public InMemoryJarFile(ObjectInput in) throws ClassNotFoundException, IOException {
        this.fName = in.readUTF();
        this.fManifest = (HashMap)in.readObject();
        this.fContents = (HashMap)in.readObject();
        this.fAttributes = this.readAttributes(in);
    }

    public InMemoryJarFile(JarFile file) throws IOException {
        this.fName = file.getName();
        Manifest manifest = file.getManifest();
        this.fAttributes = manifest.getMainAttributes();
        this.fManifest.putAll(manifest.getEntries());
        Enumeration<JarEntry> i = file.entries();
        while (i.hasMoreElements()) {
            JarEntry entry = i.nextElement();
            String name = entry.getName();
            NonSyncBufferedInputStream input = new NonSyncBufferedInputStream(file.getInputStream(entry));
            byte[] data = input.readAvailable();
            input.close();
            this.fContents.put(name, data);
            Assertion.wilyAssert((long)data.length == entry.getSize());
        }
    }

    public Map getManifestMap() {
        return this.fManifest;
    }

    public byte[] getBytesForFile(String resource) {
        return (byte[])this.fContents.get(resource);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.fName);
        out.writeObject(this.fManifest);
        out.writeObject(this.fContents);
        this.writeAttributes(out, this.fAttributes);
    }

    public Attributes getMainAttributes() {
        return this.fAttributes;
    }

    public String getName() {
        return this.fName;
    }

    private Attributes readAttributes(ObjectInput in) throws IOException {
        Attributes values = new Attributes();
        int num = in.readInt();
        for (int i = 0; i < num; ++i) {
            String name = in.readUTF();
            String value = in.readUTF();
            values.putValue(name, value);
        }
        return values;
    }

    private void writeAttributes(ObjectOutput out, Attributes attributes) throws IOException {
        Set<Map.Entry<Object, Object>> entrySet = attributes.entrySet();
        out.writeInt(entrySet.size());
        Iterator<Map.Entry<Object, Object>> i = entrySet.iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Object> entry = i.next();
            Attributes.Name name = (Attributes.Name)entry.getKey();
            String value = (String)entry.getValue();
            out.writeUTF(name.toString());
            out.writeUTF(value);
        }
    }
}

