/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.io;

import com.wily.wilyassert.Assertion;
import java.io.IOException;
import java.io.Reader;

public class NonSyncBufferedReader
extends Reader {
    private Reader fBaseReader;
    private char[] fReadCache;
    private int fReadCachePosition;
    private int fReadCacheLength;

    public NonSyncBufferedReader(Reader baseReader) {
        this.fBaseReader = baseReader;
        this.fReadCache = new char[1024];
    }

    private void fill() throws IOException {
        this.fReadCachePosition = 0;
        this.fReadCacheLength = this.fBaseReader.read(this.fReadCache);
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        if (this.fReadCachePosition < this.fReadCacheLength) {
            return this.fReadCache[this.fReadCachePosition++];
        }
        if (this.fReadCachePosition == this.fReadCacheLength) {
            this.fill();
            return this.read();
        }
        return -1;
    }

    public boolean ready() throws IOException {
        return true;
    }

    public void reset() throws IOException {
        this.fReadCachePosition = 0;
        this.fReadCacheLength = 0;
        this.fBaseReader.reset();
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        Assertion.unimplemented("I haven't tested this yet - jgochee");
        if (this.fReadCachePosition == this.fReadCacheLength) {
            this.fill();
        }
        if (this.fReadCacheLength == -1) {
            return -1;
        }
        int numToRead = Math.min(this.fReadCacheLength - this.fReadCachePosition, len);
        System.arraycopy(this.fReadCache, this.fReadCachePosition, cbuf, off, numToRead);
        this.fReadCachePosition += numToRead;
        return numToRead;
    }

    public void close() throws IOException {
        this.fBaseReader.close();
    }
}

