/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.appmap.agent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.blame.IAllocatorChangeListener;
import com.wily.introscope.agent.blame.IAppMapStack;
import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.blame.IBlameStackAllocator;
import com.wily.introscope.agent.blame.IStackType;
import com.wily.introscope.agent.extension.ExtensionAdministrator;
import com.wily.introscope.agent.service.IAgentService;
import com.wily.introscope.agent.trace.ITraceSupport;
import com.wily.introscope.agent.trace.ITraceSupportFactory;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.appmap.agent.AppMapStack;
import com.wily.introscope.appmap.agent.trace.hc2.AppMapReplayer;
import com.wily.introscope.extension.PlatformCheckUtil;
import com.wily.introscope.spec.agent.beans.appmap.IAppMapDecisionSupportBean;
import com.wily.introscope.stat.blame.BlameStackSnapshotPolicy;
import com.wily.util.adt.IGuaranteedCounter;
import com.wily.util.extension.IPlugin;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.properties.hot.PositiveIntegerConfigurationProperty;
import com.wily.util.properties.hot.StringSetConfigurationProperty;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.util.Map;
import java.util.Set;

public class AppMapService
implements IAgentService {
    private static final String kDefaulWebServiceDependencyMapServiceEntryPoint = "com.wily.introscope.agent.extensions.service.MapTracingService";
    private static final String kClassStackTypeString = "Class";
    private static final String kClassMethodStackTypeString = "MethodClass";
    private static final String kOwnerTypeBTString = "BusinessTransactionComponent";
    private static final String kOwnerTypeAppString = "Application";
    private static volatile IAppMapDecisionSupportBean kOracle;
    public static final IStackType kStackTypeClassMethodApp;
    public static final IStackType kStackTypeClassApp;
    public static final IStackType kStackTypeClassMethodBT;
    public static final IStackType kStackTypeClassBT;
    public static final int kDefaultConsecutiveErrors = 3;
    private static final int kDelayOnRestartAppMap = 1800000;
    private static final String kAppMapEnablingProperty = "introscope.agent.appmap.enabled";
    private static final String kMetricsEnablingProperty = "introscope.agent.appmap.metrics.enabled";
    private static final String kCatalystEnablingProperty = "introscope.agent.appmap.catalystIntegration.enabled";
    private static final String kIntermediateNodesEnablingProperty = "introscope.agent.appmap.intermediateNodes.enabled";
    private static final String kOwnersEnablingProperty = "introscope.agent.appmap.owners.enabled";
    private static final String kLevelsEnablingProperty = "introscope.agent.appmap.levels.enabled";
    private static final String kNumberOfConsecutiveErrorsProperty = "introscope.agent.appmap.consecutiveerrors.max";
    private static final String kShutdownOnMaxErrorsProperty = "introscope.agent.appmap.consecutiveerrors.shutdown";
    private static final String kRestartDelayOnMaxErrorsProperty = "introscope.agent.appmap.consecutiveerrors.restart.delay";
    private static final Module kAppMapServiceModule;
    private static volatile DependencyMapEnabledConfigurationProperty fIsEnabledProperty;
    private static volatile MetricsEnabledConfigurationProperty fMetricsEnabledProperty;
    private static volatile CatalystIntegrationEnabledConfigurationProperty fCatalystEnabledProperty;
    private static volatile IntermediateNodesEnabledConfigurationProperty fIntermediateNodesEnabledProperty;
    private static final IBlameStackAllocator fAllocatorClassMethodLevel;
    private static final IBlameStackAllocator fAllocatorClassLevel;
    private static final IBlameStackAllocator fAllocatorBTClassMethodLevel;
    private static final IBlameStackAllocator fAllocatorBTClassLevel;
    private static volatile int fDelayOnRestartAppMap;
    private final IBlameStackAllocator[] fAllAllocators = new IBlameStackAllocator[4];
    private static volatile IAgent fAgent;
    private static volatile boolean fIsRegistered;
    private static volatile boolean fHasStarted;
    public static volatile int fMaxConsecutiveErrors;
    private static volatile boolean fShutdownOnMaxErrors;
    private static volatile IGuaranteedCounter fConsecutiveProblems;
    private static volatile Set fEnabledOwners;
    private static volatile Set fEnabledLevels;
    private static volatile boolean fIsCrossProcessSupportRequired;
    private static volatile boolean fRequiresReplayedAtCrossProcessExit;

    static {
        kStackTypeClassMethodApp = new IStackType(){};
        kStackTypeClassApp = new IStackType(){};
        kStackTypeClassMethodBT = new IStackType(){};
        kStackTypeClassBT = new IStackType(){};
        kAppMapServiceModule = new Module("AppMapService");
        fDelayOnRestartAppMap = 1800000;
        fIsRegistered = false;
        fHasStarted = false;
        fMaxConsecutiveErrors = 3;
        fAllocatorClassMethodLevel = new IBlameStackAllocator(){

            public void addAllocatorChangeListener(IAllocatorChangeListener listener) {
            }

            public IBlameStack allocateBlameStack(BlameStackSnapshotPolicy policy) {
                return new AppMapStack(fAgent, kStackTypeClassMethodApp, AppMapService.kClassMethodStackTypeString, AppMapService.kOwnerTypeAppString, AppMapService.getOracleInstance());
            }
        };
        fAllocatorClassLevel = new IBlameStackAllocator(){

            public void addAllocatorChangeListener(IAllocatorChangeListener listener) {
            }

            public IBlameStack allocateBlameStack(BlameStackSnapshotPolicy policy) {
                return new AppMapStack(fAgent, kStackTypeClassApp, AppMapService.kClassStackTypeString, AppMapService.kOwnerTypeAppString, AppMapService.getOracleInstance());
            }
        };
        fAllocatorBTClassMethodLevel = new IBlameStackAllocator(){

            public void addAllocatorChangeListener(IAllocatorChangeListener listener) {
            }

            public IBlameStack allocateBlameStack(BlameStackSnapshotPolicy policy) {
                return new AppMapStack(fAgent, kStackTypeClassMethodBT, AppMapService.kClassMethodStackTypeString, AppMapService.kOwnerTypeBTString, AppMapService.getOracleInstance());
            }
        };
        fAllocatorBTClassLevel = new IBlameStackAllocator(){

            public void addAllocatorChangeListener(IAllocatorChangeListener listener) {
            }

            public IBlameStack allocateBlameStack(BlameStackSnapshotPolicy policy) {
                return new AppMapStack(fAgent, kStackTypeClassBT, AppMapService.kClassStackTypeString, AppMapService.kOwnerTypeBTString, AppMapService.getOracleInstance());
            }
        };
    }

    public AppMapService() {
        this.fAllAllocators[0] = fAllocatorClassMethodLevel;
        this.fAllAllocators[1] = fAllocatorClassLevel;
        this.fAllAllocators[2] = fAllocatorBTClassMethodLevel;
        this.fAllAllocators[3] = fAllocatorBTClassLevel;
    }

    public final int IAgentService_getServiceVersion() {
        return 2;
    }

    public final synchronized void IAgentService_startService(IAgent agent, Map parameters) throws Exception {
        fAgent = agent;
        fConsecutiveProblems = fAgent.IAgent_getGuaranteedCounter();
        ITraceSupportFactory oracleSingleton = null;
        oracleSingleton = PlatformCheckUtil.getInstance().isOsgiEnvironment() ? agent.IAgent_getTracerAdministrator().loadTraceSupportOSGi("AppMapOracleFactory", "") : agent.IAgent_getTracerAdministrator().loadTraceSupport("com.wily.introscope.spec.server.appmap.impl.AppMapOracleFactory", "");
        DependencyMapEnabledConfigurationProperty appMapEnabledChecker = new DependencyMapEnabledConfigurationProperty(agent);
        if (!appMapEnabledChecker.isEnabled()) {
            agent.IAgent_getModuleFeedback().info(kAppMapServiceModule, "App Map Service is disabled.");
            return;
        }
        ITraceSupport oracleCandidate = oracleSingleton.getTraceSupportInstance();
        if (oracleCandidate != null && oracleCandidate instanceof IAppMapDecisionSupportBean) {
            kOracle = (IAppMapDecisionSupportBean)oracleCandidate;
            boolean isWebsphereCrossProcess = agent.IAgent_getIndexedProperties().getBooleanProperty("introscope.agent.websphere.crossjvm", false);
            boolean isAppMapForcedCrossProcess = agent.IAgent_getIndexedProperties().getBooleanProperty("introscope.agent.genericAppMapSupport.crossjvm", false);
            fIsCrossProcessSupportRequired = isAppMapForcedCrossProcess || isWebsphereCrossProcess;
            boolean runsOnOldConfig = AppMapService.getAgent().IAgent_getComponentTracer().isAgentOldMode();
            boolean hasDependencyMapPlugin = false;
            ExtensionAdministrator extensionAdministrator = agent.IAgent_getExtensionAdministrator();
            Assertion.wilyAssert((boolean)false);
            IPlugin[] plugins = extensionAdministrator.getAgentPluginsByType("service synch");
            int i = 0;
            while (i < plugins.length) {
                if (plugins[i] != null && plugins[i].IPlugin_getEntryPointClassName().equals(kDefaulWebServiceDependencyMapServiceEntryPoint)) {
                    hasDependencyMapPlugin = true;
                    break;
                }
                ++i;
            }
            boolean bl = fRequiresReplayedAtCrossProcessExit = !runsOnOldConfig && (!fIsCrossProcessSupportRequired || hasDependencyMapPlugin);
            if (fIsEnabledProperty == null) {
                fIsEnabledProperty = new DependencyMapEnabledConfigurationProperty(agent);
                fMetricsEnabledProperty = new MetricsEnabledConfigurationProperty(agent);
                fCatalystEnabledProperty = new CatalystIntegrationEnabledConfigurationProperty(agent);
                fIntermediateNodesEnabledProperty = new IntermediateNodesEnabledConfigurationProperty(agent);
                ConfigurationManager cm = fAgent.IAgent_getConfigurationManager();
                cm.add((ConfigurationProperty)fIsEnabledProperty, true);
                cm.add((ConfigurationProperty)fMetricsEnabledProperty, true);
                cm.add((ConfigurationProperty)fCatalystEnabledProperty, true);
                cm.add((ConfigurationProperty)fIntermediateNodesEnabledProperty, true);
                cm.add((ConfigurationProperty)new NumberOfConsecutiveErrorProperty(agent), true);
                cm.add((ConfigurationProperty)new DelayOnRestartProperty(agent), true);
                cm.add((ConfigurationProperty)new ShutdownOnMaxErrorsProperty(agent), true);
                cm.add((ConfigurationProperty)new TraceOwnersConfigurationProperty(kOwnersEnablingProperty, agent.IAgent_getModuleFeedback(), kAppMapServiceModule, agent.IAgent_getStringLocalizer(), agent), true);
                cm.add((ConfigurationProperty)new TraceLevelsConfigurationProperty(kLevelsEnablingProperty, agent.IAgent_getModuleFeedback(), kAppMapServiceModule, agent.IAgent_getStringLocalizer(), agent), true);
                if (fRequiresReplayedAtCrossProcessExit && AppMapService.isAppMapEnabled()) {
                    this.addCrossProcessReplayCallback();
                }
            }
            agent.IAgent_getModuleFeedback().info(kAppMapServiceModule, "App Map Service has started");
            fHasStarted = true;
        } else {
            agent.IAgent_getModuleFeedback().warn(kAppMapServiceModule, "App Map Service has not started");
        }
    }

    private void registerBlameStack() {
        if (fIsEnabledProperty.isEnabled() && !fIsRegistered) {
            fAgent.IAgent_getModuleFeedback().info(kAppMapServiceModule, "App Map Stack has been enabled");
            int i = 0;
            while (i < this.fAllAllocators.length) {
                fAgent.IAgent_getComponentTracer().addBlameStackAllocator(this.fAllAllocators[i]);
                ++i;
            }
            fIsRegistered = true;
            kOracle.reportEnvironmentInformation(true);
        } else if (!fIsEnabledProperty.isEnabled() && fIsRegistered) {
            fAgent.IAgent_getModuleFeedback().info(kAppMapServiceModule, "App Map Stack has been disabled");
            ComponentTracer tracer = fAgent.IAgent_getComponentTracer();
            if (tracer != null) {
                try {
                    int i = 0;
                    while (i < this.fAllAllocators.length) {
                        fAgent.IAgent_getComponentTracer().removeBlameStackAllocator(this.fAllAllocators[i]);
                        ++i;
                    }
                    fIsRegistered = false;
                }
                catch (Throwable throwable) {}
            }
            kOracle.reportEnvironmentInformation(true);
        }
    }

    private void addCrossProcessReplayCallback() {
        AppMapService.getAgent().IAgent_getModuleFeedback().info(kAppMapServiceModule, "App Map Service is adding the callback for replying in cross process");
        SharedCrossProcessData.addCrossProcessDataCallback((SharedCrossProcessData.ICrossProcessDataCallBack)new SharedCrossProcessData.ICrossProcessDataCallBack(){

            public void prepareOptionalParameters(SharedCrossProcessData data) {
                AppMapReplayer.replayAppNamesCrossProcess(fAgent, data);
            }
        });
    }

    public static boolean isAppMapEnabled() {
        return fIsEnabledProperty.isEnabled();
    }

    public static IAppMapDecisionSupportBean getOracleInstance() {
        return kOracle;
    }

    public static IAgent getAgent() {
        return fAgent;
    }

    public static IStackType getStackType(String hierarchyLevelString, String ownerTypeString) {
        if (kClassStackTypeString.equals(hierarchyLevelString)) {
            if (kOwnerTypeBTString.equals(ownerTypeString)) {
                return kStackTypeClassBT;
            }
            return kStackTypeClassApp;
        }
        if (kClassMethodStackTypeString.equals(hierarchyLevelString)) {
            if (kOwnerTypeBTString.equals(ownerTypeString)) {
                return kStackTypeClassMethodBT;
            }
            return kStackTypeClassMethodApp;
        }
        return null;
    }

    public static IAppMapStack getStack(IStackType type) {
        if (type == kStackTypeClassMethodApp) {
            return (IAppMapStack)fAllocatorClassMethodLevel.allocateBlameStack(null);
        }
        if (type == kStackTypeClassMethodBT) {
            return (IAppMapStack)fAllocatorBTClassMethodLevel.allocateBlameStack(null);
        }
        if (type == kStackTypeClassApp) {
            return (IAppMapStack)fAllocatorClassLevel.allocateBlameStack(null);
        }
        if (type == kStackTypeClassBT) {
            return (IAppMapStack)fAllocatorBTClassLevel.allocateBlameStack(null);
        }
        return null;
    }

    public static boolean hasStarted() {
        return fHasStarted;
    }

    public static boolean areMetricsEnabled() {
        return fMetricsEnabledProperty.isEnabled();
    }

    public static boolean isCatalystIntegrationEnabled() {
        return fCatalystEnabledProperty.isEnabled();
    }

    public static boolean isIntermediateNodesEnabled() {
        return fIntermediateNodesEnabledProperty.isEnabled();
    }

    public static boolean isOwnerTypeEnabled(String owner) {
        return fEnabledOwners != null && fEnabledOwners.contains(owner);
    }

    public static boolean isLevelEnabled(String level) {
        return fEnabledLevels != null && fEnabledLevels.contains(level);
    }

    public static boolean isCrossProcessSupportRequired() {
        return fIsCrossProcessSupportRequired;
    }

    public static int getMaxConsecutiveErrors() {
        return fMaxConsecutiveErrors;
    }

    public static void evaluateShutdown() {
        if (fShutdownOnMaxErrors) {
            fIsEnabledProperty.set(Boolean.FALSE);
            AppMapService.getAgent().IAgent_getCommonHeartbeat().addBehavior(new ITimestampedRunnable(){

                public void ITimestampedRunnable_execute(long nowInMillis) {
                    boolean isSetInProperties = AppMapService.getAgent().IAgent_getIndexedProperties().getBooleanProperty(AppMapService.kAppMapEnablingProperty);
                    fIsEnabledProperty.set(isSetInProperties ? Boolean.TRUE : Boolean.FALSE);
                }
            }, "wait for app map resolution", true, (long)fDelayOnRestartAppMap, false);
        }
    }

    public static IGuaranteedCounter getConsecutiveProblems() {
        return fConsecutiveProblems;
    }

    public static boolean isRequiresReplayedAtCrossProcessExit() {
        return fRequiresReplayedAtCrossProcessExit;
    }

    private static final class CatalystIntegrationEnabledConfigurationProperty
    extends BooleanConfigurationProperty {
        volatile boolean value;

        private CatalystIntegrationEnabledConfigurationProperty(IAgent agent) {
            super(AppMapService.kCatalystEnablingProperty, Boolean.FALSE, agent.IAgent_getModuleFeedback(), kAppMapServiceModule, agent.IAgent_getStringLocalizer());
        }

        public final boolean isEnabled() {
            return this.value;
        }

        public void set(Object newValue) {
            this.value = (Boolean)newValue;
        }
    }

    private static final class DelayOnRestartProperty
    extends PositiveIntegerConfigurationProperty {
        private DelayOnRestartProperty(IAgent agent) {
            super(AppMapService.kRestartDelayOnMaxErrorsProperty, Integer.valueOf(1800000), agent.IAgent_getModuleFeedback(), kAppMapServiceModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            fDelayOnRestartAppMap = (Integer)newValue;
        }
    }

    private final class DependencyMapEnabledConfigurationProperty
    extends BooleanConfigurationProperty {
        boolean value;

        private DependencyMapEnabledConfigurationProperty(IAgent agent) {
            super(AppMapService.kAppMapEnablingProperty, Boolean.FALSE, agent.IAgent_getModuleFeedback(), kAppMapServiceModule, agent.IAgent_getStringLocalizer());
        }

        public boolean isEnabled() {
            return this.value;
        }

        public void set(Object newValue) {
            this.value = (Boolean)newValue;
            AppMapService.this.registerBlameStack();
        }
    }

    private static final class IntermediateNodesEnabledConfigurationProperty
    extends BooleanConfigurationProperty {
        volatile boolean value;

        private IntermediateNodesEnabledConfigurationProperty(IAgent agent) {
            super(AppMapService.kIntermediateNodesEnablingProperty, Boolean.FALSE, agent.IAgent_getModuleFeedback(), kAppMapServiceModule, agent.IAgent_getStringLocalizer());
        }

        public final boolean isEnabled() {
            return this.value;
        }

        public void set(Object newValue) {
            this.value = (Boolean)newValue;
        }
    }

    private static final class MetricsEnabledConfigurationProperty
    extends BooleanConfigurationProperty {
        volatile boolean value;

        private MetricsEnabledConfigurationProperty(IAgent agent) {
            super(AppMapService.kMetricsEnablingProperty, Boolean.FALSE, agent.IAgent_getModuleFeedback(), kAppMapServiceModule, agent.IAgent_getStringLocalizer());
        }

        public final boolean isEnabled() {
            return this.value;
        }

        public void set(Object newValue) {
            this.value = (Boolean)newValue;
        }
    }

    private static final class NumberOfConsecutiveErrorProperty
    extends PositiveIntegerConfigurationProperty {
        private NumberOfConsecutiveErrorProperty(IAgent agent) {
            super(AppMapService.kNumberOfConsecutiveErrorsProperty, Integer.valueOf(3), agent.IAgent_getModuleFeedback(), kAppMapServiceModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            fMaxConsecutiveErrors = (Integer)newValue;
        }
    }

    private static final class ShutdownOnMaxErrorsProperty
    extends BooleanConfigurationProperty {
        private ShutdownOnMaxErrorsProperty(IAgent agent) {
            super(AppMapService.kShutdownOnMaxErrorsProperty, Boolean.TRUE, agent.IAgent_getModuleFeedback(), kAppMapServiceModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            fShutdownOnMaxErrors = (Boolean)newValue;
        }
    }

    static final class TraceLevelsConfigurationProperty
    extends StringSetConfigurationProperty {
        private final IAgent agent;

        private TraceLevelsConfigurationProperty(String name, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer, IAgent agent) {
            super(name, feedback, module, localizer);
            this.agent = agent;
        }

        public final void set(Object value) {
            Set cv = (Set)value;
            fEnabledLevels = cv == null || cv.size() == 0 ? null : cv;
        }
    }

    static final class TraceOwnersConfigurationProperty
    extends StringSetConfigurationProperty {
        private final IAgent agent;

        private TraceOwnersConfigurationProperty(String name, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer, IAgent agent) {
            super(name, feedback, module, localizer);
            this.agent = agent;
        }

        public final void set(Object value) {
            Set cv = (Set)value;
            fEnabledOwners = cv == null || cv.size() == 0 ? null : cv;
        }
    }
}

