/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.appmap.agent.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.activation.IOSGiClassPlugin;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.IMetricNameFormatListener;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.appmap.agent.AppMapService;
import com.wily.introscope.appmap.agent.trace.AppMapNameHelperFactory;
import com.wily.introscope.appmap.agent.trace.IAppMapNameHelper;
import com.wily.introscope.spec.server.appmap.IAppMapOwner;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;

public class AppMapApplicationNameTracer
extends ASingleInstanceTracerFactory
implements IOSGiClassPlugin {
    private static final String kName = "AppMapApplicationNameTracer";
    private static final Module kModule = new Module("AppMapApplicationNameTracer");
    public static final String kNewAppMapNameKey = "AppMap.NewName";
    private boolean fTracingEnabled;
    private boolean fIsShutoff = false;
    private String fOwnerType;
    private IAppMapNameHelper fNameHelper = null;

    public AppMapApplicationNameTracer() {
    }

    public AppMapApplicationNameTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.fOwnerType = this.getParameter("ownerType");
        boolean bl = this.fIsShutoff = this.fOwnerType == null || !"Application".equals(this.fOwnerType) && !"BusinessTransactionComponent".equals(this.fOwnerType);
        if (!this.fIsShutoff) {
            try {
                this.fIsShutoff = false;
            }
            catch (Throwable t) {
                this.getAgent().IAgent_getModuleFeedback().warn(kModule, "Tracer failed initialization");
                this.getAgent().IAgent_getModuleFeedback().verbose(kModule, "Tracer failed initialization", t);
                this.fIsShutoff = true;
            }
        }
        if (this.fIsShutoff) {
            this.getAgent().IAgent_getModuleFeedback().warn("Tracer " + this.getNameParameter() + " cannot execute because of wrong owner type parameter " + this.fOwnerType);
        }
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (!this.fTracingEnabled) {
            return;
        }
        IBlameStack stack = data.getStack(this.getComponentTracer(), true);
        if (this.getComponentTracer().getSamplingSkipFlag(stack)) {
            if (data.getSamplingTracer() == tracerIndex) {
                this.getComponentTracer().setSamplingSkipFlag(stack, false);
            }
            return;
        }
        SharedCrossProcessData cache = AppMapApplicationNameTracer.getSharedProcessDataCache();
        this.getNameHelper().popCurrentOwnerName(cache);
    }

    private IAppMapNameHelper getNameHelper() {
        if (this.fNameHelper == null) {
            this.fNameHelper = AppMapNameHelperFactory.getNameHelper(this.getAgent(), this.fOwnerType);
        }
        return this.fNameHelper;
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        boolean bl = this.fTracingEnabled = !this.ITracerFactory_isShutoff();
        if (!this.fTracingEnabled) {
            return;
        }
        IBlameStack stack = data.getStack(this.getComponentTracer(), true);
        if (this.getComponentTracer().getSamplingSkipFlag(stack)) {
            return;
        }
        IAppMapOwner currentOwner = this.getNameHelper().peekCurrentOwnerName();
        if (currentOwner == null && this.getComponentTracer().setSamplingTracer(data, tracerIndex) && this.getComponentTracer().checkSamplingCounter()) {
            this.getComponentTracer().setSamplingSkipFlag(stack, true);
            return;
        }
        IAppMapOwner owner = this.getOwner(data);
        if (owner != null) {
            if (currentOwner == null || !currentOwner.equals(owner)) {
                data.put(kNewAppMapNameKey, (Object)Boolean.TRUE);
            }
            this.getNameHelper().pushCurrentOwnerName(AppMapApplicationNameTracer.getSharedProcessDataCache(), owner);
        }
    }

    protected IAppMapOwner getOwner(InvocationData data) {
        IAppMapOwner owner = this.getOwnerFromInvocationObject(data);
        if (!owner.isNullInstance()) {
            return owner;
        }
        owner = this.getOwnerFromConfiguration();
        if (owner != null && !owner.isNullInstance()) {
            return owner;
        }
        return null;
    }

    protected IAppMapOwner getOwnerFromInvocationObject(InvocationData data) {
        String nameFromData = super.formatParameterizedName(data);
        if (nameFromData != null) {
            IAppMapOwner owner = this.getNameHelper().getOwnerFromData(nameFromData, data, true);
            return owner;
        }
        return this.getNameHelper().getNullOwner();
    }

    protected IAppMapOwner getOwnerFromConfiguration() {
        String applicationName = this.getParameter("applicationName");
        if (applicationName != null) {
            IAppMapOwner owner = this.getNameHelper().getOwnerFromData(applicationName, null, true);
            return owner;
        }
        return this.getNameHelper().getNullOwner();
    }

    protected IAppMapOwner getOwnerFromParent() {
        IAppMapOwner owner = this.getNameHelper().peekCurrentOwnerName();
        return owner;
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return this.fIsShutoff || !AppMapService.hasStarted() || !AppMapService.isAppMapEnabled();
    }

    public void ITracerFactory_addMetricNameFormatListener(IMetricNameFormatListener metricNameFormatListener) {
    }

    protected static SharedCrossProcessData getSharedProcessDataCache() {
        return ComponentTracer.staticGetCrossProcessDataCache();
    }

    public Class getPluginClass() {
        return AppMapApplicationNameTracer.class;
    }

    public String getName() {
        return AppMapApplicationNameTracer.class.getName();
    }
}

