/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.appmap.agent.trace.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.activation.IOSGiClassPlugin;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.appmap.agent.AppMapService;
import com.wily.introscope.appmap.agent.trace.ICallbackOnLazyPushOwnerName;
import com.wily.introscope.appmap.agent.trace.hc2.AppMapApplicationNameTracer;
import com.wily.introscope.spec.server.appmap.IAppMapOwner;
import com.wily.util.properties.AttributeListing;

public class AppMapLazyNameTracer
extends AppMapApplicationNameTracer
implements IOSGiClassPlugin {
    public AppMapLazyNameTracer() {
    }

    public AppMapLazyNameTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public void ITracer_startTrace(final int tracerIndex, final InvocationData data) {
        boolean bl = this.fTracingEnabled = !this.ITracerFactory_isShutoff();
        if (!this.fTracingEnabled) {
            return;
        }
        if (!this.isCrossProcessSupportRequired()) {
            return;
        }
        if (data.isTransactionAborted()) {
            return;
        }
        VirtualStack.TransactionCache cache = VirtualStack.getTransactionCache();
        if (!cache.fHasAlreadyCheckedAppMapLazyName) {
            data.ensureCrossProcessCache();
            this.getNameHelper().lazyPushCurrentOwnerNameForCrossProcess(data.getSharedCrossProcessData(), new ICallbackOnLazyPushOwnerName(){

                @Override
                public String getOwnerName() {
                    String name = AppMapLazyNameTracer.this.formatParameterizedName(data);
                    data.setComponentNameAt(name, tracerIndex);
                    AppMapLazyNameTracer.pushAgentTriplet(AppMapLazyNameTracer.this.getAgent(), data.getSharedCrossProcessData());
                    return name;
                }
            });
            cache.fHasAlreadyCheckedAppMapLazyName = true;
        }
    }

    @Override
    public void replay_crossProcess(final InvocationData data, SharedCrossProcessData cache) {
        if (AppMapService.isCrossProcessSupportRequired()) {
            return;
        }
        VirtualStack.TransactionCache cacheTransaction = VirtualStack.getTransactionCache();
        if (!cacheTransaction.fHasAlreadyCheckedAppMapLazyName) {
            data.ensureCrossProcessCache();
            this.getNameHelper().lazyPushCurrentOwnerNameForCrossProcess(data.getSharedCrossProcessData(), new ICallbackOnLazyPushOwnerName(){

                @Override
                public String getOwnerName() {
                    String name = AppMapLazyNameTracer.this.formatParameterizedName(data);
                    AppMapLazyNameTracer.pushAgentTriplet(AppMapLazyNameTracer.this.getAgent(), data.getSharedCrossProcessData());
                    return name;
                }
            });
            cacheTransaction.fHasAlreadyCheckedAppMapLazyName = true;
        }
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (!this.fTracingEnabled) {
            return;
        }
        if (!this.isCrossProcessSupportRequired()) {
            return;
        }
        String componentName = data.getComponentNameAt(tracerIndex);
        if (componentName != null) {
            this.getNameHelper().popCurrentOwnerNameForCrossProcess(data.getSharedCrossProcessData(), componentName);
        }
    }

    @Override
    protected IAppMapOwner getOwner(InvocationData data) {
        IAppMapOwner owner = this.getOwnerFromParent();
        if (owner != null && !owner.isNullInstance()) {
            return owner;
        }
        owner = this.getOwnerFromInvocationObject(data);
        if (owner != null && !owner.isNullInstance()) {
            return owner;
        }
        owner = this.getOwnerFromConfiguration();
        if (owner != null && !owner.isNullInstance()) {
            return owner;
        }
        return null;
    }

    @Override
    public Class getPluginClass() {
        return AppMapLazyNameTracer.class;
    }

    @Override
    public String getName() {
        return AppMapLazyNameTracer.class.getName();
    }
}

