/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.server.appmap.impl;

import com.wily.introscope.spec.server.appmap.IAppMapComponentUniqueKey;
import com.wily.introscope.spec.server.appmap.IAppMapEdge;
import com.wily.introscope.spec.server.appmap.IAppMapEdgeUpdatable;
import com.wily.introscope.spec.server.appmap.IAppMapOwner;
import com.wily.introscope.spec.server.appmap.IAppMapProperty;
import com.wily.introscope.spec.server.appmap.IAppMapVertex;
import com.wily.introscope.spec.server.appmap.impl.AAppMapComponentUniqueKey;
import com.wily.introscope.spec.server.appmap.impl.AAppMapDate;
import com.wily.introscope.spec.server.appmap.impl.AAppMapPropertyEnum;
import com.wily.introscope.spec.server.appmap.impl.AAppMapVertex;
import com.wily.introscope.spec.server.appmap.impl.AbstractAppMapElement;
import com.wily.introscope.spec.server.transactiontrace.IAppMapStackCollectDataStructure;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class AAppMapEdge
extends AbstractAppMapElement
implements IAppMapEdgeUpdatable,
Externalizable,
IAppMapStackCollectDataStructure {
    private static final AAppMapVertex kNullInstance = new AAppMapVertex();

    public AAppMapEdge() {
        this.getProperties().put(OutOfTheBoxAppMapEdgeProperty.OwnerType, NOINFO_EDGE_OWNER_TYPE);
        this.getProperties().put(EdgeAppMapProperties.Head, NOINFO_VERTEX);
        this.getProperties().put(EdgeAppMapProperties.Tail, NOINFO_VERTEX);
        this.getProperties().put(OutOfTheBoxAppMapEdgeProperty.Owner, NOINFO_EDGE_OWNER);
        this.getProperties().put(AbstractAppMapElement.CommonAppMapProperties.CreationDate, NOINFO_DATE);
        this.getProperties().put(AbstractAppMapElement.CommonAppMapProperties.UpdateDate, NOINFO_DATE);
        this.getProperties().put(AbstractAppMapElement.CommonAppMapProperties.LastReportedDate, NOINFO_DATE);
        this.getProperties().put(AbstractAppMapElement.CommonAppMapProperties.Label, "NO INFO STRING");
    }

    public AAppMapEdge(IAppMapVertex head, IAppMapVertex tail, IAppMapOwner owner, IAppMapEdge.IAppMapEdgeOwnerType ownerType, IAppMapOwner headOwner, IAppMapOwner tailOwner) {
        this.getProperties().put(EdgeAppMapProperties.Head, head);
        this.getProperties().put(EdgeAppMapProperties.Tail, tail);
        this.getProperties().put(OutOfTheBoxAppMapEdgeProperty.Owner, owner);
        this.getProperties().put(OutOfTheBoxAppMapEdgeProperty.HeadOwner, headOwner);
        this.getProperties().put(OutOfTheBoxAppMapEdgeProperty.TailOwner, tailOwner);
        this.getProperties().put(OutOfTheBoxAppMapEdgeProperty.OwnerType, ownerType);
    }

    @Override
    public IAppMapVertex getHeadNode() {
        return (IAppMapVertex)this.getProperties().get(EdgeAppMapProperties.Head);
    }

    @Override
    public IAppMapOwner getOwner() {
        return (IAppMapOwner)this.getProperties().get(OutOfTheBoxAppMapEdgeProperty.Owner);
    }

    @Override
    public String getOwnedId() {
        return Long.toString(((IAppMapOwner)this.getProperties().get(OutOfTheBoxAppMapEdgeProperty.Owner)).getId());
    }

    @Override
    public String getOwnerName() {
        return ((IAppMapOwner)this.getProperties().get(OutOfTheBoxAppMapEdgeProperty.Owner)).getName();
    }

    @Override
    public IAppMapEdge.IAppMapEdgeOwnerType getOwnerType() {
        return (IAppMapEdge.IAppMapEdgeOwnerType)this.getProperties().get(OutOfTheBoxAppMapEdgeProperty.OwnerType);
    }

    @Override
    public IAppMapVertex getTailNode() {
        return (IAppMapVertex)this.getProperties().get(EdgeAppMapProperties.Tail);
    }

    @Override
    public IAppMapComponentUniqueKey getUniqueKey() {
        return new AAppMapComponentUniqueKey(new Object[]{this.getHeadNode().getUniqueKey(), this.getTailNode().getUniqueKey(), this.getOwnerName(), this.getOwnerType()});
    }

    public Object getUniqueKeyObject() {
        return this.getUniqueKey();
    }

    public int getWeight() {
        return 0;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
    }

    public String toString() {
        return "[" + this.getTailNode().getLabel() + "[" + this.getSecondaryTailOwner() + "]" + " --(" + this.getOwner() + ";" + this.getOwnerType() + ")--> " + this.getHeadNode().getLabel() + "[" + this.getSecondaryHeadOwner() + "]\n\t" + this.getTailNode() + "\n\t" + this.getHeadNode();
    }

    public Map<IAppMapProperty, Object> getParameters() {
        return this.getProperties();
    }

    public void setCreationDate(AAppMapDate creationDate) {
        this.getProperties().put(AbstractAppMapElement.CommonAppMapProperties.CreationDate, creationDate);
    }

    @Override
    public Object clone() {
        AAppMapEdge cloned = (AAppMapEdge)super.clone();
        cloned.setProperties((Map)((HashMap)this.getProperties()).clone());
        return cloned;
    }

    public Object cloneObject() {
        return this.clone();
    }

    @Override
    public boolean isCrossAgents() {
        IAppMapVertex tail;
        IAppMapVertex head = this.getHeadNode();
        if (this.checkExternals(head, tail = this.getTailNode())) {
            return true;
        }
        return !this.safeEquals(head.getAgentName(), tail.getAgentName());
    }

    @Override
    public boolean isCrossHosts() {
        IAppMapVertex tail;
        IAppMapVertex head = this.getHeadNode();
        if (this.checkExternals(head, tail = this.getTailNode())) {
            return true;
        }
        return !this.safeEquals(head.getHostName(), tail.getHostName());
    }

    @Override
    public boolean isCrossProcess() {
        IAppMapVertex tail;
        IAppMapVertex head = this.getHeadNode();
        if (this.checkExternals(head, tail = this.getTailNode())) {
            return true;
        }
        return !this.safeEquals(head.getProcessName(), head.getProcessName());
    }

    private boolean safeEquals(Object a, Object b) {
        return a != null ? (b != null ? a.equals(b) : false) : b == null;
    }

    private boolean checkExternals(IAppMapVertex head, IAppMapVertex tail) {
        if (head.getVertexType().equals(AAppMapVertex.OutOfTheBoxAppMapVertexType.External)) {
            return true;
        }
        return tail.getVertexType().equals(AAppMapVertex.OutOfTheBoxAppMapVertexType.External);
    }

    public static IAppMapStackCollectDataStructure getNullInstance() {
        return kNullInstance;
    }

    @Override
    public IAppMapOwner getSecondaryHeadOwner() {
        return (IAppMapOwner)this.getProperties().get(OutOfTheBoxAppMapEdgeProperty.HeadOwner);
    }

    @Override
    public IAppMapOwner getSecondaryTailOwner() {
        return (IAppMapOwner)this.getProperties().get(OutOfTheBoxAppMapEdgeProperty.TailOwner);
    }

    @Override
    public void setCreationDate(Date creationDate) {
        this.setCreationDate(new AAppMapDate(creationDate));
    }

    public static class EdgeAppMapProperties
    extends AAppMapPropertyEnum
    implements IAppMapEdge.IAppMapEdgeProperty {
        public static EdgeAppMapProperties Head = new EdgeAppMapProperties("Head");
        public static EdgeAppMapProperties Tail = new EdgeAppMapProperties("Tail");

        public EdgeAppMapProperties() {
        }

        private EdgeAppMapProperties(String name) {
            super(name);
        }
    }

    public static class OutOfTheBoxAppMapEdgeProperty
    extends AAppMapPropertyEnum
    implements IAppMapEdge.IAppMapEdgeProperty {
        public static OutOfTheBoxAppMapEdgeProperty Owner = new OutOfTheBoxAppMapEdgeProperty("Owner");
        public static OutOfTheBoxAppMapEdgeProperty TailOwner = new OutOfTheBoxAppMapEdgeProperty("TailOwner");
        public static OutOfTheBoxAppMapEdgeProperty HeadOwner = new OutOfTheBoxAppMapEdgeProperty("HeadOwner");
        public static OutOfTheBoxAppMapEdgeProperty OwnerType = new OutOfTheBoxAppMapEdgeProperty("OwnerType");

        public OutOfTheBoxAppMapEdgeProperty() {
        }

        private OutOfTheBoxAppMapEdgeProperty(String name) {
            super(name);
        }
    }

    public static class OutOfTheBoxAppMapOwnerType
    extends AAppMapPropertyEnum
    implements IAppMapEdge.IAppMapEdgeOwnerType {
        public static OutOfTheBoxAppMapOwnerType Application = new OutOfTheBoxAppMapOwnerType("Application");
        public static OutOfTheBoxAppMapOwnerType BusinessTransactionComponent = new OutOfTheBoxAppMapOwnerType("BusinessTransactionComponent");

        public OutOfTheBoxAppMapOwnerType() {
        }

        private OutOfTheBoxAppMapOwnerType(String name) {
            super(name);
        }
    }
}

