/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.server.appmap.impl;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.connection.IAppMapAgentServiceCommand;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.introscope.agent.trace.ITraceSupport;
import com.wily.introscope.appmap.agent.AppDef;
import com.wily.introscope.appmap.agent.connection.DependencyMapEdgeCommand;
import com.wily.introscope.appmap.agent.connection.DependencyMapNodeCommand;
import com.wily.introscope.spec.agent.beans.appmap.IAppMapDecisionSupportBean;
import com.wily.introscope.spec.server.appmap.IAppMapOwner;
import com.wily.introscope.spec.server.appmap.IAppMapVertex;
import com.wily.introscope.spec.server.appmap.IMetricPath;
import com.wily.introscope.spec.server.appmap.impl.AAppMapDate;
import com.wily.introscope.spec.server.appmap.impl.AAppMapEdge;
import com.wily.introscope.spec.server.appmap.impl.AAppMapOwner;
import com.wily.introscope.spec.server.appmap.impl.AAppMapVertex;
import com.wily.introscope.spec.server.appmap.impl.AMetricPath;
import com.wily.introscope.spec.server.appmap.impl.AParentChildVertex;
import com.wily.introscope.spec.server.appmap.impl.AbstractAppMapElement;
import com.wily.introscope.spec.server.appmap.impl.AppMapOracle;
import com.wily.introscope.spec.server.transactiontrace.IAppMapStackCollectDataStructure;
import com.wily.util.adt.ConcurrentAgingThreadLocalHashMap;
import com.wily.util.adt.IAgedSet;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.heartbeat.IntervalHeartbeat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class AppMapOracle15
extends AppMapOracle
implements ITraceSupport {
    List<String> parentTypes;
    private final AtomicReference<IAgedSet> fCrossProcessEdgeMap = new AtomicReference();
    private final AtomicReference<IAgedSet> fNoticedDependenciesMap = new AtomicReference();
    private final AtomicReference<IAgedSet> fNoticedMetrics = new AtomicReference();
    private final AtomicReference<IAgedSet> fParentChildMap = new AtomicReference();
    private volatile long edgeAgingValueFromCommand;

    private AppMapOracle15() {
        this.parentTypes = new ArrayList<String>(AAppMapVertex.OutOfTheBoxAppMapVertexHierarchyLevel.values().length);
        for (AAppMapVertex.OutOfTheBoxAppMapVertexHierarchyLevel level : Arrays.asList(AAppMapVertex.OutOfTheBoxAppMapVertexHierarchyLevel.values())) {
            this.parentTypes.add(level.name());
        }
    }

    static AppMapOracle15 getInstance() {
        return AppMapOracleInstancer.kInstance;
    }

    @Override
    public boolean setAgent(IAgent agent) {
        return super.setAgent(agent);
    }

    public IAppMapStackCollectDataStructure getNode(String host, String process, String agent, String name, String type, String level, boolean isPhysical, Map targetProperties, IAppMapOwner owner) {
        AAppMapVertex result;
        block16: {
            if (this.shouldNotRun()) {
                return AAppMapVertex.getNullInstance();
            }
            result = new AAppMapVertex();
            result.setType(type);
            result.getProperties().put(AbstractAppMapElement.CommonAppMapProperties.Label, name);
            result.getProperties().put(AbstractAppMapElement.CommonAppMapProperties.CreationDate, new AAppMapDate());
            result.getProperties().put(AbstractAppMapElement.CommonAppMapProperties.LastReportedDate, new AAppMapDate());
            if (isPhysical) {
                result.getProperties().put(AAppMapVertex.VertexAppMapProperties.AbstractionLevel, AAppMapVertex.OutOfTheBoxAppMapVertexAbstractionLevel.Physical);
            } else {
                result.getProperties().put(AAppMapVertex.VertexAppMapProperties.AbstractionLevel, AAppMapVertex.OutOfTheBoxAppMapVertexAbstractionLevel.Logical);
            }
            result.getProperties().put(AAppMapVertex.VertexAppMapProperties.HierarchyLevel, AAppMapVertex.OutOfTheBoxAppMapVertexHierarchyLevel.valueOf(AAppMapVertex.OutOfTheBoxAppMapVertexHierarchyLevel.class, level));
            if (host == null || agent == null || process == null) {
                try {
                    String[] triplet;
                    block15: {
                        triplet = this.getAgent().IAgent_getHostProcessAgentTriplet();
                        if (triplet.length != 3) {
                            throw new AgentNotAvailableException();
                        }
                        if (host == null) {
                            host = triplet[0];
                            try {
                                result.getProperties().put(AAppMapVertex.OutOfTheBoxAppMapVertexProperty.FullyQualifiedHostName, this.getAgent().IAgent_getEnvironmentAdministrator().getFullyQualifiedHostname());
                            }
                            catch (Throwable t) {
                                if (!this.getAgent().IAgent_getModuleFeedback().isTraceEnabled(kModule)) break block15;
                                this.getAgent().IAgent_getModuleFeedback().trace(kModule, "Cannot get fully qualified host name:" + t.getMessage());
                            }
                        }
                    }
                    if (process == null) {
                        process = triplet[1];
                    }
                    if (agent == null) {
                        agent = triplet[2];
                    }
                }
                catch (AgentNotAvailableException agentNotAvailableException) {
                    if (host == null) {
                        host = "Unavailable";
                    }
                    if (process == null) {
                        process = "Unavailable";
                    }
                    if (agent != null) break block16;
                    agent = "Unavailable";
                }
            }
        }
        result.getProperties().put(AAppMapVertex.OutOfTheBoxAppMapVertexProperty.HostName, host);
        result.getProperties().put(AAppMapVertex.OutOfTheBoxAppMapVertexProperty.ProcessName, process);
        result.getProperties().put(AAppMapVertex.OutOfTheBoxAppMapVertexProperty.AgentName, agent);
        if (owner == null) {
            owner = AbstractAppMapElement.NoInfoAppMapOwner.getInstance();
        }
        result.getProperties().put(AAppMapVertex.OutOfTheBoxAppMapVertexProperty.agentSideOwner, AAppMapOwner.getInstance(owner.getId(), owner.getName()));
        result.getUserDefinedProperties().putAll(targetProperties);
        return result;
    }

    public IAppMapStackCollectDataStructure getEdge(IAppMapOwner owner, IAppMapStackCollectDataStructure head, IAppMapStackCollectDataStructure tail, IAppMapOwner headOwner, IAppMapOwner tailOwner) {
        if (this.shouldNotRun()) {
            return AAppMapEdge.getNullInstance();
        }
        if (head != null && !(head instanceof IAppMapVertex)) {
            this.getAgent().IAgent_getModuleFeedback().error(kModule, "Illegal object vertex of type " + head.getClass() + " used for edge");
            return null;
        }
        if (head == null) {
            this.getAgent().IAgent_getModuleFeedback().error(kModule, "null object vertex used for edge");
            return null;
        }
        if (tail != null && !(tail instanceof IAppMapVertex)) {
            this.getAgent().IAgent_getModuleFeedback().error(kModule, "Illegal object vertex of type " + tail.getClass() + " used for edge");
            return null;
        }
        if (tail == null) {
            this.getAgent().IAgent_getModuleFeedback().error(kModule, "null object vertex used for edge");
            return null;
        }
        IAppMapVertex iHead = (IAppMapVertex)head;
        IAppMapVertex iTail = (IAppMapVertex)tail;
        AAppMapEdge.OutOfTheBoxAppMapOwnerType ownerType = owner instanceof AppDef ? AAppMapEdge.OutOfTheBoxAppMapOwnerType.Application : AAppMapEdge.OutOfTheBoxAppMapOwnerType.BusinessTransactionComponent;
        AAppMapOwner aAppMapOwner = AAppMapOwner.getInstance(owner.getId(), owner.getName());
        IAppMapOwner aHeadOwner = headOwner == null ? AbstractAppMapElement.NOINFO_EDGE_OWNER : headOwner;
        IAppMapOwner aTailOwner = tailOwner == null ? AbstractAppMapElement.NOINFO_EDGE_OWNER : tailOwner;
        AAppMapEdge edge = new AAppMapEdge(iHead, iTail, aAppMapOwner, ownerType, aHeadOwner, aTailOwner);
        if (head instanceof AAppMapVertex) {
            ((AAppMapVertex)head).eraseMetrics();
        }
        if (tail instanceof AAppMapVertex) {
            ((AAppMapVertex)tail).eraseMetrics();
        }
        return edge;
    }

    public boolean reportEdge(IAppMapDecisionSupportBean.ICallBackOnSent callback, List data) {
        if (this.shouldNotRun()) {
            return false;
        }
        IsengardServerConnectionManager connection = this.getAgent().IAgent_getIsengardServerConnection();
        if (connection != null && connection.shouldSendData() && data != null) {
            if (this.getAgent().IAgent_getModuleFeedback().isDebugEnabled(kModule)) {
                this.getAgent().IAgent_getModuleFeedback().debug(kModule, "Sending edges" + data);
                AAppMapEdge tempEdge = (AAppMapEdge)data.get(0);
                if (tempEdge.getUserDefinedProperties() != null && !tempEdge.getUserDefinedProperties().isEmpty()) {
                    this.getAgent().IAgent_getModuleFeedback().debug(kModule, "Sending edges parameters" + tempEdge.getUserDefinedProperties());
                }
            }
            if (!connection.addToCommandQueue((IAppMapAgentServiceCommand)new DependencyMapEdgeCommand(callback, this.getAgent().IAgent_getModuleFeedback(), data))) {
                callback.onSent(false);
            } else {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean reportMetrics(IAppMapDecisionSupportBean.ICallBackOnSent callback, Map data) {
        if (this.shouldNotRun()) {
            return false;
        }
        IsengardServerConnectionManager connection = this.getAgent().IAgent_getIsengardServerConnection();
        if (connection != null && connection.shouldSendData() && data != null) {
            ArrayList<AAppMapVertex> list = new ArrayList<AAppMapVertex>();
            Iterator i = data.entrySet().iterator();
            while (i.hasNext()) {
                if (this.getAgent().IAgent_getModuleFeedback().isDebugEnabled(kModule)) {
                    this.getAgent().IAgent_getModuleFeedback().debug(kModule, "Sending metrics" + data);
                }
                Map.Entry entry = i.next();
                AAppMapVertex vertex = (AAppMapVertex)entry.getKey();
                Map metrics = (Map)entry.getValue();
                for (Map.Entry metricEntry : metrics.entrySet()) {
                    String key = (String)metricEntry.getKey();
                    String value = (String)metricEntry.getValue();
                    IMetricPath metricPath = this.getMetricPath(key, value);
                    vertex.getMetricPaths().add(metricPath);
                }
                list.add(vertex);
            }
            if (connection.addToCommandQueue((IAppMapAgentServiceCommand)new DependencyMapNodeCommand(callback, this.getAgent().IAgent_getModuleFeedback(), list))) return true;
            callback.onSent(false);
            return false;
        } else {
            callback.onSent(false);
        }
        return false;
    }

    private IMetricPath getMetricPath(String key, String value) {
        return new AMetricPath(value);
    }

    public boolean isNodeTypeValid(String nodeType) {
        if (this.shouldNotRun()) {
            return false;
        }
        for (AAppMapVertex.OutOfTheBoxAppMapVertexType type : Arrays.asList(AAppMapVertex.OutOfTheBoxAppMapVertexType.values())) {
            if (!type.name().equals(nodeType)) continue;
            return true;
        }
        this.getAgent().IAgent_getModuleFeedback().warn(kModule, "Value " + nodeType + " is not in the collection of valid values " + Arrays.asList(AAppMapVertex.OutOfTheBoxAppMapVertexType.values()));
        return false;
    }

    @Override
    protected IAgedSet getCrossProcessEdgeMap() {
        return this.getOrInitializeConcurrentSet(this.fCrossProcessEdgeMap);
    }

    @Override
    protected IAgedSet getNoticedDependenciesMap() {
        return this.getOrInitializeConcurrentSet(this.fNoticedDependenciesMap);
    }

    @Override
    protected IAgedSet getNoticedMetrics() {
        return this.getOrInitializeConcurrentSet(this.fNoticedMetrics);
    }

    @Override
    protected IAgedSet getNoticedParentChildDependency() {
        return this.getOrInitializeConcurrentSet(this.fParentChildMap);
    }

    private IAgedSet getOrInitializeConcurrentSet(AtomicReference<IAgedSet> reference) {
        IAgedSet result = reference.get();
        if (result == null) {
            IModuleFeedbackChannel feedback = this.getAgent().IAgent_getModuleFeedback();
            result = new MyConcurrentSet(feedback, false, 8, 256);
            if (!reference.compareAndSet(null, result)) {
                return reference.get();
            }
            long check = this.getCheckAging(this.edgeAgingValueFromCommand);
            result.startAging(this.getAgent().IAgent_getConfigHeartbeat(), this.edgeAgingValueFromCommand, check);
        }
        return result;
    }

    public boolean isParentLevel(String nodeLevel) {
        if (this.shouldNotRun()) {
            return false;
        }
        int index = this.parentTypes.indexOf(nodeLevel);
        if (index < 0) {
            this.getAgent().IAgent_getModuleFeedback().warn(kModule, "Value " + nodeLevel + " is not in the collection of valid values " + Arrays.asList(AAppMapVertex.OutOfTheBoxAppMapVertexHierarchyLevel.values()));
        }
        return index > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean reportParentChildRelation(IAppMapDecisionSupportBean.ICallBackOnSent callback, IAppMapStackCollectDataStructure parent, IAppMapStackCollectDataStructure child) {
        if (this.shouldNotRun()) {
            return false;
        }
        IsengardServerConnectionManager connection = this.getAgent().IAgent_getIsengardServerConnection();
        if (connection != null && connection.shouldSendData() && child != null && child instanceof AAppMapVertex) {
            if (parent != null && parent instanceof AAppMapVertex) {
                AParentChildVertex childInRelation = new AParentChildVertex((AAppMapVertex)child);
                AParentChildVertex parentInRelation = new AParentChildVertex((AAppMapVertex)parent);
                childInRelation.setParent(parentInRelation);
                ArrayList<AParentChildVertex> list = new ArrayList<AParentChildVertex>();
                list.add(childInRelation);
                if (connection.addToCommandQueue((IAppMapAgentServiceCommand)new DependencyMapNodeCommand(callback, this.getAgent().IAgent_getModuleFeedback(), list))) return true;
                callback.onSent(false);
            }
        } else {
            callback.onSent(false);
        }
        this.getAgent().IAgent_getModuleFeedback().debug(kModule, "Unable to sent parent child relation");
        return false;
    }

    public void startDataStructureAging(long edgeAgingValue) {
        if (edgeAgingValue <= 0L) {
            this.getAgent().IAgent_getModuleFeedback().warn(kModule, "Aging input value is " + edgeAgingValue);
            edgeAgingValue = this.getEdgeAging();
        }
        this.edgeAgingValueFromCommand = edgeAgingValue;
        long check = this.getCheckAging(this.edgeAgingValueFromCommand);
        IAgedSet set = this.getCrossProcessEdgeMap();
        if (set != null) {
            set.startAging(this.getAgent().IAgent_getConfigHeartbeat(), this.edgeAgingValueFromCommand, check);
        }
        if ((set = this.getNoticedDependenciesMap()) != null) {
            set.startAging(this.getAgent().IAgent_getConfigHeartbeat(), this.edgeAgingValueFromCommand, check);
        }
        if ((set = this.getNoticedMetrics()) != null) {
            set.startAging(this.getAgent().IAgent_getConfigHeartbeat(), this.edgeAgingValueFromCommand, check);
        }
        if ((set = this.getNoticedParentChildDependency()) != null) {
            set.startAging(this.getAgent().IAgent_getConfigHeartbeat(), this.edgeAgingValueFromCommand, check);
        }
        this.getAgent().IAgent_getModuleFeedback().info(kModule, "App Map Aging set to " + edgeAgingValue + " ms, checking every " + check + " ms.");
    }

    @Override
    protected boolean initializeAgingStructures(IAgent agent) {
        return true;
    }

    /* synthetic */ AppMapOracle15(AppMapOracle15 appMapOracle15) {
        this();
    }

    private static final class AppMapOracleInstancer {
        private static final AppMapOracle15 kInstance = new AppMapOracle15(null);

        private AppMapOracleInstancer() {
        }
    }

    private static class MyConcurrentSet
    extends ConcurrentAgingThreadLocalHashMap<Object, Boolean>
    implements IAgedSet {
        private static final Boolean kStaticValue = Boolean.TRUE;
        private static final long serialVersionUID = 1L;

        public MyConcurrentSet(IntervalHeartbeat beat, IModuleFeedbackChannel feedback, boolean useThreadLocal, long agingTime, long updateAgingFrequency) {
            super(beat, feedback, useThreadLocal, agingTime, updateAgingFrequency);
        }

        public MyConcurrentSet(IModuleFeedbackChannel feedback, boolean useThreadLocal) {
            super(feedback, useThreadLocal);
        }

        public MyConcurrentSet(IModuleFeedbackChannel feedback, boolean useThreadLocal, int numberOfProcessors, int size) {
            super(feedback, useThreadLocal, numberOfProcessors, size);
        }

        public boolean addAged(Object value) {
            return this.putAged(value, kStaticValue) == null;
        }

        public boolean containsAged(Object value) {
            return this.containsKey(value);
        }
    }
}

