/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.acc.common;

import com.ca.apm.acc.common.ACCByteMessage;
import com.ca.apm.acc.common.ACCMessage;
import com.ca.apm.acc.common.ACCTextMessage;

public class ACCRestMessage {
    private Type type;
    private String payload;
    private String destination;
    private String emIdentifier;

    public ACCRestMessage() {
    }

    public ACCRestMessage(Type type, String payload, String destination, String emIdentifier) {
        this.type = type;
        this.payload = payload;
        this.destination = destination;
        this.emIdentifier = emIdentifier;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getEmIdentifier() {
        return this.emIdentifier;
    }

    public void setEmIdentifier(String emIdentifier) {
        this.emIdentifier = emIdentifier;
    }

    private static ACCRestMessage fromACCMessage(ACCMessage message, String payload, String destination, String emIdentifier) {
        Type type = null;
        if (message instanceof ACCTextMessage) {
            type = Type.TEXT;
        } else if (message instanceof ACCByteMessage) {
            type = Type.BYTE;
        }
        if (type == null) {
            throw new IllegalArgumentException("Unknown message type " + message.getClass().getName());
        }
        return new ACCRestMessage(type, payload, destination, emIdentifier);
    }

    public static ACCRestMessage fromConfigServer(ACCMessage message, String payload, String destination) {
        return ACCRestMessage.fromACCMessage(message, payload, destination, null);
    }

    public static ACCRestMessage fromController(ACCMessage message, String payload, String emIdentifier) {
        return ACCRestMessage.fromACCMessage(message, payload, null, emIdentifier);
    }

    public String toString() {
        return "ACCRestMessage{type=" + (Object)((Object)this.type) + ", payload='" + this.payload + '\'' + ", destination='" + this.destination + '\'' + ", emIdentifier='" + this.emIdentifier + '\'' + '}';
    }

    public static enum Type {
        TEXT,
        BYTE;


        public static Type fromString(String type) {
            return Type.valueOf(type.toUpperCase());
        }
    }
}

