/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.extension;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.extension.OptionalExtensionsIncludeConfiguration;
import com.wily.introscope.agent.sustainability.SustainabilityService;
import com.wily.introscope.agent.transformer.dynamic.IDirectiveLoadListener;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationTransformer;
import com.wily.util.extension.IPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class OptionalExtensionsManager
implements IDirectiveLoadListener {
    private boolean fFailedDuringLoad = false;
    private Set<String> fFailedExtensions = Collections.synchronizedSet(new HashSet());
    private AtomicBoolean fIsListDirty = new AtomicBoolean(false);
    private AtomicBoolean fIsLoadingInProgress = new AtomicBoolean(true);
    private ScheduledExecutorService executor;
    private IAgent fAgent;
    private ExtensionWorker optionExtWorker;
    private final boolean fIsDynamic;
    private List<ExtensionListener> fExtensionListeners = new ArrayList<ExtensionListener>();
    private Object fMonitor = new Object();
    private boolean fRedefinitionDone = true;
    private volatile IDynamicInstrumentationTransformer fTransformer = null;

    private OptionalExtensionsManager() {
        this.fIsDynamic = true;
    }

    public OptionalExtensionsManager(IAgent agent, boolean isDynamic) {
        this.fAgent = agent;
        this.fIsDynamic = isDynamic;
    }

    public void start() {
        this.startExecutor();
    }

    public void addExtensionWithError(String ext) {
        if (ext == null) {
            return;
        }
        this.fFailedExtensions.add(ext);
        this.setListDirtyFlag(true);
        this.fFailedDuringLoad = true;
        this.startExecutor();
    }

    public void setLoadingFlag(boolean flag) {
        this.fIsLoadingInProgress.compareAndSet(!flag, flag);
    }

    public void startExecutor() {
        if (this.executor == null) {
            ThreadFactory tf = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = Executors.defaultThreadFactory().newThread(r);
                    thread.setDaemon(true);
                    String poolName = thread.getName();
                    thread.setName("Agent Extension Manager: " + poolName);
                    return thread;
                }
            };
            this.executor = Executors.newSingleThreadScheduledExecutor(tf);
            this.optionExtWorker = new ExtensionWorker(this.fAgent, this);
        }
        try {
            this.executor.execute(this.optionExtWorker);
        }
        catch (RejectedExecutionException e) {
            e.printStackTrace();
        }
    }

    public boolean isDynamic() {
        return this.fIsDynamic;
    }

    public void setListDirtyFlag(boolean flag) {
        this.fIsListDirty.set(flag);
    }

    public void updateExtensions(IAgent agent) {
        if (this.fIsListDirty.get()) {
            if (this.fIsLoadingInProgress.compareAndSet(false, true)) {
                try {
                    this.fIsListDirty.set(false);
                    HashSet<String> extensionsToUnload = this.calculateUnloadExtensions();
                    HashSet<String> pbdsDuringUnload = this.calculateExtensionPBDsDuringUnload(extensionsToUnload);
                    HashSet<String> extensionsToLoad = this.calculateLoadExtensions();
                    HashSet<String> pbdsDuringLoad = this.calculateExtensionPBDsDuringLoad();
                    this.unloadExtensions(agent, extensionsToUnload, pbdsDuringUnload);
                    this.loadExtensions(agent, extensionsToLoad, pbdsDuringLoad);
                }
                finally {
                    this.fIsLoadingInProgress.set(false);
                    SustainabilityService sustainabilityService = SustainabilityService.getSustainabilityServiceInstance();
                    if (sustainabilityService != null) {
                        SustainabilityService.getSustainabilityServiceInstance().setOptionalExtensionsLoadedMetricCount(this.calculateExtensionPBDsDuringLoad().size());
                        SustainabilityService.getSustainabilityServiceInstance().setOptionalExtensionsFailedMetricCount(this.fFailedExtensions.size());
                    }
                }
            } else {
                this.executor.schedule(this.optionExtWorker, 10L, TimeUnit.SECONDS);
            }
        }
    }

    public HashSet<String> calculateExtensionPBDsDuringLoad() {
        HashSet<String> currentIncludedExtensions = new HashSet<String>(OptionalExtensionsIncludeConfiguration.getIncludedExtensions());
        currentIncludedExtensions.removeAll(this.fFailedExtensions);
        return currentIncludedExtensions;
    }

    private HashSet<String> calculateExtensionPBDsDuringUnload(HashSet<String> extensionsToUnload) {
        HashSet<String> previousIncludedExtensions = new HashSet<String>(OptionalExtensionsIncludeConfiguration.getPrevIncludedExtensions());
        previousIncludedExtensions.removeAll(extensionsToUnload);
        previousIncludedExtensions.removeAll(this.fFailedExtensions);
        return previousIncludedExtensions;
    }

    private HashSet<String> calculateLoadExtensions() {
        HashSet<String> currentIncludedExtensions = new HashSet<String>(OptionalExtensionsIncludeConfiguration.getIncludedExtensions());
        HashSet<String> previousIncludedExtensions = new HashSet<String>(OptionalExtensionsIncludeConfiguration.getPrevIncludedExtensions());
        HashSet<String> result = new HashSet<String>(currentIncludedExtensions);
        if (previousIncludedExtensions != null) {
            result.removeAll(previousIncludedExtensions);
        }
        if (this.fFailedExtensions != null) {
            if (this.fFailedDuringLoad) {
                result.removeAll(this.fFailedExtensions);
            } else if (!result.isEmpty()) {
                this.fFailedExtensions.retainAll(currentIncludedExtensions);
                result.addAll(this.fFailedExtensions);
                this.fFailedExtensions.clear();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet<String> calculateUnloadExtensions() {
        HashSet<String> currentIncludedExtensions = new HashSet<String>(OptionalExtensionsIncludeConfiguration.getIncludedExtensions());
        HashSet<String> previousIncludedExtensions = new HashSet<String>(OptionalExtensionsIncludeConfiguration.getPrevIncludedExtensions());
        HashSet<String> result = new HashSet<String>(previousIncludedExtensions);
        result.removeAll(currentIncludedExtensions);
        HashSet<String> removedExt = new HashSet<String>();
        Set<String> set = this.fFailedExtensions;
        synchronized (set) {
            for (String ext : this.fFailedExtensions) {
                if (previousIncludedExtensions.contains(ext) && !currentIncludedExtensions.contains(ext)) {
                    removedExt.add(ext);
                    continue;
                }
                if (!this.fFailedDuringLoad || !currentIncludedExtensions.contains(ext)) continue;
                result.add(ext);
            }
        }
        this.fFailedExtensions.removeAll(removedExt);
        return result;
    }

    private IDynamicInstrumentationTransformer getTransformer() {
        if (this.fTransformer == null) {
            this.fTransformer = this.fAgent.IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer();
            if (this.fTransformer != null) {
                this.fTransformer.registerDirectiveLoadListener(this);
            }
        }
        return this.fTransformer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadDirectivesAndWait(IAgent agent, HashSet<String> pbds) {
        if (this.getTransformer() != null) {
            agent.IAgent_getModuleFeedback().info("Reloading Directives");
            this.fRedefinitionDone = false;
            if (!this.fTransformer.reloadDirectives(pbds)) {
                this.fRedefinitionDone = true;
            }
            Object object = this.fMonitor;
            synchronized (object) {
                int waitTime = 60;
                while (!this.fRedefinitionDone && waitTime > 0) {
                    try {
                        this.fMonitor.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    --waitTime;
                }
                if (waitTime == 0) {
                    agent.IAgent_getModuleFeedback().warn("Class redefinition timed out during extension load or unload.");
                }
            }
        }
    }

    public void unloadExtensions(IAgent agent, HashSet<String> extensionsToUnload, HashSet<String> pbdsDuringUnload) {
        agent.IAgent_getModuleFeedback().info("Begin Unloading Extensions: " + extensionsToUnload);
        agent.IAgent_getModuleFeedback().info("PBD list: " + pbdsDuringUnload);
        if (extensionsToUnload != null && extensionsToUnload.size() > 0) {
            if (pbdsDuringUnload != null) {
                this.reloadDirectivesAndWait(agent, pbdsDuringUnload);
            }
            agent.IAgent_getModuleFeedback().info("Unloading Jars");
            agent.IAgent_getExtensionAdministrator().unloadExtensions(extensionsToUnload);
            agent.IAgent_getModuleFeedback().info("Unloading Properties");
            agent.IAgent_getExtensionAdministrator().getExensionProfileAdministrator().unloadExtensionProfiles(extensionsToUnload);
            this.notifyExtensionsUnloaded(extensionsToUnload);
        }
    }

    public void loadExtensions(IAgent agent, HashSet<String> extensionsToLoad, HashSet<String> pbdsDuringLoad) {
        if (this.fFailedDuringLoad) {
            agent.IAgent_getModuleFeedback().info("Begin re-loading PBDs after extension failure.");
            agent.IAgent_getModuleFeedback().info("PBD list: " + pbdsDuringLoad);
            this.fFailedDuringLoad = false;
            this.reloadDirectivesAndWait(agent, pbdsDuringLoad);
            return;
        }
        agent.IAgent_getModuleFeedback().info("Begin Loading Extensions: " + extensionsToLoad);
        agent.IAgent_getModuleFeedback().info("PBD list: " + pbdsDuringLoad);
        if (extensionsToLoad != null && extensionsToLoad.size() > 0) {
            agent.IAgent_getModuleFeedback().debug("Loading Properties");
            agent.IAgent_getExtensionAdministrator().getExensionProfileAdministrator().loadExtensionProfiles(extensionsToLoad);
            agent.IAgent_getExtensionAdministrator().getExensionProfileAdministrator().reloadConfiguration();
            agent.IAgent_getModuleFeedback().debug("Loading Jars");
            agent.IAgent_getExtensionAdministrator().loadExtensions(extensionsToLoad);
            this.reloadDirectivesAndWait(agent, pbdsDuringLoad);
            this.notifyExtensionsLoaded(extensionsToLoad);
        }
    }

    public void addExtensionListener(ExtensionListener listener) {
        this.fExtensionListeners.add(listener);
    }

    public void notifyExtensionsLoaded(Set<String> extensionsToLoad) {
        for (String extension : extensionsToLoad) {
            for (ExtensionListener listener : this.fExtensionListeners) {
                listener.notifyExtensionLoaded(extension);
            }
        }
    }

    public void notifyExtensionsUnloaded(Set<String> extensionsToUnload) {
        for (String extension : extensionsToUnload) {
            for (ExtensionListener listener : this.fExtensionListeners) {
                listener.notifyExtensionUnloaded(extension);
            }
        }
    }

    @Override
    public void notifyDirectivesLoaded() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyRedefinitionComplete() {
        Object object = this.fMonitor;
        synchronized (object) {
            this.fRedefinitionDone = true;
            this.fMonitor.notifyAll();
        }
    }

    public void addExtensionWithError(IPlugin plugin) {
        if (plugin == null) {
            return;
        }
        if (this.fIsLoadingInProgress.get()) {
            String path = plugin.IPlugin_getOwningExtension().IExtension_getSource();
            this.reportErrorToExtensionManager(path);
            this.fAgent.IAgent_getModuleFeedback().info("Failed to Load:" + path);
        }
    }

    private void reportErrorToExtensionManager(String fileName) {
        if (fileName != null && this.fAgent != null) {
            String strExt = String.valueOf(File.separatorChar) + "extensions" + File.separatorChar;
            int index = fileName.lastIndexOf(strExt);
            OptionalExtensionsManager oem = this.fAgent.IAgent_getExtensionAdministrator().getOptionalExtensionManager();
            if (oem != null && index != -1) {
                int indexOfSep = fileName.indexOf(File.separatorChar, index + strExt.length());
                String ext = fileName.substring(index + strExt.length(), indexOfSep);
                oem.addExtensionWithError(ext);
            }
        }
    }

    public Set<String> getFailedExtensions() {
        return this.fFailedExtensions;
    }

    public static interface ExtensionListener {
        public void notifyExtensionLoaded(String var1);

        public void notifyExtensionUnloaded(String var1);
    }

    public static class ExtensionWorker
    implements Runnable {
        private OptionalExtensionsManager fManager = null;
        IAgent fAgent = null;

        public ExtensionWorker(IAgent agent, OptionalExtensionsManager mgr) {
            this.fAgent = agent;
            this.fManager = mgr;
        }

        @Override
        public void run() {
            this.fManager.updateExtensions(this.fAgent);
        }
    }
}

