/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.probe.net;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.blame.IAppMapStack;
import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.blame.IStackType;
import com.wily.introscope.agent.probe.net.ReflectionHelper;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.util.extension.IPlugin;
import com.wily.util.feedback.Module;
import java.util.HashMap;

public class ManagedSocketMapHelper {
    private static final int kAddedClassApplicationEdge = 1;
    private static final int kAddedClassMethodApplicationEdge = 2;
    private static final int kAddedClassBTEdge = 4;
    private static final int kAddedClassMethodBTEdge = 8;
    private static final int kSkippedForFlag = 16;
    static final IAgent sAgent;
    private static boolean initializeStatus;
    private static boolean reportToAppMap;
    private static boolean reportClassApplicationEdge;
    private static boolean reportMethodApplicationEdge;
    private static boolean reportClassBTEdge;
    private static boolean reportMethodBTEdge;
    private static boolean kIsTraceEnabled;
    static final Module kManagedSocketModule;
    private static final String kSocketNodeType = "Socket";

    static {
        kManagedSocketModule = new Module("ManagedSocket");
        sAgent = ManagedSocketMapHelper.findAgent();
        kIsTraceEnabled = ManagedSocketMapHelper.getAgent().IAgent_getModuleFeedback().isTraceEnabled();
    }

    public static void initializeIfNeccessary() {
        boolean pingResult = ManagedSocketMapHelper.pingAppMapHelperBean();
        if (pingResult) {
            ManagedSocketMapHelper.propertiesReader();
            if (reportToAppMap) {
                ManagedSocketMapHelper.lookupAppMapService();
            }
        }
    }

    private static boolean pingAppMapHelperBean() {
        boolean pingResult = false;
        try {
            ManagedSocketMapHelper.getAgent().IAgent_getTracerAdministrator().loadTraceSupport("com.wily.introscope.spec.server.appmap.impl.AppMapOracleFactory", "").getTraceSupportInstance();
            pingResult = true;
        }
        catch (Throwable t) {
            try {
                ManagedSocketMapHelper.getAgent().IAgent_getModuleFeedback().warn(kManagedSocketModule, "Appmap support for sockets disabled");
                ManagedSocketMapHelper.getAgent().IAgent_getModuleFeedback().verbose(kManagedSocketModule, "Appmap support for sockets disabled", t);
            }
            catch (Throwable throwable) {}
        }
        return pingResult;
    }

    private static final IAgent findAgent() {
        try {
            return AgentShim.getAgent();
        }
        catch (AgentNotAvailableException anae) {
            try {
                AgentShim.handleError("Unable to gather socket data because the Agent is not available", anae);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {}
            return null;
        }
    }

    public static void reEvaluateLogLevel() {
        kIsTraceEnabled = ManagedSocketMapHelper.getAgent().IAgent_getModuleFeedback().isTraceEnabled();
    }

    private static void propertiesReader() {
        boolean bl = reportToAppMap = ManagedSocketMapHelper.getAgent() == null ? false : ManagedSocketMapHelper.getAgent().IAgent_getIndexedProperties().getBooleanProperty("introscope.agent.sockets.managed.reportToAppmap", true);
        if (reportToAppMap) {
            reportClassApplicationEdge = ManagedSocketMapHelper.getAgent() == null ? false : ManagedSocketMapHelper.getAgent().IAgent_getIndexedProperties().getBooleanProperty("introscope.agent.sockets.managed.reportClassAppEdge", false);
            reportMethodApplicationEdge = ManagedSocketMapHelper.getAgent() == null ? false : ManagedSocketMapHelper.getAgent().IAgent_getIndexedProperties().getBooleanProperty("introscope.agent.sockets.managed.reportMethodAppEdge", true);
            reportClassBTEdge = ManagedSocketMapHelper.getAgent() == null ? false : ManagedSocketMapHelper.getAgent().IAgent_getIndexedProperties().getBooleanProperty("introscope.agent.sockets.managed.reportClassBTEdge", false);
            reportMethodBTEdge = ManagedSocketMapHelper.getAgent() == null ? false : ManagedSocketMapHelper.getAgent().IAgent_getIndexedProperties().getBooleanProperty("introscope.agent.sockets.managed.reportMethodBTEdge", true);
        }
    }

    public static int addToAppMapIfEnabled(String component) {
        int result = 0;
        ComponentTracer componentTracer = ManagedSocketMapHelper.getAgent().IAgent_getComponentTracer();
        if (componentTracer.isAgentOldMode() && reportToAppMap && initializeStatus) {
            IStackType stackType;
            IBlameStack stack = componentTracer.getCurrentThreadStack(true);
            if (componentTracer.getSamplingSkipFlag(stack)) {
                return result | 0x10;
            }
            HashMap<String, String> params = null;
            if (reportClassApplicationEdge) {
                stackType = ReflectionHelper.getStackTypeClassApp();
                if (!componentTracer.peekLastMapComponentWasMe(stack, stackType, component)) {
                    if (params == null) {
                        params = new HashMap<String, String>();
                        params.put("nodeType", kSocketNodeType);
                    }
                    componentTracer.addMapComponent(stack, stackType, component, params);
                    result |= 1;
                    if (kIsTraceEnabled) {
                        ManagedSocketMapHelper.getAgent().IAgent_getModuleFeedback().trace(kManagedSocketModule, "adding to appmap (class level application) " + component);
                    }
                } else if (kIsTraceEnabled) {
                    ManagedSocketMapHelper.getAgent().IAgent_getModuleFeedback().trace(kManagedSocketModule, "skipping add to appmap (class level application) " + component);
                }
            }
            if (reportMethodApplicationEdge) {
                stackType = ReflectionHelper.getStackTypeClassMethodApp();
                if (!componentTracer.peekLastMapComponentWasMe(stack, stackType, component)) {
                    if (params == null) {
                        params = new HashMap();
                        params.put("nodeType", kSocketNodeType);
                    }
                    componentTracer.addMapComponent(stack, stackType, component, params);
                    result |= 2;
                    if (kIsTraceEnabled) {
                        ManagedSocketMapHelper.getAgent().IAgent_getModuleFeedback().info(kManagedSocketModule, "adding to appmap (method level application)" + component);
                    }
                } else if (kIsTraceEnabled) {
                    ManagedSocketMapHelper.getAgent().IAgent_getModuleFeedback().info(kManagedSocketModule, "skipping add to appmap (method level application)" + component);
                }
            }
            if (reportClassBTEdge) {
                stackType = ReflectionHelper.getStackTypeClassBT();
                if (!componentTracer.peekLastMapComponentWasMe(stack, stackType, component)) {
                    if (params == null) {
                        params = new HashMap();
                        params.put("nodeType", kSocketNodeType);
                    }
                    componentTracer.addMapComponent(stack, stackType, component, params);
                    result |= 4;
                    if (kIsTraceEnabled) {
                        ManagedSocketMapHelper.getAgent().IAgent_getModuleFeedback().info(kManagedSocketModule, "adding to appmap (class level BT) " + component);
                    }
                } else if (kIsTraceEnabled) {
                    ManagedSocketMapHelper.getAgent().IAgent_getModuleFeedback().info(kManagedSocketModule, "skipping add to appmap (class level BT) " + component);
                }
            }
            if (reportMethodBTEdge) {
                stackType = ReflectionHelper.getStackTypeClassMethodBT();
                if (!componentTracer.peekLastMapComponentWasMe(stack, stackType, component)) {
                    if (params == null) {
                        params = new HashMap();
                        params.put("nodeType", kSocketNodeType);
                    }
                    componentTracer.addMapComponent(stack, stackType, component, params);
                    result |= 8;
                    if (kIsTraceEnabled) {
                        ManagedSocketMapHelper.getAgent().IAgent_getModuleFeedback().info(kManagedSocketModule, "adding to appmap (method level BT) " + component);
                    }
                } else if (kIsTraceEnabled) {
                    ManagedSocketMapHelper.getAgent().IAgent_getModuleFeedback().info(kManagedSocketModule, "skipping add to appmap (method level BT) " + component);
                }
            }
        }
        return result;
    }

    public static void removeFromAppMapIfEnabled(int addedComponentInfo, String component) {
        ComponentTracer componentTracer = ManagedSocketMapHelper.getAgent().IAgent_getComponentTracer();
        if (componentTracer.isAgentOldMode() && addedComponentInfo > 0 && addedComponentInfo != 16) {
            IBlameStack stack = componentTracer.getCurrentThreadStack(true);
            IStackType stackType = null;
            if ((addedComponentInfo & 1) == 1) {
                stackType = ReflectionHelper.getStackTypeClassApp();
                componentTracer.removeMapComponent(stack, stackType, component);
                if (kIsTraceEnabled) {
                    ManagedSocketMapHelper.getAgent().IAgent_getModuleFeedback().info(kManagedSocketModule, "removing from appmap (class level application) " + component);
                }
            }
            if ((addedComponentInfo & 2) == 2) {
                stackType = ReflectionHelper.getStackTypeClassMethodApp();
                componentTracer.removeMapComponent(stack, stackType, component);
                if (kIsTraceEnabled) {
                    ManagedSocketMapHelper.getAgent().IAgent_getModuleFeedback().info(kManagedSocketModule, "removing from appmap (method level application)" + component);
                }
            }
            if ((addedComponentInfo & 4) == 4) {
                stackType = ReflectionHelper.getStackTypeClassBT();
                componentTracer.removeMapComponent(stack, stackType, component);
                if (kIsTraceEnabled) {
                    ManagedSocketMapHelper.getAgent().IAgent_getModuleFeedback().info(kManagedSocketModule, "removing from appmap (class level BT) " + component);
                }
            }
            if ((addedComponentInfo & 8) == 8) {
                stackType = ReflectionHelper.getStackTypeClassMethodBT();
                componentTracer.removeMapComponent(stack, stackType, component);
                if (kIsTraceEnabled) {
                    ManagedSocketMapHelper.getAgent().IAgent_getModuleFeedback().info(kManagedSocketModule, "removing from appmap (method level BT) " + component);
                }
            }
        }
    }

    public static void markForAppMapIfEnabled(final String component, InvocationData start, Integer callingCursorIndex) {
        if (reportToAppMap && initializeStatus) {
            final HashMap<String, String> params = new HashMap<String, String>();
            params.put("nodeType", kSocketNodeType);
            if (reportClassApplicationEdge) {
                ReflectionHelper.invokeReplay("Application", "Class", start, callingCursorIndex, new ManagedSocketHelperReplayer(){

                    @Override
                    public void executeOnStack(IAppMapStack stack) {
                        stack.directAddMapComponent(component, params);
                        stack.directRemoveMapComponent(component, null);
                    }
                });
                if (kIsTraceEnabled) {
                    ManagedSocketMapHelper.getAgent().IAgent_getModuleFeedback().trace(kManagedSocketModule, "adding to appmap (class level application) " + component);
                }
            }
            if (reportMethodApplicationEdge) {
                ReflectionHelper.invokeReplay("Application", "MethodClass", start, callingCursorIndex, new ManagedSocketHelperReplayer(){

                    @Override
                    public void executeOnStack(IAppMapStack stack) {
                        stack.directAddMapComponent(component, params);
                        stack.directRemoveMapComponent(component, null);
                    }
                });
                if (kIsTraceEnabled) {
                    ManagedSocketMapHelper.getAgent().IAgent_getModuleFeedback().info(kManagedSocketModule, "adding to appmap (method level application)" + component);
                }
            }
            if (reportClassBTEdge) {
                ReflectionHelper.invokeReplay("BusinessTransactionComponent", "Class", start, callingCursorIndex, new ManagedSocketHelperReplayer(){

                    @Override
                    public void executeOnStack(IAppMapStack stack) {
                        stack.directAddMapComponent(component, params);
                        stack.directRemoveMapComponent(component, null);
                    }
                });
                if (kIsTraceEnabled) {
                    ManagedSocketMapHelper.getAgent().IAgent_getModuleFeedback().info(kManagedSocketModule, "adding to appmap (class level BT) " + component);
                }
            }
            if (reportMethodBTEdge) {
                ReflectionHelper.invokeReplay("BusinessTransactionComponent", "MethodClass", start, callingCursorIndex, new ManagedSocketHelperReplayer(){

                    @Override
                    public void executeOnStack(IAppMapStack stack) {
                        stack.directAddMapComponent(component, params);
                        stack.directRemoveMapComponent(component, null);
                    }
                });
                if (kIsTraceEnabled) {
                    ManagedSocketMapHelper.getAgent().IAgent_getModuleFeedback().info(kManagedSocketModule, "adding to appmap (method level BT) " + component);
                }
            }
        }
    }

    private static void lookupAppMapService() {
        block5: {
            try {
                IPlugin[] plugins = ManagedSocketMapHelper.getAgent().IAgent_getExtensionAdministrator().getAgentPluginsByType("service synch");
                int i = 0;
                while (i < plugins.length) {
                    if (plugins[i].IPlugin_getName().equalsIgnoreCase("App Map Tracing Service Plugin Entry Point")) {
                        ClassLoader loader = plugins[i].IPlugin_getOwningExtension().IExtension_getClassLoader();
                        ReflectionHelper.kAppMapClass = Class.forName("com.wily.introscope.appmap.agent.AppMapService", true, loader);
                        ReflectionHelper.kGetStackTypeMethod = ReflectionHelper.kAppMapClass.getDeclaredMethod("getStackType", ReflectionHelper.kGetStackTypeSignature);
                        if (ReflectionHelper.kAppMapClass != null && ReflectionHelper.kGetStackTypeMethod != null) {
                            initializeStatus = true;
                            break;
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                ManagedSocketMapHelper.getAgent().IAgent_getModuleFeedback().error(kManagedSocketModule, "Failure while trying to locate appmap service ");
                if (!ManagedSocketMapHelper.getAgent().IAgent_getModuleFeedback().isDebugEnabled()) break block5;
                ManagedSocketMapHelper.getAgent().IAgent_getModuleFeedback().debug(e);
            }
        }
    }

    public static IAgent getAgent() {
        return sAgent;
    }

    public static interface ManagedSocketHelperReplayer {
        public void executeOnStack(IAppMapStack var1);
    }
}

