/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.intelligent.examples;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.automatic.AutoTracingCollectStatus;
import com.wily.introscope.agent.trace.automatic.AutoTriggerComponent;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ISharedMetricHolder;
import com.wily.introscope.agent.trace.hc2.ASingleMetricTracerFactory;
import com.wily.introscope.agent.trace.intelligent.AutoTracingController;
import com.wily.introscope.agent.trace.intelligent.Logger;
import com.wily.util.properties.AttributeListing;
import java.util.List;

public class ExampleRevokeAutoTraceTriggerTracer
extends ASingleMetricTracerFactory {
    private static final String kTriggerComponentIdentifierRegexKey = "identifierregex";
    private static final String kTriggerComponentIdentifierRegexDefaultValue = ".*";
    private final String fTriggerComponentIdentifierRegex;

    public ExampleRevokeAutoTraceTriggerTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        String paramValue = this.getParameter(kTriggerComponentIdentifierRegexKey);
        this.fTriggerComponentIdentifierRegex = paramValue == null ? kTriggerComponentIdentifierRegexDefaultValue : paramValue;
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        AutoTracingCollectStatus tracingStatus = AutoTracingController.getAutoTracingCollectStatus(data);
        if (tracingStatus != null && tracingStatus.shouldTrace()) {
            List triggerComponentList = tracingStatus.getTriggerComponents();
            for (AutoTriggerComponent triggerComponent : triggerComponentList) {
                if (!triggerComponent.getIdentifier().matches(this.fTriggerComponentIdentifierRegex)) continue;
                if (Logger.isTraceEnabled()) {
                    Logger.logTraceMessage("Revoking automatic trace trigger.");
                }
                AutoTracingController.clearAutoTracing(data);
                break;
            }
        }
    }

    @Override
    protected IRepository getRepository(InvocationData data, ISharedMetricHolder holder) {
        return null;
    }

    @Override
    protected void doOnStartTrace(int tracerIndex, IStackElement data, ASingleMetricTracerFactory.ISingleMetricHolder mh) {
    }

    @Override
    protected void doOnEndTrace(int tracerIndex, IStackElement data, ASingleMetricTracerFactory.ISingleMetricHolder mh) {
    }
}

