/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.io;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerRateDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class SocketFormatMetricsCache {
    public static final int kInputStream = 8;
    public static final int kOutputStream = 7;
    public static final int kConcurrentWriters = 6;
    public static final int kConcurrentReaders = 5;
    public static final int kCloseCounter = 4;
    public static final int kAcceptCounter = 3;
    public static final int kConnectCounter = 2;
    public static final int kBackendTracer = 9;
    public static final int kCacheOnAllocate = 0;
    public static final int kCacheOnFinish = 1;
    public static final int kAppMapComponent = 10;
    private static final int kNumberOfMetricsCached = 11;
    private final String[] fFormattedMetrics;
    private final IDataAccumulator[] fAccumulators;
    private final int fPort;
    private final String fHostName;
    private final String fHostAddress;
    private final String fLocalAddress;
    private String fResourceName;
    private boolean fIsClientConnection;
    private AtomicInteger fInputStream = new AtomicInteger();
    private AtomicInteger fOutputStream = new AtomicInteger();
    private AtomicInteger fConcurrentWriters = new AtomicInteger();
    private AtomicInteger fConcurrentReaders = new AtomicInteger();
    private AtomicLong fCloseCounter = new AtomicLong();
    private AtomicLong fAcceptCounter = new AtomicLong();
    private AtomicLong fConnectCounter = new AtomicLong();
    private volatile boolean fInputStreamTouched = false;
    private volatile boolean fOutputStreamTouched = false;
    private volatile boolean fConcurrentWritersTouched = false;
    private volatile boolean fConcurrentReadersTouched = false;
    private volatile boolean fCloseCounterTouched = false;
    private volatile boolean fAcceptCounterTouched = false;
    private volatile boolean fConnectCounterTouched = false;

    protected SocketFormatMetricsCache(String localAddress, String hostName, String hostAddress, int port) {
        this.fHostName = hostName;
        this.fHostAddress = hostAddress;
        this.fLocalAddress = localAddress;
        this.fPort = port;
        this.fFormattedMetrics = new String[11];
        this.fAccumulators = new IDataAccumulator[11];
        this.fInputStreamTouched = false;
        this.fOutputStreamTouched = false;
        this.fConcurrentWritersTouched = false;
        this.fConcurrentReadersTouched = false;
        this.fCloseCounterTouched = false;
        this.fAcceptCounterTouched = false;
        this.fConnectCounterTouched = false;
    }

    public final String getFormattedMetrics(int position) {
        return this.fFormattedMetrics[position];
    }

    public final void setFormattedMetrics(String value, int position) {
        this.fFormattedMetrics[position] = value;
    }

    public final IDataAccumulator getAccumulators(int position) {
        return this.fAccumulators[position];
    }

    public final void setAccumulators(IDataAccumulator value, int position) {
        this.fAccumulators[position] = value;
    }

    public final int getPort() {
        return this.fPort;
    }

    public final String getHostName() {
        return this.fHostName;
    }

    public final String getHostAddress() {
        return this.fHostAddress;
    }

    public final String getLocalAddress() {
        return this.fLocalAddress;
    }

    public final void setResourceName(String fResourceName) {
        this.fResourceName = fResourceName;
    }

    public final String getResourceName() {
        return this.fResourceName;
    }

    public final void setClientConnection(boolean isClientConnection) {
        this.fIsClientConnection = isClientConnection;
    }

    public final boolean isClientConnection() {
        return this.fIsClientConnection;
    }

    public final void addToInputBandwidth(int value) {
        this.fInputStream.addAndGet(value);
        this.fInputStreamTouched = true;
    }

    public final void addToOutputBandwidth(int value) {
        this.fOutputStream.addAndGet(value);
        this.fOutputStreamTouched = true;
    }

    public final void addToCloseCounter() {
        this.fCloseCounter.incrementAndGet();
        this.fCloseCounterTouched = true;
    }

    public final void addToAcceptCounter() {
        this.fAcceptCounter.incrementAndGet();
        this.fAcceptCounterTouched = true;
    }

    public final void addToConnectCounter() {
        this.fConnectCounter.incrementAndGet();
        this.fConnectCounterTouched = true;
    }

    public final void addToConcurrentWriters() {
        this.fConcurrentWriters.incrementAndGet();
        this.fConcurrentWritersTouched = true;
    }

    public final void removeFromConcurrentWriters() {
        this.fConcurrentWriters.decrementAndGet();
        this.fConcurrentWritersTouched = true;
    }

    public final void addToConcurrentReaders() {
        this.fConcurrentReaders.incrementAndGet();
        this.fConcurrentReadersTouched = true;
    }

    public final void removeFromConcurrentReaders() {
        this.fConcurrentReaders.decrementAndGet();
        this.fConcurrentReadersTouched = true;
    }

    protected final DataAccumulatorFactory getDataAccumulatorFactory() throws AgentNotAvailableException {
        return AgentShim.getAgent().IAgent_getDataAccumulatorFactory();
    }

    public final IDataAccumulator checkAccumulator(int position, boolean touched) {
        IDataAccumulator acc = null;
        if (touched && (acc = this.fAccumulators[position]) != null && acc.isRemoved()) {
            try {
                switch (position) {
                    case 5: 
                    case 6: {
                        acc = this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(this.getFormattedMetrics(position));
                        break;
                    }
                    case 7: 
                    case 8: {
                        acc = this.getDataAccumulatorFactory().safeGetIntegerRateDataAccumulator(this.getFormattedMetrics(position));
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        acc = this.getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(this.getFormattedMetrics(position));
                    }
                }
            }
            catch (AgentNotAvailableException agentNotAvailableException) {
                acc = null;
            }
        }
        return acc;
    }

    public final void pollConcurrentMetrics() {
        IDataAccumulator acc = this.checkAccumulator(6, this.fConcurrentWritersTouched);
        if (acc != null) {
            ((IIntegerFluctuatingCounterDataAccumulator)acc).IIntegerCounterDataAccumulator_setValue(this.fConcurrentWriters.get());
        }
        if ((acc = this.checkAccumulator(5, this.fConcurrentReadersTouched)) != null) {
            ((IIntegerFluctuatingCounterDataAccumulator)acc).IIntegerCounterDataAccumulator_setValue(this.fConcurrentReaders.get());
        }
        if ((acc = this.checkAccumulator(8, this.fInputStreamTouched)) != null) {
            ((IIntegerRateDataAccumulator)acc).IIntegerRateDataAccumulator_addBatchIncidents(this.fInputStream.getAndSet(0));
        }
        if ((acc = this.checkAccumulator(7, this.fOutputStreamTouched)) != null) {
            ((IIntegerRateDataAccumulator)acc).IIntegerRateDataAccumulator_addBatchIncidents(this.fOutputStream.getAndSet(0));
        }
        if ((acc = this.checkAccumulator(4, this.fCloseCounterTouched)) != null) {
            ((ILongIntervalCounterDataAccumulator)acc).ILongIntervalCounterDataAccumulator_addBatchIncidents(this.fCloseCounter.getAndSet(0L));
        }
        if ((acc = this.checkAccumulator(3, this.fAcceptCounterTouched)) != null) {
            ((ILongIntervalCounterDataAccumulator)acc).ILongIntervalCounterDataAccumulator_addBatchIncidents(this.fAcceptCounter.getAndSet(0L));
        }
        if ((acc = this.checkAccumulator(2, this.fConnectCounterTouched)) != null) {
            ((ILongIntervalCounterDataAccumulator)acc).ILongIntervalCounterDataAccumulator_addBatchIncidents(this.fConnectCounter.getAndSet(0L));
        }
        this.fInputStreamTouched = false;
        this.fOutputStreamTouched = false;
        this.fConcurrentWritersTouched = false;
        this.fConcurrentReadersTouched = false;
        this.fCloseCounterTouched = false;
        this.fAcceptCounterTouched = false;
        this.fConnectCounterTouched = false;
    }
}

