/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.api.instrument;

import com.wily.introscope.agent.IAgent;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.properties.hot.StringSetConfigurationProperty;
import com.wily.util.text.IStringLocalizer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Set;

public class ClassRedefinitionWriter {
    private static final String kSaveTransformedClasses = "com.wily.debug.saveRedefinedClasses";
    private static final String kSaveTransformedClassesDir = "com.wily.debug.saveRedefinedClasses.dir";
    private static final String kSaveTransformedClassesNames = "com.wily.debug.saveRedefinedClasses.names";
    private static volatile boolean sSaveTransformedClasses;
    private static volatile String sSaveTransformedClassesDir;
    private static volatile Set sSaveTransformedClassesNames;
    private static ClassRedefinitionWriter instance;
    private final IModuleFeedbackChannel fFeedback;
    private final Module fModule;
    private final IStringLocalizer fLocalizer;

    static synchronized ClassRedefinitionWriter getClassRedefinitionWriter(IAgent agent) {
        if (instance == null && agent != null) {
            ConfigurationManager cm = agent.IAgent_getConfigurationManager();
            cm.add(new BooleanConfigurationProperty(kSaveTransformedClasses, Boolean.FALSE, null, agent.IAgent_getModule(), agent.IAgent_getStringLocalizer()){

                @Override
                public final void set(Object value) {
                    sSaveTransformedClasses = (Boolean)value;
                }
            });
            cm.add(new ConfigurationProperty(kSaveTransformedClassesDir, String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + "wilyRedefinedClasses", null, agent.IAgent_getModule(), agent.IAgent_getStringLocalizer()){

                @Override
                public final void set(Object value) {
                    sSaveTransformedClassesDir = (String)value;
                }
            });
            cm.add(new StringSetConfigurationProperty(kSaveTransformedClassesNames, null, null, agent.IAgent_getModule(), agent.IAgent_getStringLocalizer()){

                @Override
                public final void set(Object value) {
                    Set cv = (Set)value;
                    sSaveTransformedClassesNames = cv == null || cv.size() == 0 ? null : cv;
                }
            });
            instance = new ClassRedefinitionWriter(agent);
        } else if (agent == null) {
            instance = new ClassRedefinitionWriter();
        }
        return instance;
    }

    private ClassRedefinitionWriter(IAgent fAgent) {
        this.fFeedback = fAgent.IAgent_getModuleFeedback();
        this.fModule = fAgent.IAgent_getModule();
        this.fLocalizer = fAgent.IAgent_getStringLocalizer();
    }

    private ClassRedefinitionWriter() {
        this.fFeedback = null;
        this.fModule = null;
        this.fLocalizer = null;
        sSaveTransformedClasses = false;
    }

    public void saveRedefinedClass(Class cls, byte[] classBytes) {
        this.saveClass(cls, classBytes, "Saved_Redefined_Class");
    }

    public void saveRetransformedClass(Class cls, byte[] classBytes) {
        this.saveClass(cls, classBytes, "Saved_Retransformed_Class");
    }

    private void saveClass(Class cls, byte[] classBytes, String message) {
        if (!sSaveTransformedClasses) {
            return;
        }
        if (sSaveTransformedClassesNames != null && !sSaveTransformedClassesNames.contains(cls.getName())) {
            return;
        }
        File saveClass = new File(String.valueOf(sSaveTransformedClassesDir) + File.separator + cls.getName().replace(".", File.separator));
        saveClass.getParentFile().mkdirs();
        String saveClassFileName = String.valueOf(saveClass.toString()) + ".class";
        try {
            FileOutputStream fos = new FileOutputStream(saveClassFileName);
            fos.write(classBytes);
            fos.close();
            this.fFeedback.debug(this.fModule, this.fLocalizer.IStringLocalizer_getFormattedLocalizedString(message, saveClassFileName));
        }
        catch (IOException e) {
            this.fFeedback.debug(this.fModule, this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Save_Redefined_Class_Failed", saveClassFileName, e.toString()), e);
        }
    }
}

