/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.extensions.agent.socketfactory;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.extension.ExtensionAdministrator;
import com.wily.isengard.postofficehub.link.net.ISocketFactory;
import com.wily.util.extension.ExtensionUtilities;
import com.wily.util.extension.IPlugin;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class SocketFactoryAdministrator {
    private static final String kSocketFactoryPluginType = "socketfactory";
    private static final int kExpectedVersion = 1;
    private final IAgent fAgent;
    private final List fClasses;

    public List getSocketFactoryClasses() {
        return this.fClasses;
    }

    public SocketFactoryAdministrator(IAgent agent) {
        this.fAgent = agent;
        this.fClasses = Collections.unmodifiableList(this.loadSocketFactoryPlugins());
    }

    private final IAgent getAgent() {
        return this.fAgent;
    }

    private final IModuleFeedbackChannel getModuleFeedback() {
        return this.getAgent().IAgent_getModuleFeedback();
    }

    private final IStringLocalizer getStringLocalizer() {
        return this.getAgent().IAgent_getStringLocalizer();
    }

    private final ExtensionAdministrator getExtensionAdministrator() {
        return this.getAgent().IAgent_getExtensionAdministrator();
    }

    private List loadSocketFactoryPlugins() {
        ExtensionAdministrator extensionAdministrator = this.getExtensionAdministrator();
        Assertion.wilyAssert(false);
        ArrayList<Class> classes = new ArrayList<Class>();
        IPlugin[] plugins = extensionAdministrator.getAgentPluginsByType(kSocketFactoryPluginType);
        if (plugins != null && plugins.length > 0) {
            try {
                Class clazz = ExtensionUtilities.loadEntryPointClass(this.getModuleFeedback(), this.getStringLocalizer(), plugins[0], 1, ISocketFactory.class);
                if (clazz != null) {
                    classes.add(clazz);
                    this.getModuleFeedback().verbose(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_SocketFactory_Class_Loaded_Message", clazz.getName()));
                }
            }
            catch (Throwable t) {
                this.getModuleFeedback().error(t);
            }
        }
        return classes;
    }
}

