/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.properties;

public class HelpLinksUtils {
    public static final String DOCOPS_DOMAIN = "docops";
    public static final String SPACE_PLACEHOLDER = "{space}";
    public static final String LANGUAGE_PLACEHOLDER = "{language}";
    public static final String DEFAULT_LANGUAGE_CODE = "";
    public static final String UNKNOWN_RELEASE_STRING = "unknown";
    public static final String FEATURE_BRANCH_RELEASE_STRING = "99.99.";
    public static final String PLACEHOLDER_RELEASE_STRING_1 = "${";
    public static final String PLACEHOLDER_RELEASE_STRING_2 = "release_string";
    public static final String PLACEHOLDER_RELEASE_STRING_3 = "@";
    public static final String PLACEHOLDER_RELEASE_STRING_4 = "docops_release_space_override_string";
    public static final String[] DEV_RELEASE_PLACEHOLDERS = new String[]{"unknown", "99.99.", "${", "release_string", "@", "docops_release_space_override_string"};
    public static final String DEFAULT_DEVELOPMENT_SPACE = "DEV";

    public static String formatHelpLinkUrl(String helpLink, String releaseString, String language) {
        if (helpLink == null) {
            return DEFAULT_LANGUAGE_CODE;
        }
        helpLink = HelpLinksUtils.formatSpaceForHelpLinkSpace(helpLink, releaseString);
        return HelpLinksUtils.formatLanguageForHelpLinkSpace(helpLink, language);
    }

    public static boolean isUndefinedReleaseString(String releaseString) {
        if (releaseString != null) {
            if (DEFAULT_LANGUAGE_CODE.equals(releaseString = releaseString.trim().toLowerCase())) {
                return true;
            }
            int i = 0;
            while (i < DEV_RELEASE_PLACEHOLDERS.length) {
                String releasePlaceholder = DEV_RELEASE_PLACEHOLDERS[i];
                if (releaseString.indexOf(releasePlaceholder) >= 0) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    public static String formatSpaceForHelpLinkSpace(String helpLink, String releaseString) {
        if (helpLink == null) {
            return DEFAULT_LANGUAGE_CODE;
        }
        if (HelpLinksUtils.isUndefinedReleaseString(releaseString)) {
            releaseString = DEFAULT_DEVELOPMENT_SPACE;
        }
        return HelpLinksUtils.replacePlaceholderWithValue(helpLink, SPACE_PLACEHOLDER, new DocOpsSpaceProvider(releaseString), DEFAULT_DEVELOPMENT_SPACE);
    }

    public static String formatLanguageForHelpLinkSpace(String helpLink, String language) {
        if (helpLink == null) {
            return DEFAULT_LANGUAGE_CODE;
        }
        return HelpLinksUtils.replacePlaceholderWithValue(helpLink, LANGUAGE_PLACEHOLDER, new LanguageProvider(language), DEFAULT_LANGUAGE_CODE);
    }

    public static String transformReleaseStringForDocOpsSpace(String releaseString) {
        if (releaseString == null) {
            return DEFAULT_LANGUAGE_CODE;
        }
        String[] releaseParts = releaseString.split("\\.");
        StringBuilder strBuf = new StringBuilder();
        int count = releaseParts.length > 2 ? 2 : releaseParts.length;
        int i = 0;
        while (i < count) {
            strBuf.append(releaseParts[i]);
            ++i;
        }
        String result = strBuf.toString();
        return result.length() > 3 ? result.substring(0, 3) : result;
    }

    public static String validateLanguage(String language) {
        String string = language = language == null ? DEFAULT_LANGUAGE_CODE : language.toLowerCase();
        language = "zh-tw".equals(language) || "zh_tw".equals(language) || "zh-TW".equals(language) || "tw".equals(language) ? "tw" : ("zh".equals(language) || "cn".equals(language) ? "cn" : ("ja".equals(language) || "jp".equals(language) ? "jp" : ("ko".equals(language) || "kr".equals(language) ? "kr" : DEFAULT_LANGUAGE_CODE)));
        return language;
    }

    private static String replacePlaceholderWithValue(String str, String placeholder, ValueProvider valueProvider, String defaultValue) {
        String loweredPlaceholder;
        String loweredStr = str.toLowerCase();
        int placeholderInd = loweredStr.indexOf(loweredPlaceholder = placeholder.toLowerCase());
        if (placeholderInd >= 0) {
            String value = valueProvider.getValue(defaultValue);
            StringBuilder strBuf = new StringBuilder();
            strBuf.append(str.substring(0, placeholderInd)).append(value).append(str.substring(placeholderInd + placeholder.length()));
            return strBuf.toString();
        }
        return str;
    }

    static class DocOpsSpaceProvider
    extends ValueProvider {
        DocOpsSpaceProvider() {
        }

        DocOpsSpaceProvider(String releaseString) {
            super(releaseString);
        }

        @Override
        public String getValue(String defaultValue) {
            if (this.value == null) {
                return defaultValue;
            }
            return HelpLinksUtils.transformReleaseStringForDocOpsSpace(this.value);
        }
    }

    static class LanguageProvider
    extends ValueProvider {
        LanguageProvider() {
        }

        LanguageProvider(String language) {
            super(language);
        }

        @Override
        public String getValue(String defaultValue) {
            if (this.value == null) {
                return defaultValue;
            }
            return HelpLinksUtils.validateLanguage(this.value);
        }
    }

    static class ValueProvider {
        protected String value;

        ValueProvider() {
        }

        ValueProvider(String value) {
            this.value = value;
        }

        public String getValue(String defaultValue) {
            return this.value != null ? this.value : defaultValue;
        }
    }
}

