/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.messageprimitives;

import com.wily.isengard.messageprimitives.MethodNotFoundError;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;

public class InterfaceDescriptor
implements Comparator {
    private final Method[] fMethodList;
    private final Class fClass;

    public InterfaceDescriptor(Class clazz) {
        this.fClass = clazz;
        TreeSet<Method> sortedList = new TreeSet<Method>(this);
        Method[] methods = clazz.getMethods();
        sortedList.addAll(Arrays.asList(methods));
        this.fMethodList = new Method[methods.length];
        Iterator iterator = sortedList.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            this.fMethodList[i++] = (Method)iterator.next();
        }
    }

    public int getIndex(Method m) {
        int i = 0;
        while (i < this.fMethodList.length) {
            if (this.fMethodList[i] == m) {
                return i;
            }
            ++i;
        }
        throw new MethodNotFoundError(m, this.fClass);
    }

    public Method getMethod(int index) {
        return this.fMethodList[index];
    }

    public int compare(Object o1, Object o2) {
        Class<?>[] p2;
        Method m1 = (Method)o1;
        Method m2 = (Method)o2;
        int i = m1.getName().compareTo(m2.getName());
        if (i != 0) {
            return i;
        }
        Class<?>[] p1 = m1.getParameterTypes();
        if (p1.length != (p2 = m2.getParameterTypes()).length) {
            return p1.length - p2.length;
        }
        int k = 0;
        while (k < p1.length) {
            i = p1[k].getName().compareTo(p2[k].getName());
            if (i != 0) {
                return i;
            }
            ++k;
        }
        return 0;
    }
}

