/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.messageprimitives.sink;

import com.wily.isengard.message.AMessage;
import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.InterfaceUtilities;
import com.wily.isengard.messageprimitives.MethodCallMessage;
import com.wily.isengard.messageprimitives.sink.IMessageSinkService;
import com.wily.isengard.messageprimitives.sink.MessageSink;
import com.wily.isengard.postoffice.Address;
import com.wily.isengard.postoffice.Mailbox;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.util.feedback.Module;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class MessageSinkClient
extends Mailbox
implements InvocationHandler {
    private static Module sModule = new Module("MessageSinkClient");
    private Class fSinkInterface;
    private int fInterfaceVersion;
    private Address fSinkAddress;
    private Address fSinkPublishingAddress;
    private Object fProxy;

    public MessageSinkClient(PostOffice po, Class sinkInterface, Address sinkAddress) {
        super(po);
        this.fSinkInterface = sinkInterface;
        this.fSinkAddress = sinkAddress;
    }

    protected void setServiceAddress(Address sinkAddress) {
        this.fSinkAddress = sinkAddress;
    }

    public void startPublishing() throws ConnectionException {
        IMessageSinkService sinkService = MessageSink.getInterface(this.getPostOffice(), this.fSinkAddress);
        this.fSinkPublishingAddress = sinkService.startPublishing(this.getAddress());
        this.fInterfaceVersion = InterfaceUtilities.getInterfaceVersion(this.fSinkInterface);
        this.fProxy = Proxy.newProxyInstance(this.fSinkInterface.getClassLoader(), new Class[]{this.fSinkInterface}, (InvocationHandler)this);
    }

    public Object getPublisher() {
        return this.fProxy;
    }

    @Override
    public void receiveMessage(AMessage message) {
        this.getFeedbackChannel().error(sModule, "Should not have received message " + message, new Exception());
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MethodCallMessage message = new MethodCallMessage(method, this.fInterfaceVersion, args);
        this.sendMessage(message, this.fSinkPublishingAddress);
        return null;
    }

    @Override
    public void close() {
        IMessageSinkService sinkService = MessageSink.getInterface(this.getPostOffice(), this.fSinkAddress);
        try {
            try {
                sinkService.stopPublishing(this.getAddress());
            }
            catch (Throwable throwable) {
                super.close();
            }
        }
        finally {
            super.close();
        }
    }
}

