/*
 * Decompiled with CFR 0.152.
 */
package com.wily.org.apache.commons.httpclient;

import com.wily.org.apache.commons.httpclient.Header;
import com.wily.org.apache.commons.httpclient.HttpConnection;
import com.wily.org.apache.commons.httpclient.HttpException;
import com.wily.org.apache.commons.httpclient.HttpMethod;
import com.wily.org.apache.commons.httpclient.HttpMethodBase;
import com.wily.org.apache.commons.httpclient.HttpState;
import com.wily.org.apache.commons.httpclient.Wire;
import com.wily.org.apache.commons.logging.Log;
import com.wily.org.apache.commons.logging.LogFactory;
import java.io.IOException;

public class ConnectMethod
extends HttpMethodBase {
    public static final String NAME = "CONNECT";
    private static final Log LOG;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.wily.org.apache.commons.httpclient.ConnectMethod");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog(clazz);
    }

    public ConnectMethod() {
        LOG.trace("enter ConnectMethod()");
    }

    public ConnectMethod(HttpMethod method) {
        LOG.trace("enter ConnectMethod(HttpMethod)");
    }

    public String getName() {
        return NAME;
    }

    protected void addCookieRequestHeader(HttpState state, HttpConnection conn) throws IOException, HttpException {
    }

    protected void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        LOG.trace("enter ConnectMethod.addRequestHeaders(HttpState, HttpConnection)");
        this.addUserAgentRequestHeader(state, conn);
        this.addHostRequestHeader(state, conn);
        this.addProxyConnectionHeader(state, conn);
    }

    public int execute(HttpState state, HttpConnection conn) throws IOException, HttpException {
        LOG.trace("enter ConnectMethod.execute(HttpState, HttpConnection)");
        int code = super.execute(state, conn);
        if (LOG.isDebugEnabled()) {
            LOG.debug("CONNECT status code " + code);
        }
        return code;
    }

    protected void writeRequestLine(HttpState state, HttpConnection conn) throws IOException, HttpException {
        int port = conn.getPort();
        if (port == -1) {
            port = conn.getProtocol().getDefaultPort();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getName());
        buffer.append(' ');
        buffer.append(conn.getHost());
        if (port > -1) {
            buffer.append(':');
            buffer.append(port);
        }
        buffer.append(" ");
        buffer.append(this.getEffectiveVersion());
        String line = buffer.toString();
        conn.printLine(line, this.getParams().getHttpElementCharset());
        if (Wire.HEADER_WIRE.enabled()) {
            Wire.HEADER_WIRE.output(line);
        }
    }

    protected boolean shouldCloseConnection(HttpConnection conn) {
        if (this.getStatusCode() == 200) {
            Header connectionHeader = null;
            if (!conn.isTransparent()) {
                connectionHeader = this.getResponseHeader("proxy-connection");
            }
            if (connectionHeader == null) {
                connectionHeader = this.getResponseHeader("connection");
            }
            if (connectionHeader != null && connectionHeader.getValue().equalsIgnoreCase("close") && LOG.isWarnEnabled()) {
                LOG.warn("Invalid header encountered '" + connectionHeader.toExternalForm() + "' in response " + this.getStatusLine().toString());
            }
            return false;
        }
        return super.shouldCloseConnection(conn);
    }
}

