/*
 * Decompiled with CFR 0.152.
 */
package com.wily.org.apache.commons.io.filefilter;

import com.wily.org.apache.commons.io.filefilter.AndFileFilter;
import com.wily.org.apache.commons.io.filefilter.DelegateFileFilter;
import com.wily.org.apache.commons.io.filefilter.DirectoryFileFilter;
import com.wily.org.apache.commons.io.filefilter.FalseFileFilter;
import com.wily.org.apache.commons.io.filefilter.IOFileFilter;
import com.wily.org.apache.commons.io.filefilter.NameFileFilter;
import com.wily.org.apache.commons.io.filefilter.NotFileFilter;
import com.wily.org.apache.commons.io.filefilter.OrFileFilter;
import com.wily.org.apache.commons.io.filefilter.PrefixFileFilter;
import com.wily.org.apache.commons.io.filefilter.SuffixFileFilter;
import com.wily.org.apache.commons.io.filefilter.TrueFileFilter;
import java.io.FileFilter;
import java.io.FilenameFilter;

public class FileFilterUtils {
    private static IOFileFilter cvsFilter;
    private static IOFileFilter svnFilter;

    public static IOFileFilter prefixFileFilter(String prefix) {
        return new PrefixFileFilter(prefix);
    }

    public static IOFileFilter suffixFileFilter(String suffix) {
        return new SuffixFileFilter(suffix);
    }

    public static IOFileFilter nameFileFilter(String name) {
        return new NameFileFilter(name);
    }

    public static IOFileFilter directoryFileFilter() {
        return DirectoryFileFilter.INSTANCE;
    }

    public static IOFileFilter andFileFilter(IOFileFilter filter1, IOFileFilter filter2) {
        return new AndFileFilter(filter1, filter2);
    }

    public static IOFileFilter orFileFilter(IOFileFilter filter1, IOFileFilter filter2) {
        return new OrFileFilter(filter1, filter2);
    }

    public static IOFileFilter notFileFilter(IOFileFilter filter) {
        return new NotFileFilter(filter);
    }

    public static IOFileFilter trueFileFilter() {
        return TrueFileFilter.INSTANCE;
    }

    public static IOFileFilter falseFileFilter() {
        return FalseFileFilter.INSTANCE;
    }

    public static IOFileFilter asFileFilter(FileFilter filter) {
        return new DelegateFileFilter(filter);
    }

    public static IOFileFilter asFileFilter(FilenameFilter filter) {
        return new DelegateFileFilter(filter);
    }

    public static IOFileFilter makeCVSAware(IOFileFilter filter) {
        if (cvsFilter == null) {
            cvsFilter = FileFilterUtils.notFileFilter(FileFilterUtils.andFileFilter(FileFilterUtils.directoryFileFilter(), FileFilterUtils.nameFileFilter("CVS")));
        }
        if (filter == null) {
            return cvsFilter;
        }
        return FileFilterUtils.andFileFilter(filter, cvsFilter);
    }

    public static IOFileFilter makeSVNAware(IOFileFilter filter) {
        if (svnFilter == null) {
            svnFilter = FileFilterUtils.notFileFilter(FileFilterUtils.andFileFilter(FileFilterUtils.directoryFileFilter(), FileFilterUtils.nameFileFilter(".svn")));
        }
        if (filter == null) {
            return svnFilter;
        }
        return FileFilterUtils.andFileFilter(filter, svnFilter);
    }
}

