/*
 * Decompiled with CFR 0.152.
 */
package com.wily.org.apache.commons.io.input;

import com.wily.org.apache.commons.io.input.ProxyInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CountingInputStream
extends ProxyInputStream {
    private int count;

    public CountingInputStream(InputStream in) {
        super(in);
    }

    public int read(byte[] b) throws IOException {
        int found = super.read(b);
        this.count += found >= 0 ? found : 0;
        return found;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int found = super.read(b, off, len);
        this.count += found >= 0 ? found : 0;
        return found;
    }

    public int read() throws IOException {
        int found = super.read();
        this.count += found >= 0 ? 1 : 0;
        return found;
    }

    public long skip(long length) throws IOException {
        long skip = super.skip(length);
        this.count = (int)((long)this.count + skip);
        return skip;
    }

    public int getCount() {
        return this.count;
    }

    public synchronized int resetCount() {
        int tmp = this.count;
        this.count = 0;
        return tmp;
    }
}

