/*
 * Decompiled with CFR 0.152.
 */
package com.wily.org.apache.commons.io.output;

import com.wily.org.apache.commons.io.IOUtils;
import com.wily.org.apache.commons.io.output.ByteArrayOutputStream;
import com.wily.org.apache.commons.io.output.ThresholdingOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DeferredFileOutputStream
extends ThresholdingOutputStream {
    private ByteArrayOutputStream memoryOutputStream;
    private OutputStream currentOutputStream;
    private File outputFile;
    private boolean closed = false;

    public DeferredFileOutputStream(int threshold, File outputFile) {
        super(threshold);
        this.outputFile = outputFile;
        this.memoryOutputStream = new ByteArrayOutputStream();
        this.currentOutputStream = this.memoryOutputStream;
    }

    protected OutputStream getStream() throws IOException {
        return this.currentOutputStream;
    }

    protected void thresholdReached() throws IOException {
        FileOutputStream fos = new FileOutputStream(this.outputFile);
        this.memoryOutputStream.writeTo(fos);
        this.currentOutputStream = fos;
        this.memoryOutputStream = null;
    }

    public boolean isInMemory() {
        return !this.isThresholdExceeded();
    }

    public byte[] getData() {
        if (this.memoryOutputStream != null) {
            return this.memoryOutputStream.toByteArray();
        }
        return null;
    }

    public File getFile() {
        return this.outputFile;
    }

    public void close() throws IOException {
        super.close();
        this.closed = true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeTo(OutputStream out) throws IOException {
        if (!this.closed) {
            throw new IOException("Stream not closed");
        }
        if (this.isInMemory()) {
            this.memoryOutputStream.writeTo(out);
            return;
        }
        FileInputStream fis = new FileInputStream(this.outputFile);
        try {
            IOUtils.copy((InputStream)fis, out);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            IOUtils.closeQuietly(fis);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        IOUtils.closeQuietly(fis);
    }
}

