/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sqlparamagent;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.wily.introscope.agent.sqlparamagent.SQLAgentConfiguration;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class BucketHolder {
    private static BucketHolder instance = null;
    private final SQLAgentConfiguration configuration;
    private final ConcurrentMap<Object, Map<String, String>> paramBucket;
    private final ConcurrentMap<Object, AtomicInteger> resultSetBucket;
    private volatile boolean preparedStatementCacheWarningLogged = false;
    private volatile boolean resultSetCacheWarningLogged = false;

    private BucketHolder(SQLAgentConfiguration conf) {
        this.configuration = conf;
        Cache paramBucketCache = CacheBuilder.newBuilder().weakKeys().maximumSize(conf.getMaxPreparedStatements()).removalListener(new RemovalListener<Object, Map>(){

            @Override
            public void onRemoval(RemovalNotification<Object, Map> notification) {
                RemovalCause cause;
                if (!BucketHolder.this.preparedStatementCacheWarningLogged && (cause = notification.getCause()) == RemovalCause.SIZE) {
                    ((BucketHolder)BucketHolder.this).configuration.fFeedback.warn(SQLAgentConfiguration.kModule, "Prepared statement cache max limit exceeded.");
                    BucketHolder.this.preparedStatementCacheWarningLogged = true;
                }
            }
        }).build();
        this.paramBucket = paramBucketCache.asMap();
        Cache resultSetBucketCache = CacheBuilder.newBuilder().weakKeys().maximumSize(conf.getMaxResultSets()).removalListener(new RemovalListener<Object, AtomicInteger>(){

            @Override
            public void onRemoval(RemovalNotification<Object, AtomicInteger> notification) {
                RemovalCause cause;
                if (!BucketHolder.this.resultSetCacheWarningLogged && (cause = notification.getCause()) == RemovalCause.SIZE) {
                    ((BucketHolder)BucketHolder.this).configuration.fFeedback.warn(SQLAgentConfiguration.kModule, "Result set cache max limit exceeded.");
                    BucketHolder.this.resultSetCacheWarningLogged = true;
                }
            }
        }).build();
        this.resultSetBucket = resultSetBucketCache.asMap();
    }

    public static final synchronized BucketHolder getInstance(SQLAgentConfiguration configuration) {
        if (instance == null) {
            instance = new BucketHolder(configuration);
        }
        return instance;
    }

    public void putParamListInBucket(Object key, Map<String, String> value) {
        this.paramBucket.put(key, value);
    }

    public Map<String, String> getParamListFromBucket(Object key) {
        return (Map)this.paramBucket.get(key);
    }

    public Map<String, String> getAndRemoveParamListFromBucket(Object key) {
        return (Map)this.paramBucket.remove(key);
    }

    public void removeParamListFromBucket(Object key) {
        this.paramBucket.remove(key);
    }

    public void removeFromResultSetBucket(Object tracedObject) {
        this.resultSetBucket.remove(tracedObject);
    }

    public AtomicInteger getAndRemoveFromResultSetBucket(Object tracedObject) {
        return (AtomicInteger)this.resultSetBucket.remove(tracedObject);
    }

    public AtomicInteger getFromResultSetBucket(Object invocationObject) {
        return (AtomicInteger)this.resultSetBucket.get(invocationObject);
    }

    public void putInResultSetBucket(Object invocationObject, AtomicInteger rowCount) {
        this.resultSetBucket.put(invocationObject, rowCount);
    }

    public int getSQLBucketCount() {
        return this.paramBucket.size();
    }

    public int getResultSetBucketCount() {
        return this.resultSetBucket.size();
    }
}

