/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui;

import com.wily.properties.KUICommonStringsKeys;
import com.wily.properties.KUIErrorMessagesKeys;
import com.wily.ui.IGenericServices;
import com.wily.ui.WilyFieldListener;
import com.wily.ui.WilyIntegerTextField;
import com.wily.ui.WilyUIUtilities;
import com.wily.ui.action.ATwoWayExtendedAction;
import com.wily.ui.action.IExtendedAction;
import com.wily.util.IStateSaver;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.validate.IValidatable;
import com.wily.util.validate.IdentifiableObjectValidationException;
import com.wily.util.validate.KValidationConstants;
import com.wily.util.validate.ValidationException;
import com.wily.util.validate.ValidationInvalidBoundedLongException;
import com.wily.util.validate.ValidationInvalidContentFormatException;
import com.wily.util.validate.ValidationUtilities;
import com.wily.wilyassert.Assertion;
import com.wily.wilyassert.SwingAssertion;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.EventListener;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicArrowButton;

public class WilyDurationPanel
extends JPanel
implements IStateSaver,
IValidatable,
KUICommonStringsKeys,
KUIErrorMessagesKeys,
KValidationConstants {
    private static final long serialVersionUID = -4769421506830343309L;
    private IGenericServices fGenericServices;
    private IExtendedAction fIncrementFocusedFieldAction;
    private IExtendedAction fDecrementFocusedFieldAction;
    private WilyIntegerTextField fHoursField;
    private WilyIntegerTextField fMinutesField;
    private WilyIntegerTextField fSecondsField;
    private WilyIntegerTextField fFocusedField;
    private JButton fIncrementButton;
    private JButton fDecrementButton;
    private boolean fEnabled = true;
    protected static final int kDefaultDuration = 0;
    private static final String kDurationPanelContentsStatePrefixKey = "kDurationPanel_Contents_";
    private static final String kDurationPanelHoursContentsStateKey = "kDurationPanel_Contents_Hours_";
    private static final String kDurationPanelMinutesContentsStateKey = "kDurationPanel_Contents_Minutes_";
    private static final String kDurationPanelSecondsContentsStateKey = "kDurationPanel_Contents_Seconds_";
    private static final Dimension zeroSize = new Dimension(0, 0);

    public WilyDurationPanel(IGenericServices genericServices) {
        this.initialize(genericServices, 0);
    }

    public WilyDurationPanel(IGenericServices genericServices, int initialDuration) {
        this.initialize(genericServices, initialDuration);
    }

    private void initialize(IGenericServices genericServices, int initialDuration) {
        Assertion.wilyAssert(genericServices != null);
        this.fGenericServices = genericServices;
        this.fIncrementFocusedFieldAction = new IncrementFocusedFieldAction();
        this.fDecrementFocusedFieldAction = new DecrementFocusedFieldAction();
        this.initializeUI();
        this.setDurationInSeconds(initialDuration);
    }

    private void initializeUI() {
        this.setLayout(new SpinnerLayout());
        FieldFocusListener fieldFocusListener = new FieldFocusListener();
        IStringLocalizer local = this.fGenericServices.IGenericServices_getStringLocalizer();
        String hours = local.IStringLocalizer_getLocalizedString("Duration_Panel_Hours_Unit");
        String minutes = local.IStringLocalizer_getLocalizedString("Duration_Panel_Minutes_Unit");
        String seconds = local.IStringLocalizer_getLocalizedString("Duration_Panel_Seconds_Unit");
        this.fHoursField = new WilyIntegerTextField(this.getGenericServices());
        this.fHoursField.setColumns(4);
        this.fHoursField.setAutoSelectWhenFocusGained(true);
        this.fHoursField.setHorizontalAlignment(4);
        this.fHoursField.addFocusListener(fieldFocusListener);
        this.fMinutesField = new WilyIntegerTextField(this.getGenericServices());
        this.fMinutesField.setColumns(3);
        this.fMinutesField.setAutoSelectWhenFocusGained(true);
        this.fMinutesField.setHorizontalAlignment(4);
        this.fMinutesField.addFocusListener(fieldFocusListener);
        this.fSecondsField = new WilyIntegerTextField(this.getGenericServices());
        this.fSecondsField.setColumns(3);
        this.fSecondsField.setAutoSelectWhenFocusGained(true);
        this.fSecondsField.setHorizontalAlignment(4);
        this.fSecondsField.addFocusListener(fieldFocusListener);
        this.setFocusedField(this.fSecondsField);
        this.syncIncrementDecrementActions();
        this.fIncrementButton = new BasicArrowButton(1);
        WilyUIUtilities.setActionForButton(this.getIncrementFocusedFieldAction(), this.fIncrementButton);
        this.fDecrementButton = new BasicArrowButton(5);
        WilyUIUtilities.setActionForButton(this.getDecrementFocusedFieldAction(), this.fDecrementButton);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.weighty = 1.0;
        gbc.fill = 3;
        JPanel panelFields = new JPanel(gbl);
        gbl.setConstraints(this.fHoursField, gbc);
        panelFields.add(this.fHoursField);
        JLabel labelHours = new JLabel(hours);
        gbl.setConstraints(labelHours, gbc);
        panelFields.add(labelHours);
        gbl.setConstraints(this.fMinutesField, gbc);
        panelFields.add(this.fMinutesField);
        JLabel labelMinutes = new JLabel(minutes);
        gbl.setConstraints(labelMinutes, gbc);
        panelFields.add(labelMinutes);
        gbl.setConstraints(this.fSecondsField, gbc);
        panelFields.add(this.fSecondsField);
        JLabel labelSeconds = new JLabel(seconds);
        gbl.setConstraints(labelSeconds, gbc);
        panelFields.add(labelSeconds);
        this.add("Editor", panelFields);
        this.add("Next", this.fIncrementButton);
        this.add("Previous", this.fDecrementButton);
        this.initializeListeners();
    }

    protected void initializeListeners() {
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                WilyDurationPanel.this.fireFieldChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                WilyDurationPanel.this.fireFieldChanged();
            }

            public void changedUpdate(DocumentEvent e) {
                WilyDurationPanel.this.fireFieldChanged();
            }
        };
        this.fHoursField.getDocument().addDocumentListener(documentListener);
        this.fMinutesField.getDocument().addDocumentListener(documentListener);
        this.fSecondsField.getDocument().addDocumentListener(documentListener);
    }

    public void addWilyFieldListener(WilyFieldListener l) {
        this.listenerList.add(WilyFieldListener.class, l);
    }

    public void removeWilyFieldListener(WilyFieldListener l) {
        this.listenerList.add(WilyFieldListener.class, l);
    }

    protected void fireFieldChanged() {
        EventListener[] listeners = this.listenerList.getListeners(WilyFieldListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            WilyFieldListener listener = (WilyFieldListener)listeners[i];
            listener.fieldChanged();
        }
    }

    public void setDurationInSeconds(int seconds) {
        int leftoverSeconds = this.setHoursFieldInSeconds(seconds);
        leftoverSeconds = this.setMinutesFieldInSeconds(leftoverSeconds);
        this.setSecondsFieldInSeconds(leftoverSeconds);
        this.syncIncrementDecrementActions();
    }

    public int getDurationInMillis() {
        long hoursFieldInSeconds = 0L;
        long minutesFieldInSeconds = 0L;
        long secondsFieldInSeconds = 0L;
        try {
            hoursFieldInSeconds = (long)this.fHoursField.getIntValue() * 3600L;
        }
        catch (NumberFormatException nfe) {
            hoursFieldInSeconds = 0L;
        }
        try {
            minutesFieldInSeconds = (long)this.fMinutesField.getIntValue() * 60L;
        }
        catch (NumberFormatException nfe) {
            minutesFieldInSeconds = 0L;
        }
        try {
            secondsFieldInSeconds = this.fSecondsField.getIntValue();
        }
        catch (NumberFormatException nfe) {
            secondsFieldInSeconds = 0L;
        }
        long durationInMillis = (hoursFieldInSeconds + minutesFieldInSeconds + secondsFieldInSeconds) * 1000L;
        if (durationInMillis > (long)this.getMaxTimeValueInMilliseconds()) {
            throw new NumberFormatException("The duration (in ms) exceeds the maximum allowable integer value");
        }
        return (int)durationInMillis;
    }

    protected int getDurationInSeconds() {
        return this.getDurationInMillis() / 1000;
    }

    public void setEnabled(boolean enabled) {
        this.fEnabled = enabled;
        this.fHoursField.setEnabled(enabled);
        this.fMinutesField.setEnabled(enabled);
        this.fSecondsField.setEnabled(enabled);
        if (!enabled) {
            this.fIncrementFocusedFieldAction.setEnabled(enabled);
            this.fDecrementFocusedFieldAction.setEnabled(enabled);
        } else {
            this.syncIncrementDecrementActions();
        }
    }

    private IGenericServices getGenericServices() {
        return this.fGenericServices;
    }

    private IExtendedAction getIncrementFocusedFieldAction() {
        return this.fIncrementFocusedFieldAction;
    }

    private IExtendedAction getDecrementFocusedFieldAction() {
        return this.fDecrementFocusedFieldAction;
    }

    private void incrementFocusedField() {
        if (this.fFocusedField != null) {
            this.doIncrementFocusedField(this.getFocusedFieldDurationInSeconds());
            this.syncIncrementDecrementActions();
        }
    }

    protected void doIncrementFocusedField(int incrementBy) {
        this.setDurationInSeconds(this.getDurationInSeconds() + incrementBy);
    }

    private void decrementFocusedField() {
        if (this.fFocusedField != null) {
            this.doDecrementFocusedField(this.getFocusedFieldDurationInSeconds());
            this.syncIncrementDecrementActions();
        }
    }

    protected void doDecrementFocusedField(int decrementBy) {
        this.setDurationInSeconds(this.getDurationInSeconds() - decrementBy);
    }

    private int setHoursFieldInSeconds(int seconds) {
        SwingAssertion.assertSwingSafe(this);
        this.fHoursField.setIntValue(seconds / 3600);
        return seconds % 3600;
    }

    private int setMinutesFieldInSeconds(int seconds) {
        SwingAssertion.assertSwingSafe(this);
        this.fMinutesField.setIntValue(seconds / 60);
        return seconds % 60;
    }

    private void setSecondsFieldInSeconds(int seconds) {
        SwingAssertion.assertSwingSafe(this);
        this.fSecondsField.setIntValue(seconds);
    }

    private void syncIncrementDecrementActions() {
        this.fIncrementFocusedFieldAction.setEnabled(this.fEnabled && this.doComputeIncrementEnableState());
        this.fDecrementFocusedFieldAction.setEnabled(this.fEnabled && this.doComputeDecrementEnableState());
    }

    protected boolean doComputeIncrementEnableState() {
        return true;
    }

    protected boolean doComputeDecrementEnableState() {
        return this.getDurationInSeconds() - this.getFocusedFieldDurationInSeconds() >= 0;
    }

    private void noticeFocusGained(Component component) {
        Assertion.wilyAssert(component instanceof WilyIntegerTextField);
        this.setFocusedField((WilyIntegerTextField)component);
        this.syncIncrementDecrementActions();
    }

    private void noticeFocusLost() {
        this.syncIncrementDecrementActions();
    }

    private void setFocusedField(WilyIntegerTextField focusedField) {
        this.fFocusedField = focusedField;
    }

    private int getFocusedFieldDurationInSeconds() {
        if (this.fFocusedField == this.fSecondsField) {
            return 1;
        }
        if (this.fFocusedField == this.fMinutesField) {
            return 60;
        }
        if (this.fFocusedField == this.fHoursField) {
            return 3600;
        }
        return 0;
    }

    public void IValidatable_validate() throws ValidationException {
        this.IValidatable_validate(0);
    }

    private void checkDurationInRange() {
        if (this.getDurationInMillis() < 0) {
            throw new NumberFormatException("Duration is less than or equal to 0");
        }
    }

    private int getMaxTimeValueInMilliseconds() {
        return Integer.MAX_VALUE;
    }

    private int getMaxTimeValueInSeconds() {
        return this.getMaxTimeValueInMilliseconds() / 1000;
    }

    public void IValidatable_validate(int validationConstraints) throws ValidationException {
        validationConstraints = ValidationUtilities.addValidationRequiresNonNegativeNumbersToConstraints(validationConstraints);
        try {
            this.fHoursField.IValidatable_validate(validationConstraints);
            this.fMinutesField.IValidatable_validate(validationConstraints);
            this.fSecondsField.IValidatable_validate(validationConstraints);
        }
        catch (ValidationInvalidContentFormatException ve) {
            FormattedLocalizableMessage message = new FormattedLocalizableMessage("WilyDurationPanelInvalidContentFormatErrorMessage", "Positive_Integer_Type_Name", true);
            throw new IdentifiableObjectValidationException(message);
        }
        try {
            this.checkDurationInRange();
        }
        catch (NumberFormatException nfe) {
            throw new ValidationInvalidBoundedLongException(0L, this.getMaxTimeValueInSeconds());
        }
    }

    public void IStateSaver_saveState(Map stateContainer, String keyPrefix) {
        this.fHoursField.IStateSaver_saveState(stateContainer, keyPrefix + kDurationPanelHoursContentsStateKey);
        this.fMinutesField.IStateSaver_saveState(stateContainer, keyPrefix + kDurationPanelMinutesContentsStateKey);
        this.fSecondsField.IStateSaver_saveState(stateContainer, keyPrefix + kDurationPanelSecondsContentsStateKey);
    }

    public void IStateSaver_restoreState(Map stateContainer, String keyPrefix) {
        this.fHoursField.IStateSaver_restoreState(stateContainer, keyPrefix + kDurationPanelHoursContentsStateKey);
        this.fMinutesField.IStateSaver_restoreState(stateContainer, keyPrefix + kDurationPanelMinutesContentsStateKey);
        this.fSecondsField.IStateSaver_restoreState(stateContainer, keyPrefix + kDurationPanelSecondsContentsStateKey);
        this.syncIncrementDecrementActions();
    }

    private static class SpinnerLayout
    implements LayoutManager {
        private Component nextButton = null;
        private Component previousButton = null;
        private Component editor = null;
        public static final String COMP_NEXT_BUTTON = "Next";
        public static final String COMP_PREVIOUS_BUTTON = "Previous";
        public static final String COMP_EDITOR = "Editor";

        private SpinnerLayout() {
        }

        public void addLayoutComponent(String name, Component c) {
            if (COMP_NEXT_BUTTON.equals(name)) {
                this.nextButton = c;
            } else if (COMP_PREVIOUS_BUTTON.equals(name)) {
                this.previousButton = c;
            } else if (COMP_EDITOR.equals(name)) {
                this.editor = c;
            }
        }

        public void removeLayoutComponent(Component c) {
            if (c == this.nextButton) {
                c = null;
            } else if (c == this.previousButton) {
                this.previousButton = null;
            } else if (c == this.editor) {
                this.editor = null;
            }
        }

        private Dimension preferredSize(Component c) {
            return c == null ? zeroSize : c.getPreferredSize();
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension nextD = this.preferredSize(this.nextButton);
            Dimension previousD = this.preferredSize(this.previousButton);
            Dimension editorD = this.preferredSize(this.editor);
            editorD.height = (editorD.height + 1) / 2 * 2;
            Dimension size = new Dimension(editorD.width, editorD.height);
            size.width += Math.max(nextD.width, previousD.width);
            Insets insets = parent.getInsets();
            size.width += insets.left + insets.right;
            size.height += insets.top + insets.bottom;
            return size;
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        private void setBounds(Component c, int x, int y, int width, int height) {
            if (c != null) {
                c.setBounds(x, y, width, height);
            }
        }

        public void layoutContainer(Container parent) {
            int buttonsX;
            int editorX;
            Insets insets = parent.getInsets();
            int availWidth = parent.getWidth() - (insets.left + insets.right);
            int availHeight = parent.getHeight() - (insets.top + insets.bottom);
            Dimension nextD = this.preferredSize(this.nextButton);
            Dimension previousD = this.preferredSize(this.previousButton);
            int nextHeight = availHeight / 2;
            int previousHeight = availHeight - nextHeight;
            int buttonsWidth = Math.max(nextD.width, previousD.width);
            int editorWidth = availWidth - buttonsWidth;
            if (parent.getComponentOrientation().isLeftToRight()) {
                editorX = insets.left;
                buttonsX = editorX + editorWidth;
            } else {
                buttonsX = insets.left;
                editorX = buttonsX + buttonsWidth;
            }
            int previousY = insets.top + nextHeight;
            this.setBounds(this.editor, editorX, insets.top, editorWidth, availHeight);
            this.setBounds(this.nextButton, buttonsX, insets.top, buttonsWidth, nextHeight);
            this.setBounds(this.previousButton, buttonsX, previousY, buttonsWidth, previousHeight);
        }
    }

    private class DecrementFocusedFieldAction
    extends ATwoWayExtendedAction {
        private static final long serialVersionUID = 8027902615053114735L;

        private DecrementFocusedFieldAction() {
        }

        protected void doTriggerAction(ActionEvent actionEvent) {
            WilyDurationPanel.this.decrementFocusedField();
        }

        protected void doUndoAction() {
            WilyDurationPanel.this.incrementFocusedField();
        }

        protected void doRedoAction() {
            this.doTriggerAction(null);
        }
    }

    private class IncrementFocusedFieldAction
    extends ATwoWayExtendedAction {
        private static final long serialVersionUID = 9150735378256283625L;

        private IncrementFocusedFieldAction() {
        }

        protected void doTriggerAction(ActionEvent actionEvent) {
            WilyDurationPanel.this.incrementFocusedField();
        }

        protected void doUndoAction() {
            WilyDurationPanel.this.decrementFocusedField();
        }

        protected void doRedoAction() {
            this.doTriggerAction(null);
        }
    }

    private class FieldFocusListener
    implements FocusListener {
        private FieldFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            WilyDurationPanel.this.noticeFocusGained(focusEvent.getComponent());
        }

        public void focusLost(FocusEvent focusEvent) {
            WilyDurationPanel.this.noticeFocusLost();
        }
    }
}

