/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui;

import com.wily.properties.KUIErrorMessagesKeys;
import com.wily.ui.IGenericServices;
import com.wily.ui.action.ExtendedActionMonitor;
import com.wily.ui.action.TextEditActionBroker;
import com.wily.util.IStateSaver;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.validate.IValidatable;
import com.wily.util.validate.KValidationConstants;
import com.wily.util.validate.ValidationException;
import com.wily.util.validate.ValidationNoContentsException;
import com.wily.util.validate.ValidationUtilities;
import com.wily.wilyassert.Assertion;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Map;
import javax.swing.BoundedRangeModel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class WilyTextField
extends JTextField
implements IStateSaver,
IValidatable,
KValidationConstants,
KUIErrorMessagesKeys {
    private static final long serialVersionUID = 872268831516903610L;
    private IGenericServices fGenericServices;
    private boolean fAutoSelectWhenFocusGained;
    private Color fEditableColor = new Color(UIManager.getColor("TextField.background").getRGB());
    private Color fReadonlyColor = new Color(UIManager.getColor("TextField.inactiveBackground").getRGB());
    private static final boolean kDefaultAutoSelectWhenFocusGained = false;
    private static final String kTextFieldContentsStateKey = "WilyTextField_Contents";

    protected WilyTextField() {
        Assertion.unimplemented("Must at least specify GenericServices");
    }

    public WilyTextField(IGenericServices genericServices) {
        this.initialize(genericServices, null, null, false);
    }

    public WilyTextField(IGenericServices genericServices, Document doc, String text, int columns) {
        super(columns);
        this.initialize(genericServices, doc, text, false);
    }

    public WilyTextField(IGenericServices genericServices, int columns) {
        super(columns);
        this.initialize(genericServices, null, null, false);
    }

    public WilyTextField(IGenericServices genericServices, String text) {
        this.initialize(genericServices, null, text, false);
    }

    public WilyTextField(IGenericServices genericServices, String text, int columns) {
        super(columns);
        this.initialize(genericServices, null, text, false);
    }

    protected IGenericServices getGenericServices() {
        return this.fGenericServices;
    }

    protected IModuleFeedbackChannel getModuleFeedback() {
        return this.getGenericServices().IGenericServices_getModuleFeedback();
    }

    protected IStringLocalizer getStringLocalizer() {
        return this.getGenericServices().IGenericServices_getStringLocalizer();
    }

    protected ExtendedActionMonitor getActionMonitor() {
        return this.getGenericServices().IGenericServices_getExtendedActionMonitor();
    }

    protected TextEditActionBroker getTextEditActionBroker() {
        return this.getGenericServices().IGenericServices_getTextEditActionBroker();
    }

    protected String getContentsStateKey() {
        return kTextFieldContentsStateKey;
    }

    public void scrollRectToVisible(Rectangle r) {
        Insets i = this.getInsets();
        BoundedRangeModel vis = this.getHorizontalVisibility();
        int x = r.x + vis.getValue() - i.left;
        if (x < vis.getValue()) {
            vis.setValue(x);
        } else if (x > vis.getValue() + vis.getExtent()) {
            vis.setValue(x - vis.getExtent());
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setBackground(enabled ? this.fEditableColor : this.fReadonlyColor);
    }

    private void initialize(IGenericServices genericServices, Document initialDoc, String initialText, boolean autoSelectWhenFocusGained) {
        this.fGenericServices = genericServices;
        this.fAutoSelectWhenFocusGained = autoSelectWhenFocusGained;
        this.addFocusListener(new WilyTextFieldFocusListener());
        this.getTextEditActionBroker().monitorTextComponent(this);
        if (initialText != null) {
            this.setText(initialText);
        }
        if (initialDoc != null) {
            this.setDocument(initialDoc);
        }
    }

    public void setAutoSelectWhenFocusGained(boolean autoSelectWhenFocusGained) {
        this.fAutoSelectWhenFocusGained = autoSelectWhenFocusGained;
    }

    public void setText(String t) {
        this.getTextEditActionBroker().unmonitorTextComponent(this);
        super.setText(t);
        this.getTextEditActionBroker().monitorTextComponent(this);
        this.setCaretPosition(0);
        this.scrollToBeginningOfText();
    }

    private void scrollToBeginningOfText() {
        try {
            Rectangle rectangle = this.modelToView(0);
            if (rectangle != null) {
                this.scrollRectToVisible(rectangle);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public boolean autoSelectWhenFocusGained() {
        return this.fAutoSelectWhenFocusGained;
    }

    public Object getObjectValue() {
        return this.getText();
    }

    public Number getNumberValue() {
        throw new ClassCastException();
    }

    public void setObjectValue(Object value) {
        this.setText(value.toString());
    }

    public void IStateSaver_saveState(Map stateContainer, String keyPrefix) {
        stateContainer.put(keyPrefix + this.getContentsStateKey(), this.getText());
    }

    public void IStateSaver_restoreState(Map stateContainer, String keyPrefix) {
        this.setText((String)stateContainer.get(keyPrefix + this.getContentsStateKey()));
    }

    public void IValidatable_validate() throws ValidationException {
        this.IValidatable_validate(0);
    }

    public void IValidatable_validate(int validationConstraints) throws ValidationException {
        if (ValidationUtilities.validationRequiresContents(validationConstraints) && StringUtils.isEmpty(this.getText())) {
            throw new ValidationNoContentsException();
        }
    }

    private void noticeFocusGained() {
        if (this.autoSelectWhenFocusGained()) {
            this.selectAll();
        }
    }

    private void noticeFocusLost() {
    }

    public void selectAll() {
        super.selectAll();
        this.scrollToBeginningOfText();
    }

    public void tearDown() {
        this.getTextEditActionBroker().monitorTextComponent(this);
    }

    private class WilyTextFieldFocusListener
    implements FocusListener {
        private WilyTextFieldFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            WilyTextField.this.noticeFocusGained();
        }

        public void focusLost(FocusEvent focusEvent) {
            WilyTextField.this.noticeFocusLost();
        }
    }
}

