/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui;

import com.wily.ui.ContainingBox;
import com.wily.ui.RealPoint;
import com.wily.ui.XYPlot;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class XYChart {
    private static final Color kDefaultPlotColor = Color.green.darker();
    private static final Color kDefaultGridColor = new Color(230, 230, 255);
    private static final Color kDefaultBackgroundColor = new Color(248, 248, 248);
    private static final Color kDefaultThresholdColor = Color.blue;
    private static final int kDefaultYGridDivisions = 8;
    private XYPlot[] fPlots;
    private Color[] fPlotColors;
    private float[] fThresholds;
    private Color[] fThresholdColors;
    private ContainingBox fClipWindow;
    private Color fBackgroundColor;
    private boolean fGridOn;
    private Color fGridColor;
    private int fYGridDivisions;

    public XYChart(int plotCount) {
        this.initFields(plotCount);
        for (int i = 0; i < this.fPlots.length; ++i) {
            this.fPlots[i] = new XYPlot();
            this.fPlotColors[i] = kDefaultPlotColor;
        }
    }

    public XYChart(int plotCount, int numDataPoints) {
        this.initFields(plotCount);
        for (int i = 0; i < this.fPlots.length; ++i) {
            this.fPlots[i] = new XYPlot(numDataPoints);
            this.fPlotColors[i] = kDefaultPlotColor;
        }
    }

    private void initFields(int plotCount) {
        this.fPlots = new XYPlot[plotCount];
        this.fPlotColors = new Color[plotCount];
        this.fThresholds = new float[0];
        this.fThresholdColors = new Color[0];
        this.fGridOn = false;
        this.fGridColor = kDefaultGridColor;
        this.fYGridDivisions = 8;
        this.fBackgroundColor = kDefaultBackgroundColor;
    }

    public void addPoint(int plotNum, RealPoint p) {
        this.fPlots[plotNum].addPoint(p);
    }

    public void addPoint(int plotNum, float x, float y) {
        this.addPoint(plotNum, new RealPoint(x, y));
    }

    public void setPlotColor(int plotNum, Color color) {
        this.fPlotColors[plotNum] = color;
    }

    public void setBackgroundColor(Color color) {
        this.fBackgroundColor = color;
    }

    public void setGridColor(Color color) {
        this.fGridColor = color;
    }

    public void setClipWindow(float xMin, float yMin, float xMax, float yMax) {
        this.setClipWindow(new ContainingBox(xMin, yMin, xMax, yMax));
    }

    public void setClipWindow(ContainingBox box) {
        this.fClipWindow = box;
        for (int i = 0; i < this.fPlots.length; ++i) {
            this.fPlots[i].setClipWindow(this.fClipWindow);
        }
    }

    public ContainingBox getClipWindow() {
        return this.fClipWindow;
    }

    public void setThreshold(float value) {
        this.setThreshold(value, kDefaultThresholdColor);
    }

    public void setThreshold(float value, Color color) {
        float[] temp = new float[this.fThresholds.length + 1];
        System.arraycopy(this.fThresholds, 0, temp, 1, this.fThresholds.length);
        temp[0] = value;
        this.fThresholds = temp;
        Color[] tempc = new Color[this.fThresholdColors.length + 1];
        System.arraycopy(this.fThresholdColors, 0, tempc, 1, this.fThresholdColors.length);
        tempc[0] = color;
        this.fThresholdColors = tempc;
    }

    public void clearThresholds() {
        this.fThresholds = new float[0];
        this.fThresholdColors = new Color[0];
    }

    public void enableGrid() {
        this.fGridOn = true;
    }

    public void disableGrid() {
        this.fGridOn = false;
    }

    public void setYGridDivisions(int gridDivisions) {
        this.fYGridDivisions = gridDivisions;
    }

    public void clipPoints() {
        for (int i = 0; i < this.fPlots.length; ++i) {
            this.fPlots[i].clipPoints();
        }
    }

    public void sortPoints() {
        for (int i = 0; i < this.fPlots.length; ++i) {
            this.fPlots[i].sortPoints();
        }
    }

    public void drawPoints(Graphics g, Rectangle destinationWindow) {
        Color original = g.getColor();
        this.drawBackground(g, destinationWindow);
        for (int i = 0; i < this.fPlots.length; ++i) {
            g.setColor(this.fPlotColors[i]);
            this.fPlots[i].drawPoints(g, destinationWindow);
        }
        g.setColor(original);
    }

    public void drawLines(Graphics g, Rectangle destinationWindow) {
        Color original = g.getColor();
        this.drawBackground(g, destinationWindow);
        for (int i = 0; i < this.fPlots.length; ++i) {
            g.setColor(this.fPlotColors[i]);
            this.fPlots[i].drawLines(g, destinationWindow);
        }
        g.setColor(original);
    }

    private void drawBackground(Graphics g, Rectangle rect) {
        g.setColor(this.fBackgroundColor);
        g.fillRect(rect.x, rect.y, rect.width, rect.height);
        if (this.fGridOn) {
            int i;
            g.setColor(this.fGridColor);
            int xDivs = (int)Math.round((double)this.fYGridDivisions * (double)rect.width / (double)rect.height);
            int yDivs = this.fYGridDivisions;
            double xRatio = (double)rect.width / (double)xDivs;
            double yRatio = (double)rect.height / (double)yDivs;
            int xMax = rect.x + rect.width;
            int yMax = rect.y + rect.height;
            for (i = 1; i < xDivs; ++i) {
                g.drawLine((int)(xRatio * (double)i), rect.y, (int)(xRatio * (double)i), yMax);
            }
            for (i = 1; i < yDivs; ++i) {
                g.drawLine(rect.x, (int)(yRatio * (double)i), xMax, (int)(yRatio * (double)i));
            }
        }
        double yRatio = (double)(-rect.height) / (double)this.fClipWindow.getySize();
        double yOffset = (double)(rect.y + rect.height) - yRatio * (double)this.fClipWindow.getyMin();
        for (int i = 0; i < this.fThresholds.length; ++i) {
            int yValue = (int)(yRatio * (double)this.fThresholds[i] + yOffset);
            g.setColor(this.fThresholdColors[i]);
            g.drawLine(rect.x, yValue, rect.x + rect.width, yValue);
        }
    }
}

