/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.action;

import com.wily.ui.action.AExtendedAction;
import com.wily.ui.action.ExtendedActionException;
import com.wily.ui.action.IExtendedAction;
import com.wily.ui.swing.KSwingPropertyNames;
import com.wily.util.text.ILocalizableMessage;
import com.wily.wilyassert.Assertion;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;

public class MultiplexedExtendedAction
extends AExtendedAction
implements KSwingPropertyNames {
    private static final long serialVersionUID = 2221791780708581227L;
    private Vector fActions;
    private Vector fTriggeredActions;
    private boolean fForceUnenabled;
    private PropertyChangeListener fPropertyPropogator;
    private Object fConsumable;
    private boolean fShareEnabledState;
    private static final boolean kDefaultShareEnabledState = true;

    public MultiplexedExtendedAction() {
        this(true);
    }

    public MultiplexedExtendedAction(String name) {
        this(name, true);
    }

    public MultiplexedExtendedAction(String name, Icon icon) {
        this(name, icon, true);
    }

    public MultiplexedExtendedAction(boolean shareDisabledState) {
        super(0);
        this.init(shareDisabledState);
    }

    public MultiplexedExtendedAction(String name, boolean shareDisabledState) {
        super(name, 0);
        this.init(shareDisabledState);
    }

    public MultiplexedExtendedAction(String name, Icon icon, boolean shareDisabledState) {
        super(name, icon, 0);
        this.init(shareDisabledState);
    }

    public MultiplexedExtendedAction(Collection extendedActions) {
        this();
        Iterator extendedActionsIterator = extendedActions.iterator();
        while (extendedActionsIterator.hasNext()) {
            this.addExtendedAction((IExtendedAction)extendedActionsIterator.next());
        }
    }

    private void init(boolean shareDisabledState) {
        this.setIsProducer(false);
        this.fShareEnabledState = shareDisabledState;
        this.fForceUnenabled = false;
        this.fActions = new Vector();
        this.fTriggeredActions = new Vector();
        this.fPropertyPropogator = new PropertyPropogator();
        this.syncStates();
    }

    public void addExtendedAction(IExtendedAction action) {
        Assertion.wilyAssert(action != null);
        this.addExtendedAction(action, -1);
    }

    public void addExtendedAction(IExtendedAction action, int index) {
        Assertion.wilyAssert(action != null);
        if (index == -1) {
            index = this.fActions.size();
        }
        this.fActions.insertElementAt(action, index);
        int stopIndex = index == this.fActions.size() - 1 ? index : index + 1;
        action.addPropertyChangeListener(this.fPropertyPropogator);
        this.syncStates();
    }

    public void removeExtendedAction(int index) {
        IExtendedAction action = (IExtendedAction)this.fActions.remove(index);
        int stopIndex = index == this.fActions.size() ? index - 1 : index;
        action.removePropertyChangeListener(this.fPropertyPropogator);
        this.syncStates();
    }

    public int getExtendedActionCount() {
        return this.fActions.size();
    }

    public void IExtendedAction_setConsumable(Object consumable) throws ExtendedActionException {
        this.fConsumable = consumable;
    }

    public Object IExtendedAction_getProduct() throws ExtendedActionException {
        return null;
    }

    public void doTearDown() {
        this.doTheTearDown(this.fActions);
    }

    private void doTheTearDown(Vector actions) {
        Enumeration actionsEnum = actions.elements();
        while (actionsEnum.hasMoreElements()) {
            IExtendedAction anAction = (IExtendedAction)actionsEnum.nextElement();
            anAction.IExtendedAction_tearDown();
            anAction.removePropertyChangeListener(this.fPropertyPropogator);
        }
    }

    public void doTriggerAction(ActionEvent actionEvent) throws ExtendedActionException {
        try {
            this.fTriggeredActions.clear();
            this.triggerChainedActions(actionEvent);
        }
        catch (ExtendedActionException ae) {
            this.throwExceptionWithCompoundMessage(ae, 10);
        }
    }

    public void doUndoAction() throws ExtendedActionException {
        try {
            this.undoChainedActions();
        }
        catch (ExtendedActionException ae) {
            this.throwExceptionWithCompoundMessage(ae, 11);
        }
    }

    public void doRedoAction() throws ExtendedActionException {
        try {
            this.redoChainedActions();
        }
        catch (ExtendedActionException ae) {
            this.throwExceptionWithCompoundMessage(ae, 12);
        }
    }

    protected void triggerChainedActions(ActionEvent actionEvent) throws ExtendedActionException {
        for (int i = 0; i < this.fActions.size(); ++i) {
            IExtendedAction action = (IExtendedAction)this.fActions.elementAt(i);
            if (!this.fShareEnabledState && !action.isEnabled()) continue;
            if (action.IExtendedAction_isConsumer()) {
                action.IExtendedAction_setConsumable(this.fConsumable);
            }
            action.IExtendedAction_triggerAction(actionEvent);
            if (action.IExtendedAction_wasCancelled()) {
                this.setCancelled(true);
                if (this.IExtendedAction_getActionType() != 2) {
                    this.undoChainedActions();
                }
                return;
            }
            this.fTriggeredActions.add(action);
        }
    }

    protected void undoChainedActions() throws ExtendedActionException {
        for (int i = this.fTriggeredActions.size() - 1; i >= 0; --i) {
            IExtendedAction action = (IExtendedAction)this.fTriggeredActions.elementAt(i);
            int actionType = action.IExtendedAction_getActionType();
            Assertion.wilyAssert(actionType != 2, "undoChainedAction() shouldn't be called when the multiplexed action is destructive");
            if (actionType != 1) continue;
            action.IExtendedAction_undoAction();
        }
    }

    protected void redoChainedActions() throws ExtendedActionException {
        for (int i = 0; i < this.fTriggeredActions.size(); ++i) {
            int actionType;
            IExtendedAction action = (IExtendedAction)this.fTriggeredActions.elementAt(i);
            if (action.IExtendedAction_isConsumer()) {
                action.IExtendedAction_setConsumable(this.fConsumable);
            }
            Assertion.wilyAssert((actionType = action.IExtendedAction_getActionType()) != 2, "redoChainedActions shouldn't be called when the multiplexed action is destructive");
            if (actionType != 1) continue;
            action.IExtendedAction_redoAction();
        }
    }

    public void setEnabled(boolean enabled) {
        this.fForceUnenabled = !enabled;
        this.syncEnabledState();
    }

    private void syncStates() {
        this.syncEnabledState();
        this.syncActionTypeState();
        this.syncIsConsumerState();
    }

    private void syncEnabledState() {
        if (this.fShareEnabledState) {
            this.syncSharedEnabledState();
        } else {
            this.syncUnsharedEnabledState();
        }
    }

    private void syncSharedEnabledState() {
        boolean enabled = true;
        if (this.fForceUnenabled) {
            enabled = false;
        } else {
            for (int i = 0; i < this.fActions.size() && enabled; ++i) {
                enabled = ((Action)this.fActions.elementAt(i)).isEnabled();
            }
        }
        super.setEnabled(enabled);
    }

    private void syncUnsharedEnabledState() {
        boolean enabled = false;
        if (!this.fForceUnenabled) {
            for (int i = 0; i < this.fActions.size() && !enabled; ++i) {
                enabled = ((Action)this.fActions.elementAt(i)).isEnabled();
            }
        }
        super.setEnabled(enabled);
    }

    private void syncActionTypeState() {
        int multiplexedActionType = 0;
        for (int i = 0; i < this.fActions.size() && multiplexedActionType != 2; ++i) {
            IExtendedAction action = (IExtendedAction)this.fActions.elementAt(i);
            int componentActionType = action.IExtendedAction_getActionType();
            if (componentActionType == 2) {
                multiplexedActionType = 2;
                continue;
            }
            if (componentActionType != 1) continue;
            multiplexedActionType = 1;
        }
        this.setActionType(multiplexedActionType);
    }

    private void syncIsConsumerState() {
        boolean isConsumer = false;
        Enumeration myActions = this.fActions.elements();
        while (myActions.hasMoreElements() && !isConsumer) {
            IExtendedAction anAction = (IExtendedAction)myActions.nextElement();
            isConsumer = anAction.IExtendedAction_isConsumer();
        }
        this.setIsConsumer(isConsumer);
    }

    private void throwExceptionWithCompoundMessage(ExtendedActionException ae, int whichVerb) throws ExtendedActionException {
        ILocalizableMessage compoundUserMessage = ae.ILocalizableException_getLocalizableMessage();
        String compoundExceptionMessage = "MutableExtendedAction.trigger failed: " + ae.getMessage();
        throw new ExtendedActionException(this, ae, compoundExceptionMessage, compoundUserMessage, whichVerb);
    }

    public Object clone() throws CloneNotSupportedException {
        MultiplexedExtendedAction newMultiplexedExtendedAction = (MultiplexedExtendedAction)super.clone();
        newMultiplexedExtendedAction.fShareEnabledState = this.fShareEnabledState;
        newMultiplexedExtendedAction.fForceUnenabled = this.fForceUnenabled;
        newMultiplexedExtendedAction.fTriggeredActions = new Vector();
        newMultiplexedExtendedAction.fActions = new Vector();
        Enumeration myActions = this.fActions.elements();
        while (myActions.hasMoreElements()) {
            IExtendedAction anAction = (IExtendedAction)myActions.nextElement();
            IExtendedAction clonedAction = (IExtendedAction)anAction.clone();
            newMultiplexedExtendedAction.addExtendedAction(clonedAction);
            if (!this.fTriggeredActions.contains(anAction)) continue;
            newMultiplexedExtendedAction.fTriggeredActions.add(clonedAction);
        }
        return newMultiplexedExtendedAction;
    }

    public String toString() {
        return "(MutableExtendedAction ACTIONS: " + this.actionsToString() + "TRIGGERED ACTIONS: " + this.triggeredActionsToString();
    }

    private String actionsToString() {
        return this.vectorToString(this.fActions);
    }

    private String triggeredActionsToString() {
        return this.vectorToString(this.fTriggeredActions);
    }

    private String vectorToString(Vector v) {
        Enumeration actions = v.elements();
        String result = "";
        int j = 0;
        while (actions.hasMoreElements()) {
            IExtendedAction action = (IExtendedAction)actions.nextElement();
            result = result + "([" + j + "] " + action + ") ";
            ++j;
        }
        return result;
    }

    private class PropertyPropogator
    implements PropertyChangeListener {
        private PropertyPropogator() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            MultiplexedExtendedAction.this.syncStates();
        }
    }
}

