/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.datatransfer;

import com.wily.ui.datatransfer.DataTransferUtils;
import com.wily.ui.datatransfer.KDataTransferConstants;
import com.wily.ui.datatransfer.TransferableSetDataFlavor;
import com.wily.ui.dnd.LinkedDragActionBroker;
import com.wily.util.ArrayUtilities;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;

public class TransferableSet
implements Transferable,
KDataTransferConstants {
    private final List fTransferables;
    private final List fTransferableIndices;
    private final TransferableSetDataFlavor fTransferableSetDataFlavor;
    private JComponent fSourceComponent;
    private LinkedDragActionBroker fLinkedDragActionBroker = new LinkedDragActionBroker();

    public TransferableSet(Transferable transferable) {
        this(null, new Transferable[]{transferable});
    }

    public TransferableSet(JComponent sourceComponent, Transferable transferable) {
        this(sourceComponent, new Transferable[]{transferable});
    }

    public TransferableSet(JComponent sourceComponent, Transferable transferable, int index) {
        this(sourceComponent, new Transferable[]{transferable}, new int[]{index});
    }

    public TransferableSet(Transferable[] transferables) {
        this(null, transferables, null);
    }

    public TransferableSet(JComponent sourceComponent, Transferable[] transferables) {
        this(sourceComponent, transferables, null);
    }

    public TransferableSet(JComponent sourceComponent, Transferable[] transferables, int[] indices) {
        this.fTransferables = Arrays.asList(transferables);
        this.fTransferableIndices = indices == null ? null : Arrays.asList(ArrayUtilities.intArrayToIntegerArray(indices));
        this.fSourceComponent = sourceComponent;
        this.fTransferableSetDataFlavor = new TransferableSetDataFlavor(transferables);
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        Object data = null;
        if (DataTransferUtils.dataFlavorsEqual(flavor, kTransferableSetDataFlavor)) {
            data = this.fTransferables;
        } else if (DataTransferUtils.dataFlavorsEqual(flavor, kTransferableSetSourceIndicesDataFlavor)) {
            data = this.fTransferableIndices;
        } else if (DataTransferUtils.dataFlavorsEqual(flavor, kSourceComponentDataFlavor)) {
            data = this.fSourceComponent;
        } else if (DataTransferUtils.dataFlavorsEqual(flavor, kLinkedDragActionBrokerDataFlavor)) {
            data = this.fLinkedDragActionBroker;
        } else {
            throw new UnsupportedFlavorException(flavor);
        }
        return data;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return DataTransferUtils.dataFlavorsEqual(flavor, kTransferableSetDataFlavor) || DataTransferUtils.dataFlavorsEqual(flavor, kTransferableSetSourceIndicesDataFlavor) || DataTransferUtils.dataFlavorsEqual(flavor, kSourceComponentDataFlavor) || DataTransferUtils.dataFlavorsEqual(flavor, kLinkedDragActionBrokerDataFlavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] flavors = new DataFlavor[]{this.fTransferableSetDataFlavor, kTransferableSetSourceIndicesDataFlavor, kSourceComponentDataFlavor, kLinkedDragActionBrokerDataFlavor};
        return flavors;
    }

    public int getcontainedTransferableCount() {
        return this.fTransferables.size();
    }
}

