/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.dnd;

import com.wily.ui.IGenericServices;
import com.wily.ui.action.ErrorReportingExtendedActionWrapper;
import com.wily.ui.action.ExtendedActionMonitor;
import com.wily.ui.action.IExtendedAction;
import com.wily.ui.datatransfer.DataTransferUtils;
import com.wily.ui.datatransfer.KDataTransferConstants;
import com.wily.ui.datatransfer.TransferableSetDataFlavor;
import com.wily.ui.dnd.ExtendedDropTarget;
import com.wily.ui.dnd.IExtendedDropTargetConspirator;
import com.wily.ui.dnd.LinkedDragActionBroker;
import com.wily.ui.dnd.TransferablesDroppedEvent;
import com.wily.ui.dnd.TransferablesDroppedLocallyEvent;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;

class DropTargetDispatchListener
implements DropTargetListener,
KDataTransferConstants {
    IGenericServices fGenericServices;
    IExtendedDropTargetConspirator fTargetExtendedDropTargetConspirator;
    ExtendedDropTarget fTargetExtendedDropTarget;

    public DropTargetDispatchListener(IGenericServices genericServices) {
        this.fGenericServices = genericServices;
    }

    private IGenericServices getGenericServices() {
        return this.fGenericServices;
    }

    public IStringLocalizer getStringLocalizer() {
        return this.getGenericServices().IGenericServices_getStringLocalizer();
    }

    public IModuleFeedbackChannel getModuleFeedback() {
        return this.getGenericServices().IGenericServices_getModuleFeedback();
    }

    private void initializeConspirator(DropTargetDragEvent dropTargetDragEvent) {
        IExtendedDropTargetConspirator targetExtendedDropTargetConspirator = null;
        ExtendedDropTarget targetExtendedDropTarget = null;
        DataFlavor[] dataFlavors = dropTargetDragEvent.getCurrentDataFlavors();
        Component startComponent = dropTargetDragEvent.getDropTargetContext().getComponent();
        Point startComponentLocation = dropTargetDragEvent.getLocation();
        TransferableSetDataFlavor transferableSetDataFlavor = null;
        for (int i = 0; i < dataFlavors.length && transferableSetDataFlavor == null; ++i) {
            if (!DataTransferUtils.dataFlavorsEqual(dataFlavors[i], kTransferableSetDataFlavor)) continue;
            transferableSetDataFlavor = (TransferableSetDataFlavor)dataFlavors[i];
        }
        if (transferableSetDataFlavor != null) {
            Component currentComponent;
            DropTarget currentDropTarget = currentComponent.getDropTarget();
            for (currentComponent = startComponent; currentComponent != null && targetExtendedDropTargetConspirator == null; currentComponent = currentComponent.getParent()) {
                ExtendedDropTarget aExtendedDropTarget;
                IExtendedDropTargetConspirator aExtendedDropTargetConspirator;
                currentDropTarget = currentComponent.getDropTarget();
                if (currentDropTarget == null || !(currentDropTarget instanceof ExtendedDropTarget) || (aExtendedDropTargetConspirator = (aExtendedDropTarget = (ExtendedDropTarget)currentDropTarget).getExtendedDropTargetConspirator()) == null || !aExtendedDropTargetConspirator.IExtendedDropTargetConspirator_isInterested(startComponent, startComponentLocation, transferableSetDataFlavor)) continue;
                targetExtendedDropTarget = aExtendedDropTarget;
                targetExtendedDropTargetConspirator = aExtendedDropTargetConspirator;
            }
        }
        if (targetExtendedDropTargetConspirator != this.fTargetExtendedDropTargetConspirator && this.fTargetExtendedDropTargetConspirator != null) {
            this.fTargetExtendedDropTargetConspirator.IExtendedDropTargetConspirator_updateHilite(null, null, false);
        }
        if (targetExtendedDropTargetConspirator != null && targetExtendedDropTarget.enabled()) {
            this.fTargetExtendedDropTargetConspirator = targetExtendedDropTargetConspirator;
            this.fTargetExtendedDropTarget = targetExtendedDropTarget;
        } else {
            this.fTargetExtendedDropTargetConspirator = null;
            this.fTargetExtendedDropTarget = null;
        }
    }

    private boolean haveTarget() {
        return this.fTargetExtendedDropTarget != null;
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        this.initializeConspirator(dtde);
        if (this.haveTarget()) {
            this.fTargetExtendedDropTargetConspirator.IExtendedDropTargetConspirator_updateHilite(dtde.getDropTargetContext().getComponent(), dtde.getLocation(), true);
            dtde.acceptDrag(3);
        }
    }

    public void dragOver(DropTargetDragEvent dtde) {
        this.initializeConspirator(dtde);
        if (this.haveTarget()) {
            this.fTargetExtendedDropTargetConspirator.IExtendedDropTargetConspirator_updateHilite(dtde.getDropTargetContext().getComponent(), dtde.getLocation(), true);
            dtde.acceptDrag(3);
        }
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dte) {
        if (this.haveTarget()) {
            this.fTargetExtendedDropTargetConspirator.IExtendedDropTargetConspirator_updateHilite(dte.getDropTargetContext().getComponent(), new Point(0, 0), false);
        }
    }

    public void drop(DropTargetDropEvent dtde) {
        if (!this.haveTarget()) {
            dtde.rejectDrop();
            return;
        }
        try {
            this.fTargetExtendedDropTargetConspirator.IExtendedDropTargetConspirator_updateHilite(dtde.getDropTargetContext().getComponent(), new Point(0, 0), false);
            IExtendedDropTargetConspirator targetConspirator = this.fTargetExtendedDropTarget.getExtendedDropTargetConspirator();
            Transferable transferableSet = dtde.getTransferable();
            JComponent sourceComponent = (JComponent)transferableSet.getTransferData(kSourceComponentDataFlavor);
            List transferables = (List)transferableSet.getTransferData(kTransferableSetDataFlavor);
            boolean isLocalDrag = targetConspirator.IExtendedDropTargetConspirator_isLocalDrag(sourceComponent);
            ExtendedActionMonitor dropTargetActionMonitor = targetConspirator.IExtendedDropTargetConspirator_getActionMonitor();
            LinkedDragActionBroker linkedDragActionBroker = (LinkedDragActionBroker)transferableSet.getTransferData(kLinkedDragActionBrokerDataFlavor);
            if (isLocalDrag) {
                List itemSourceIndices = (List)transferableSet.getTransferData(kTransferableSetSourceIndicesDataFlavor);
                IExtendedAction itemsMovedLocallyAction = targetConspirator.IExtendedDropTargetConspirator_getItemDroppedLocallyAction();
                TransferablesDroppedLocallyEvent itemsdroppedLocallyEvent = new TransferablesDroppedLocallyEvent(dtde.getSource(), transferables, itemSourceIndices, dtde.getLocation(), sourceComponent, dtde.getDropTargetContext().getComponent(), dtde.getDropAction() == 1);
                ErrorReportingExtendedActionWrapper errorReportingAction = new ErrorReportingExtendedActionWrapper(this.getGenericServices(), this.fTargetExtendedDropTarget.getComponent(), itemsMovedLocallyAction, false);
                linkedDragActionBroker.setLinkedAction1(errorReportingAction, dropTargetActionMonitor, itemsdroppedLocallyEvent);
                linkedDragActionBroker.setLinkedAction1IsCompleteAction(true);
            } else {
                IExtendedAction itemsDroppedAction = targetConspirator.IExtendedDropTargetConspirator_getItemsDroppedAction();
                TransferablesDroppedEvent itemsDroppedEvent = new TransferablesDroppedEvent(dtde.getSource(), transferables, dtde.getLocation(), sourceComponent, dtde.getDropTargetContext().getComponent());
                ErrorReportingExtendedActionWrapper errorReportingAction = new ErrorReportingExtendedActionWrapper(this.getGenericServices(), this.fTargetExtendedDropTarget.getComponent(), itemsDroppedAction, false);
                linkedDragActionBroker.setLinkedAction1(errorReportingAction, dropTargetActionMonitor, itemsDroppedEvent);
                linkedDragActionBroker.setLinkedAction1IsCompleteAction(false);
            }
            dtde.acceptDrop(dtde.getDropAction());
            dtde.dropComplete(true);
        }
        catch (UnsupportedFlavorException udfe) {
            dtde.dropComplete(false);
            this.getModuleFeedback().error("Drop failed due to Unsopported DataFlavor");
        }
        catch (IOException ioe) {
            dtde.dropComplete(false);
            this.getModuleFeedback().error("Drop failed due to IOException");
        }
    }
}

