/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.image;

import com.wily.ui.image.IImageFilterFactory;
import com.wily.ui.image.NoSuchImageFilterException;
import java.awt.image.ImageFilter;
import java.util.Hashtable;

public class DefaultImageFilterFactory
implements IImageFilterFactory {
    private Hashtable fImageFilters;

    public DefaultImageFilterFactory() {
        this.initialize();
    }

    private void initialize() {
        this.fImageFilters = new Hashtable();
    }

    public ImageFilter IImageFilterFactory_getFilter(String filterID) throws NoSuchImageFilterException {
        ImageFilter imageFilter = null;
        imageFilter = this.lookupImageFilter(filterID);
        if (imageFilter == null) {
            imageFilter = this.dynamicallyCreateFilter(filterID);
            this.rememberImageFilter(filterID, imageFilter);
        }
        return imageFilter;
    }

    protected ImageFilter lookupImageFilter(String filterID) {
        return (ImageFilter)this.fImageFilters.get(filterID);
    }

    protected void rememberImageFilter(String filterID, ImageFilter imageFilter) {
        this.fImageFilters.put(filterID, imageFilter);
    }

    private ImageFilter dynamicallyCreateFilter(String filterID) throws NoSuchImageFilterException {
        try {
            return (ImageFilter)Class.forName(filterID).newInstance();
        }
        catch (Throwable t) {
            throw new NoSuchImageFilterException(filterID);
        }
    }
}

