/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing;

import com.wily.ui.linking.HyperlinkNavigator;
import com.wily.ui.linking.IHyperlinkNavigatorItem;
import com.wily.ui.swing.PatchedJTabbedPane;
import com.wily.wilyassert.Assertion;
import javax.swing.SwingUtilities;

public abstract class ARedirectableJTabbedPane
extends PatchedJTabbedPane {
    private HyperlinkNavigator fHyperlinkNavigator;

    private ARedirectableJTabbedPane() {
    }

    public ARedirectableJTabbedPane(HyperlinkNavigator hyperlinkNavigator) {
        this.fHyperlinkNavigator = hyperlinkNavigator;
    }

    protected abstract IHyperlinkNavigatorItem getHyperlinkNavigatorItemForIndex(int var1);

    protected void doSetSelectedIndex(int index) {
        super.setSelectedIndex(index);
    }

    public final void setSelectedIndex(int index) {
        Assertion.wilyAssert(index >= -1 && index < this.getTabCount(), "index: " + index + " tabs: " + this.getTabCount());
        this.setSelectedIndexRedirectSync(index);
    }

    public final void setSelectedIndexNoRedirectSync(int index) {
        Assertion.wilyAssert(index >= 0);
        Assertion.wilyAssert(index < this.getTabCount(), "index: " + index + " tab count: " + this.getTabCount());
        this.doSetSelectedIndex(index);
    }

    public final void setSelectedIndexNoRedirectAsync(final int index) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ARedirectableJTabbedPane.this.setSelectedIndexNoRedirectSync(index);
            }
        });
    }

    public final void setSelectedIndexRedirectSync(int index) {
        Assertion.wilyAssert(index < this.getTabCount());
        if (index == -1) {
            this.doSetSelectedIndex(index);
        } else {
            IHyperlinkNavigatorItem hyperlinkNavigatorItem = this.getHyperlinkNavigatorItemForIndex(index);
            this.fHyperlinkNavigator.gotoHyperlinkNavigatorItem(hyperlinkNavigatorItem);
        }
    }

    public final void setSelectedIndexRedirectAsync(final int index) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ARedirectableJTabbedPane.this.setSelectedIndexRedirectSync(index);
            }
        });
    }

    public HyperlinkNavigator getHyperlinkNavigator() {
        return this.fHyperlinkNavigator;
    }
}

