/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing;

import com.wily.ui.ListToTreeModelAdapter;
import com.wily.ui.swing.SynchronizedTreeModel;
import com.wily.wilyassert.Assertion;
import java.util.Comparator;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;

public class CoalescedTreeModel
extends SynchronizedTreeModel {
    private static final long serialVersionUID = -2970701566374729479L;
    private CoalescedTreeModelListener fCoalescedListener;
    private Comparator fComparator;
    private CoalescedTreeModel fDelegate;

    public CoalescedTreeModel(String rootName) {
        this(rootName, null);
    }

    public CoalescedTreeModel(Object rootUserObject, Comparator comparator) {
        this(rootUserObject, comparator, null);
    }

    public CoalescedTreeModel(Object rootUserObject, Comparator comparator, CoalescedTreeModel delegate) {
        super(new DefaultMutableTreeNode(rootUserObject));
        this.fComparator = comparator;
        this.setAsksAllowsChildrenSync(true);
        this.fCoalescedListener = new CoalescedTreeModelListener();
        this.fDelegate = delegate == null ? this : delegate;
    }

    public void addTreeModelSync(TreeModel model) {
        Assertion.wilyAssert(model.getRoot() instanceof DefaultMutableTreeNode);
        if (this.fComparator == null) {
            this.fDelegate.insertNodeIntoSync((DefaultMutableTreeNode)model.getRoot(), (DefaultMutableTreeNode)this.fDelegate.getRoot(), ((DefaultMutableTreeNode)this.fDelegate.getRoot()).getChildCount());
        } else {
            this.fDelegate.sortedInsertNodeIntoSync(this.fComparator, (DefaultMutableTreeNode)model.getRoot(), (DefaultMutableTreeNode)this.fDelegate.getRoot());
        }
        model.addTreeModelListener(this.fCoalescedListener);
    }

    public void addTreeModelAsync(final TreeModel model) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CoalescedTreeModel.this.addTreeModelSync(model);
            }
        });
    }

    public void removeTreeModelSync(TreeModel model) {
        model.removeTreeModelListener(this.fCoalescedListener);
        this.fDelegate.removeNodeFromParentSync((MutableTreeNode)model.getRoot());
    }

    public void removeTreeModelAsync(final TreeModel model) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CoalescedTreeModel.this.removeTreeModelSync(model);
            }
        });
    }

    public void addListModelSync(ListModel model, String parentName) {
        this.addTreeModelSync(new ListToTreeModelAdapter(model, parentName));
    }

    public void addListModelAsync(final ListModel model, final String parentName) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CoalescedTreeModel.this.addListModelSync(model, parentName);
            }
        });
    }

    public DefaultMutableTreeNode getRootDefaultMutableTreeNode() {
        return (DefaultMutableTreeNode)this.getRoot();
    }

    protected void fireTreeNodesChangedSync(Object a, Object[] b, int[] c, Object[] d) {
        if (this.fDelegate != this) {
            this.fDelegate.fireTreeNodesChangedSync(a, b, c, d);
        } else {
            super.fireTreeNodesChangedSync(a, b, c, d);
        }
    }

    protected void fireTreeNodesInsertedSync(Object a, Object[] b, int[] c, Object[] d) {
        if (this.fDelegate != this) {
            this.fDelegate.fireTreeNodesInsertedSync(a, b, c, d);
        } else {
            super.fireTreeNodesInsertedSync(a, b, c, d);
        }
    }

    protected void fireTreeNodesRemovedSync(Object a, Object[] b, int[] c, Object[] d) {
        if (this.fDelegate != this) {
            this.fDelegate.fireTreeNodesRemovedSync(a, b, c, d);
        } else {
            super.fireTreeNodesRemovedSync(a, b, c, d);
        }
    }

    protected void fireTreeStructureChangedSync(Object a, Object[] b, int[] c, Object[] d) {
        if (this.fDelegate != this) {
            this.fDelegate.fireTreeStructureChangedSync(a, b, c, d);
        } else {
            super.fireTreeStructureChangedSync(a, b, c, d);
        }
    }

    protected static Object[] translatePath(Object[] path, Object realRoot) {
        Object[] correctPath = null;
        int pathElementCount = path.length;
        for (int i = 0; i < pathElementCount; ++i) {
            if (path[i] != realRoot) continue;
            correctPath = path;
        }
        if (correctPath == null) {
            int oldPathLength = path.length;
            correctPath = new Object[oldPathLength + 1];
            correctPath[0] = realRoot;
            System.arraycopy(path, 0, correctPath, 1, oldPathLength);
        }
        return correctPath;
    }

    public void tearDown() {
    }

    private class CoalescedTreeModelListener
    implements TreeModelListener {
        private CoalescedTreeModelListener() {
        }

        public void treeNodesChanged(TreeModelEvent e) {
            CoalescedTreeModel.this.fireTreeNodesChangedSync(CoalescedTreeModel.this.fDelegate, CoalescedTreeModel.translatePath(e.getPath(), CoalescedTreeModel.this.fDelegate.getRootSync()), e.getChildIndices(), e.getChildren());
        }

        public void treeNodesInserted(TreeModelEvent e) {
            CoalescedTreeModel.this.fireTreeNodesInsertedSync(CoalescedTreeModel.this.fDelegate, CoalescedTreeModel.translatePath(e.getPath(), CoalescedTreeModel.this.fDelegate.getRootSync()), e.getChildIndices(), e.getChildren());
        }

        public void treeNodesRemoved(TreeModelEvent e) {
            CoalescedTreeModel.this.fireTreeNodesRemovedSync(CoalescedTreeModel.this.fDelegate, CoalescedTreeModel.translatePath(e.getPath(), CoalescedTreeModel.this.fDelegate.getRootSync()), e.getChildIndices(), e.getChildren());
        }

        public void treeStructureChanged(TreeModelEvent e) {
            CoalescedTreeModel.this.fireTreeStructureChangedSync(CoalescedTreeModel.this.fDelegate, CoalescedTreeModel.translatePath(e.getPath(), CoalescedTreeModel.this.fDelegate.getRootSync()), e.getChildIndices(), e.getChildren());
        }
    }
}

