/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing;

import com.wily.ui.IGenericServices;
import com.wily.ui.WilyUIUtilities;
import com.wily.ui.action.AOneWayExtendedAction;
import com.wily.ui.action.ExtendedActionException;
import com.wily.ui.action.IExtendedAction;
import com.wily.ui.selection.ANonVetoingSelectionChangeListener;
import com.wily.ui.selection.ISelectionChangeListener;
import com.wily.ui.selection.Selection;
import com.wily.ui.selection.SelectionChangedEvent;
import com.wily.ui.swing.ExtendedJMenu;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JMenuItem;

public class EditJMenu
extends ExtendedJMenu {
    private static final long serialVersionUID = -1781037654274664508L;
    private IGenericServices fGenericServices;
    private IExtendedAction fSelectAllAction;
    private ISelectionChangeListener fMenuSelectionChangeListener;

    public EditJMenu(IGenericServices genericServices) {
        super(genericServices.IGenericServices_getStringLocalizer().IStringLocalizer_getLocalizedString("Edit_Menu_Key"));
        this.fGenericServices = genericServices;
        WilyUIUtilities.setLocalizedMnemonic(this, "Edit_Menu_Mnemonic_Key", this.fGenericServices.IGenericServices_getStringLocalizer());
        this.fMenuSelectionChangeListener = new SelectionChangeListener();
        genericServices.IGenericServices_getSelectionBroker().addSelectionChangeListener(this.fMenuSelectionChangeListener);
        this.initUI();
    }

    private void initUI() {
        this.fSelectAllAction = new SelectAllAction();
        JMenuItem selectAllMenuItem = this.add(this.fSelectAllAction);
        WilyUIUtilities.setLocalizedMnemonic(selectAllMenuItem, "Select_All_Menu_Mnemonic_Key", this.fGenericServices.IGenericServices_getStringLocalizer());
        WilyUIUtilities.setLocalizedAccelerator(selectAllMenuItem, "Select_All_Menu_Accelerator_Key", this.fGenericServices.IGenericServices_getStringLocalizer());
    }

    public void tearDownExtendedJMenu(boolean tearDownNestedExtendedJMenus) {
        super.tearDownExtendedJMenu(tearDownNestedExtendedJMenus);
        this.fGenericServices.IGenericServices_getSelectionBroker().removeSelectionChangeListener(this.fMenuSelectionChangeListener);
        this.fSelectAllAction = null;
        this.fMenuSelectionChangeListener = null;
    }

    private class SelectAllAction
    extends AOneWayExtendedAction {
        private static final long serialVersionUID = 3108807032822372943L;

        public SelectAllAction() {
            super(EditJMenu.this.fGenericServices.IGenericServices_getStringLocalizer().IStringLocalizer_getLocalizedString("Select_All_Menu_Key"));
        }

        protected void doTriggerAction(ActionEvent actionEvent) throws ExtendedActionException {
            Selection selection = EditJMenu.this.fGenericServices.IGenericServices_getSelectionBroker().getCurrentSelection();
            Collection actions = selection.getAllExtendedActionsOfKey("selectAllActionKey");
            Iterator iterator = actions.iterator();
            while (iterator.hasNext()) {
                IExtendedAction action = (IExtendedAction)iterator.next();
                action.IExtendedAction_triggerAction(actionEvent);
            }
        }
    }

    private class SelectionChangeListener
    extends ANonVetoingSelectionChangeListener {
        private SelectionChangeListener() {
        }

        public void ISelectionChangeListener_selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            Selection selection = EditJMenu.this.fGenericServices.IGenericServices_getSelectionBroker().getCurrentSelection();
            EditJMenu.this.fSelectAllAction.setEnabled(selection.atLeastOneSelectableSupportsAction("selectAllActionKey"));
        }
    }
}

