/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing;

import com.wily.properties.KUIErrorMessagesKeys;
import com.wily.ui.swing.ExtendedScrollPaneLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class ExtendedJScrollPane
extends JScrollPane
implements KUIErrorMessagesKeys {
    private static final long serialVersionUID = -9083106803441826770L;
    public static final int kScrollUnitSmallIncrement = 25;
    public static final int kScrollUnitLargeIncrement = 250;

    public ExtendedJScrollPane() {
        this.init();
    }

    public ExtendedJScrollPane(Component view) {
        super(view);
        this.init();
    }

    public ExtendedJScrollPane(int vsbPolicy, int hsbPolicy) {
        super(vsbPolicy, hsbPolicy);
        this.init();
        this.setHorizontalScrollBarPolicy(hsbPolicy);
        this.setVerticalScrollBarPolicy(vsbPolicy);
    }

    public ExtendedJScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
        super(view, vsbPolicy, hsbPolicy);
        this.init();
        this.setHorizontalScrollBarPolicy(hsbPolicy);
        this.setVerticalScrollBarPolicy(vsbPolicy);
    }

    private void init() {
        this.verticalScrollBar.setUnitIncrement(25);
        this.horizontalScrollBar.setUnitIncrement(25);
        this.verticalScrollBar.setBlockIncrement(250);
        this.horizontalScrollBar.setBlockIncrement(250);
        this.setHorizontalScrollBarPolicy(30);
        this.setVerticalScrollBarPolicy(20);
        this.registerKeyboardAction(new PageUpDownAction(-1), KeyStroke.getKeyStroke(33, 0), 2);
        this.registerKeyboardAction(new PageUpDownAction(1), KeyStroke.getKeyStroke(34, 0), 2);
        this.registerKeyboardAction(new ArrowUpDownAction(-1), KeyStroke.getKeyStroke(38, 0), 2);
        this.registerKeyboardAction(new ArrowUpDownAction(1), KeyStroke.getKeyStroke(40, 0), 2);
        this.registerKeyboardAction(new ArrowLeftRightAction(-1), KeyStroke.getKeyStroke(37, 0), 2);
        this.registerKeyboardAction(new ArrowLeftRightAction(1), KeyStroke.getKeyStroke(39, 0), 2);
    }

    public void setEnabled(boolean enabled) {
        JScrollBar verticalScrollBar;
        super.setEnabled(enabled);
        JScrollBar horizontalScrollBar = this.getHorizontalScrollBar();
        if (horizontalScrollBar != null) {
            horizontalScrollBar.setEnabled(enabled);
        }
        if ((verticalScrollBar = this.getVerticalScrollBar()) != null) {
            verticalScrollBar.setEnabled(enabled);
        }
    }

    public void setColumnFooterView(Component view) {
        this.setColumnHeaderView(view);
        ExtendedScrollPaneLayout.UIResource layoutMgr = new ExtendedScrollPaneLayout.UIResource(false);
        this.setLayout(layoutMgr);
        layoutMgr.syncWithScrollPane(this);
    }

    private class PageUpDownAction
    extends AbstractAction {
        private static final long serialVersionUID = 4029901308610393246L;
        private int fDirection;

        public PageUpDownAction(int dir) {
            this.fDirection = dir;
        }

        public void actionPerformed(ActionEvent e) {
            JScrollBar scrollbar = ExtendedJScrollPane.this.getVerticalScrollBar();
            if (scrollbar == null) {
                return;
            }
            int value = scrollbar.getValue() + 250 * this.fDirection;
            scrollbar.setValue(value);
        }
    }

    private class ArrowUpDownAction
    extends AbstractAction {
        private static final long serialVersionUID = 7685833581204389033L;
        private int fDirection;

        public ArrowUpDownAction(int dir) {
            this.fDirection = dir;
        }

        public void actionPerformed(ActionEvent e) {
            JScrollBar scrollbar = ExtendedJScrollPane.this.getVerticalScrollBar();
            if (scrollbar == null) {
                return;
            }
            int value = scrollbar.getValue() + 25 * this.fDirection;
            scrollbar.setValue(value);
        }
    }

    private class ArrowLeftRightAction
    extends AbstractAction {
        private static final long serialVersionUID = 8239537925392359153L;
        private int fDirection;

        public ArrowLeftRightAction(int dir) {
            this.fDirection = dir;
        }

        public void actionPerformed(ActionEvent e) {
            JScrollBar scrollbar = ExtendedJScrollPane.this.getHorizontalScrollBar();
            if (scrollbar == null) {
                return;
            }
            int value = scrollbar.getValue() + 25 * this.fDirection;
            scrollbar.setValue(value);
        }
    }
}

