/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;

public class IntegerTextField
extends JTextField
implements FocusListener {
    private static final long serialVersionUID = -1529449934132785688L;
    private int fOldValue = 0;

    public IntegerTextField(int size) {
        super(size);
        this.addFocusListener(this);
        this.setHorizontalAlignment(4);
    }

    public int getInteger() {
        try {
            return Integer.parseInt(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public void setInteger(int value) {
        this.setText(String.valueOf(value));
    }

    public void focusGained(FocusEvent e) {
        try {
            this.fOldValue = Integer.parseInt(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void focusLost(FocusEvent e) {
        try {
            Integer.parseInt(this.getText());
        }
        catch (NumberFormatException nfe) {
            this.setText(String.valueOf(this.fOldValue));
        }
    }
}

