/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing;

import com.wily.wilyassert.Assertion;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import javax.swing.JPanel;

public class OneChildJPanel
extends JPanel {
    private static final long serialVersionUID = -3101898274795981938L;
    private static final LayoutManager gOneChildLayoutManager = new OneChildLayoutManager();

    public OneChildJPanel() {
        this.init();
    }

    public OneChildJPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.init();
    }

    private void init() {
        this.setLayout(gOneChildLayoutManager);
    }

    public Component setChild(Component comp) {
        this.removeAll();
        super.add(comp);
        return comp;
    }

    public Component setChild(Component comp, Object constraints) {
        this.removeAll();
        super.add(comp, constraints);
        return comp;
    }

    public Component setChild(String name, Component comp) {
        this.removeAll();
        super.add(name, comp);
        return comp;
    }

    public boolean hasChild() {
        return this.getComponentCount() != 0;
    }

    public Component getChild() {
        return this.getComponent(0);
    }

    public Component add(Component comp) {
        return this.setChild(comp);
    }

    public Component add(Component comp, int index) {
        Assertion.wilyAssert(index == 0);
        return this.setChild(comp);
    }

    public void add(Component comp, Object constraints) {
        this.setChild(comp, constraints);
    }

    public void add(Component comp, Object constraints, int index) {
        Assertion.wilyAssert(index == 0);
        this.setChild(comp, constraints);
    }

    public Component add(String name, Component comp) {
        return this.setChild(name, comp);
    }

    private static class OneChildLayoutManager
    implements LayoutManager2 {
        private OneChildLayoutManager() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void addLayoutComponent(Component comp, Object constraints) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        public void invalidateLayout(Container target) {
        }

        public Dimension minimumLayoutSize(Container parent) {
            OneChildJPanel castParent = (OneChildJPanel)parent;
            if (castParent.hasChild()) {
                return castParent.getChild().getMinimumSize();
            }
            return new Dimension(0, 0);
        }

        public Dimension preferredLayoutSize(Container parent) {
            OneChildJPanel castParent = (OneChildJPanel)parent;
            if (castParent.hasChild()) {
                return castParent.getChild().getPreferredSize();
            }
            return new Dimension(0, 0);
        }

        public Dimension maximumLayoutSize(Container parent) {
            OneChildJPanel castParent = (OneChildJPanel)parent;
            if (castParent.hasChild()) {
                return castParent.getChild().getMaximumSize();
            }
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        public void layoutContainer(Container parent) {
            OneChildJPanel castParent = (OneChildJPanel)parent;
            if (castParent.hasChild()) {
                Component child = castParent.getChild();
                child.setLocation(0, 0);
                child.setSize(parent.getSize());
            }
        }
    }
}

