/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SpinWidget
extends AbstractButton {
    private static final long serialVersionUID = -4871991723223992611L;
    private static final int SPIN_WIDGET_HEIGHT = 14;
    private boolean fOpen;
    private final Dimension fMySize = new Dimension(14, 14);
    private static final int HALF_HEIGHT = 7;
    private static final int[] openXPoints = new int[]{1, 7, 13};
    private static final int[] openYPoints = new int[]{7, 13, 7};
    private static final int[] closedXPoints = new int[]{1, 1, 7};
    private static final int[] closedYPoints = new int[]{1, 13, 7};
    private static final Polygon openTriangle = new Polygon(openXPoints, openYPoints, 3);
    private static final Polygon closedTriangle = new Polygon(closedXPoints, closedYPoints, 3);

    public SpinWidget() {
        this.setOpen(false);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                SpinWidget.this.handleClick();
            }
        });
    }

    public void handleClick() {
        this.setOpen(!this.isOpen());
    }

    public boolean isOpen() {
        return this.fOpen;
    }

    public void setOpen(boolean o) {
        this.fOpen = o;
        this.fireStateChanged();
        this.repaint();
    }

    public Dimension getMinimumSize() {
        return this.fMySize;
    }

    public Dimension getPreferredSize() {
        return this.fMySize;
    }

    public void paint(Graphics g) {
        g.setColor(this.getForeground());
        if (this.isOpen()) {
            g.fillPolygon(openTriangle);
        } else {
            g.fillPolygon(closedTriangle);
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Test");
        final SpinWidget widget = new SpinWidget();
        widget.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                System.out.println("Widget Click. Open = " + widget.isOpen());
            }
        });
        frame.getContentPane().add(widget);
        frame.pack();
        frame.show();
    }
}

