/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.resource.file;

import com.wily.util.io.ExtendedFile;
import java.io.File;

public abstract class AFileBasedResource {
    private static final String kEmptyString = "";
    private final File fDir;

    public AFileBasedResource(File source) {
        File initial = null;
        if (source == null) {
            initial = null;
        } else {
            String dir = source.getPath();
            if (!source.isDirectory()) {
                dir = source.getParent();
            }
            initial = ExtendedFile.getCanonicalFile(dir);
        }
        this.fDir = initial;
    }

    protected File getRelativeFile(String name) {
        if (name == null) {
            name = kEmptyString;
        }
        File file = new File(name);
        if (this.fDir != null && !file.isAbsolute()) {
            file = new File(this.fDir, name);
        }
        return file;
    }

    protected String getResourceLocation(String name) {
        File file = this.getRelativeFile(name);
        return ExtendedFile.safeGetCanonicalPath(file);
    }
}

