/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.string;

public final class NonSyncStringBuffer {
    private static int kDefaultSize = 256;
    private char[] fString;
    private int fStringLength = 0;

    public NonSyncStringBuffer(int size) {
        this.fString = new char[size];
    }

    public NonSyncStringBuffer(String s1, String s2) {
        this(s1.length() + s2.length());
        this.append(s1);
        this.append(s2);
    }

    public NonSyncStringBuffer(String s1, String s2, String s3) {
        this(s1.length() + s2.length() + s3.length());
        this.append(s1);
        this.append(s2);
        this.append(s3);
    }

    public NonSyncStringBuffer() {
        this(kDefaultSize);
    }

    private void addSize(int size) {
        if (this.fString.length < this.fStringLength + size) {
            char[] oldString = this.fString;
            this.fString = new char[this.fStringLength + size];
            System.arraycopy(oldString, 0, this.fString, 0, oldString.length);
        }
    }

    public void append(String s) {
        int sLen = s.length();
        this.addSize(sLen);
        s.getChars(0, sLen, this.fString, this.fStringLength);
        this.fStringLength += sLen;
    }

    public String toString() {
        return new String(this.fString, 0, this.fStringLength);
    }

    public static String concat(String s1, String s2, String s3) {
        return new NonSyncStringBuffer(s1, s2, s3).toString();
    }
}

