/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.spec;

import com.wily.rave.spec.FindDBObjects;
import com.wily.rave.spec.IDataSourceInstance;
import com.wily.rave.utils.HashCodeUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class DataSourceInstance
implements IDataSourceInstance,
Externalizable {
    private static final long serialVersionUID = 2L;
    private static final String VERSION_STRING = "\nCD_VERSION&*\n";
    private static final Map dataSources = new HashMap();
    private String dsName;
    private String dsDisplayName;
    private String dsType;
    private String agentName;
    private boolean deletionSupport;
    private transient Key fKey;

    public DataSourceInstance() {
    }

    private DataSourceInstance(String name, String displayName, String type, String agentName, boolean deletionSupport) {
        this.dsName = name;
        this.dsDisplayName = displayName;
        this.dsType = type;
        this.agentName = agentName;
        this.deletionSupport = deletionSupport;
    }

    @Override
    public void writeExternal(ObjectOutput oo) throws IOException {
        oo.writeUTF(VERSION_STRING);
        oo.writeLong(2L);
        oo.writeUTF(this.dsName);
        oo.writeUTF(this.dsDisplayName != null ? this.dsDisplayName : this.dsName);
        oo.writeUTF(this.dsType);
        oo.writeUTF(this.agentName);
        oo.writeBoolean(this.deletionSupport);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        String tmpString = oi.readUTF();
        if (tmpString.equals(VERSION_STRING)) {
            long version = oi.readLong();
            if (version != 2L) throw new ClassNotFoundException("Unknown serialVersionUID for DataSourceInstance: " + version);
            this.dsName = oi.readUTF().intern();
            this.dsDisplayName = oi.readUTF().intern();
        } else {
            this.dsDisplayName = this.dsName = tmpString.intern();
        }
        this.dsType = oi.readUTF().intern();
        this.agentName = oi.readUTF().intern();
        this.deletionSupport = oi.readBoolean();
    }

    private void intern() {
        this.dsName = this.dsName.intern();
        this.dsDisplayName = this.dsDisplayName == null ? this.dsName : this.dsDisplayName.intern();
        this.dsType = this.dsType.intern();
        this.agentName = this.agentName.intern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSourceInstance checkForDup() {
        DataSourceInstance oldInstance = (DataSourceInstance)FindDBObjects.getDBObject((Comparable)((Object)this.getKey()), IDataSourceInstance.class, this);
        if (oldInstance != null) {
            return oldInstance;
        }
        Map map = dataSources;
        synchronized (map) {
            oldInstance = (DataSourceInstance)dataSources.get(this);
            if (oldInstance == null) {
                this.intern();
                dataSources.put(this, this);
                oldInstance = this;
            }
        }
        return oldInstance;
    }

    public static final DataSourceInstance get(String name, String displayName, String type, String agentName, boolean deletionSupport) {
        return new DataSourceInstance(name, displayName, type, agentName, deletionSupport).checkForDup();
    }

    @Override
    public String getName() {
        return this.dsName;
    }

    @Override
    public String getDisplayName() {
        if (this.dsDisplayName == null) {
            return this.dsName;
        }
        return this.dsDisplayName;
    }

    @Override
    public String getType() {
        return this.dsType;
    }

    @Override
    public String getAgentName() {
        return this.agentName;
    }

    @Override
    public boolean deletionSupport() {
        return this.deletionSupport;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof DataSourceInstance) {
            DataSourceInstance otherDataSourceInstance = (DataSourceInstance)other;
            if (this.dsName.equals(otherDataSourceInstance.dsName) && this.dsType.equals(otherDataSourceInstance.dsType) && this.agentName.equals(otherDataSourceInstance.agentName)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized Serializable getKey() {
        if (this.fKey == null) {
            this.fKey = new Key(this.dsName, this.dsType, this.agentName);
        }
        return this.fKey;
    }

    public int hashCode() {
        int code = HashCodeUtils.accumulateHashCode(this.agentName.hashCode(), this.dsName);
        code = HashCodeUtils.accumulateHashCode(code, this.dsType);
        return code;
    }

    public String toString() {
        return String.valueOf(this.dsName) + "/" + this.dsType + "@" + this.agentName;
    }

    private Object readResolve() {
        return this.checkForDup();
    }

    private static final class Key
    implements Serializable,
    Comparable {
        private static final long serialVersionUID = 1L;
        private String fName;
        private String fType;
        private String fAgentName;

        private Key(String name, String type, String agentName) {
            this.fName = name;
            this.fType = type;
            this.fAgentName = agentName;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof Key) {
                Key otherKey = (Key)other;
                if (this.fName.equals(otherKey.fName) && this.fType.equals(otherKey.fType) && this.fAgentName.equals(otherKey.fAgentName)) {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return "Key for: " + this.fName + "/" + this.fType + "@" + this.fAgentName;
        }

        public int hashCode() {
            int code = HashCodeUtils.accumulateHashCode(this.fAgentName.hashCode(), this.fName);
            code = HashCodeUtils.accumulateHashCode(code, this.fType);
            return code;
        }

        public int compareTo(Object other) {
            Key otherDS = (Key)other;
            int value = this.fName.compareTo(otherDS.fName);
            if (value == 0 && (value = this.fType.compareTo(otherDS.fType)) == 0) {
                value = this.fAgentName.compareTo(otherDS.fAgentName);
            }
            return value;
        }
    }
}

