/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.spec.ds.classmonitor;

import com.wily.rave.spec.IContent;
import com.wily.rave.spec.IContentChange;
import com.wily.rave.spec.IContentMetadataItem;
import com.wily.rave.spec.IContentSummary;
import com.wily.rave.spec.IContentValue;
import com.wily.rave.spec.IDataSourceInstance;
import com.wily.rave.spec.InvalidContent;
import com.wily.rave.spec.ds.classmonitor.ClassContentChange;
import com.wily.rave.spec.ds.classmonitor.ClassContentSummary;
import com.wily.rave.spec.ds.classmonitor.ClassContentValue;
import com.wily.rave.spec.ds.classmonitor.DotnetClassContentSummary;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ClassContent
implements IContent,
Externalizable {
    private static final long serialVersionUID = 1L;
    private ClassContentSummary summary;
    private ClassContentValue value;

    public ClassContent() {
    }

    public ClassContent(String className, long size, byte[] digest, IDataSourceInstance dsInstance) {
        this.summary = new ClassContentSummary(className, size, digest, dsInstance);
    }

    public ClassContent(String className, ClassContentValue value, long size, byte[] digest, IDataSourceInstance dsInstance) {
        this(className, size, digest, dsInstance);
        this.value = value;
    }

    public ClassContent(String assemblyPath, String version, String className, long size, byte[] digest, IDataSourceInstance dsInstance) {
        this.summary = new DotnetClassContentSummary(assemblyPath, version, className, size, digest, dsInstance);
    }

    public ClassContent(String assemblyPath, String version, String className, ClassContentValue value, long size, byte[] digest, IDataSourceInstance dsInstance) {
        this(assemblyPath, version, className, size, digest, dsInstance);
        this.value = value;
    }

    @Override
    public String getResourceName() {
        return this.summary.getResourceName();
    }

    @Override
    public String getResourceOwner() {
        return this.summary.getResourceOwner();
    }

    @Override
    public boolean hasMetadata() {
        return this.summary.hasMetadata();
    }

    @Override
    public IContentMetadataItem[] getMetadata() {
        return this.summary.getMetadata();
    }

    @Override
    public IDataSourceInstance getDataSourceInstance() {
        return this.summary.getDataSourceInstance();
    }

    @Override
    public IContentValue getResourceValue() {
        return this.value;
    }

    public String getAssemblyPath() {
        return this.summary.getAssemblyPath();
    }

    public String getAssemblyVersion() {
        return this.summary.getAssemblyVersion();
    }

    @Override
    public IContentSummary getContentSummary() {
        return this.summary;
    }

    @Override
    public IContentChange getChange(long changeDetectionTime, IContent priorContent) throws InvalidContent {
        if (!(priorContent instanceof ClassContent)) {
            throw new InvalidContent("Not same type content! This: " + ClassContent.class.getName() + "; prior content: " + priorContent.getClass().getName());
        }
        ClassContent priorClass = (ClassContent)priorContent;
        return new ClassContentChange(this, priorClass, changeDetectionTime);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.summary);
        out.writeObject(this.value);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.summary = (ClassContentSummary)in.readObject();
        this.value = (ClassContentValue)in.readObject();
    }

    public int hashCode() {
        return this.summary.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ClassContent) {
            ClassContent otherContent = (ClassContent)other;
            return this.summary.equals(otherContent.summary);
        }
        return false;
    }
}

