/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.platform.util;

import com.wily.wilyassert.Assertion;

public final class ProcessCPUUsageCalculator {
    private long fSystemSnapshot = 0L;
    private long fProcessSnapshot = 0L;

    public void setSnapshot(long systemSeconds, long processSeconds) {
        Assertion.wilyAssert(systemSeconds >= 0L);
        Assertion.wilyAssert(processSeconds >= 0L);
        this.fSystemSnapshot = systemSeconds;
        this.fProcessSnapshot = processSeconds;
    }

    public double getTotalCPUUsageByThisProcessAllowSkew(long systemSeconds, long processSeconds) {
        if (processSeconds < this.fProcessSnapshot) {
            this.fProcessSnapshot = processSeconds;
        }
        return this.getTotalCPUUsageByThisProcess(systemSeconds < this.fSystemSnapshot ? this.fSystemSnapshot : systemSeconds, processSeconds);
    }

    public double getTotalCPUUsageByThisProcess(long systemSeconds, long processSeconds) {
        Assertion.wilyAssert(systemSeconds >= this.fSystemSnapshot);
        Assertion.wilyAssert(processSeconds >= this.fProcessSnapshot);
        Assertion.wilyAssert(processSeconds <= systemSeconds);
        double percent = 0.0;
        if (systemSeconds - this.fSystemSnapshot > 0L) {
            percent = (double)(processSeconds - this.fProcessSnapshot) / (double)(systemSeconds - this.fSystemSnapshot);
        }
        if ((percent *= 100.0) < 0.0) {
            percent = 0.0;
        } else if (percent > 100.0) {
            percent = 100.0;
        }
        this.fSystemSnapshot = systemSeconds;
        this.fProcessSnapshot = processSeconds;
        return percent;
    }
}

