/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui;

import com.wily.ui.HtmlPane;
import com.wily.ui.IGenericServices;
import com.wily.ui.swing.ExtendedJFrame;
import com.wily.util.properties.IndexedProperties;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;

public class HtmlHelpSystem
extends ExtendedJFrame {
    private static final long serialVersionUID = 4496318112476358316L;
    private static final String kIndexFileName = "index.properties";
    private static final String kTitleDirectiveKey = "title";
    private static final String kFileDirectiveKey = "file";
    private String fPathToHelpFiles;
    private String[] fHelpFileNames;
    private Container fContent;
    private HtmlPane fHtmlPane;
    private int fCurrentPanel;

    public HtmlHelpSystem(IGenericServices services, String name, String iconKey, String pathToHelpFiles) throws IOException {
        super(services, name, iconKey);
        File helpDirectory = new File(pathToHelpFiles);
        File indexFile = new File(helpDirectory, kIndexFileName);
        IndexedProperties indexProperties = new IndexedProperties();
        FileInputStream inStream = new FileInputStream(indexFile);
        indexProperties.load(inStream);
        inStream.close();
        String[] titleList = indexProperties.getTrimmedIndexedProperties(kTitleDirectiveKey);
        String[] fileList = indexProperties.getTrimmedIndexedProperties(kFileDirectiveKey);
        this.sharedInit(pathToHelpFiles, titleList, fileList);
    }

    public HtmlHelpSystem(IGenericServices services, String name, String iconKey, String pathToHelpFiles, URL urlToHelpFiles) throws IOException {
        super(services, name, iconKey);
        this.sharedInit(urlToHelpFiles);
    }

    public HtmlHelpSystem(IGenericServices services, String name, String iconKey, String pathToHelpFiles, String[] helpUserVisibleNames, String[] helpFileNames) throws IOException {
        super(services, name, iconKey);
        this.sharedInit(pathToHelpFiles, helpUserVisibleNames, helpFileNames);
    }

    private void sharedInit(String pathToHelpFiles, String[] titleList, String[] fileList) {
        if (titleList.length != fileList.length) {
            throw new IllegalArgumentException("HtmlHelpSystem: title and file lists must be the same length.");
        }
        this.fPathToHelpFiles = pathToHelpFiles;
        this.fHelpFileNames = fileList;
        this.setSize(new Dimension(340, 400));
        this.fContent = this.getContentPane();
        this.fContent.setLayout(new BorderLayout());
        this.setResizable(true);
        this.rawSetCurrentPanel(0);
    }

    private void sharedInit(URL pathToHelpFiles) {
        this.fPathToHelpFiles = pathToHelpFiles.toString();
        this.setSize(new Dimension(340, 400));
        this.fContent = this.getContentPane();
        this.fContent.setLayout(new BorderLayout());
        this.setResizable(true);
        this.rawSetCurrentPanel(0, pathToHelpFiles);
    }

    public void showHelp(File helpFile) {
        if (this.fHtmlPane != null) {
            this.fContent.remove(this.fHtmlPane);
        }
        this.fHtmlPane = new HtmlPane("file:" + helpFile.getAbsolutePath());
        this.fContent.add("Center", this.fHtmlPane);
        this.validate();
    }

    public void showHelp(URL helpFile) {
        if (this.fHtmlPane != null) {
            this.fContent.remove(this.fHtmlPane);
        }
        this.fHtmlPane = new HtmlPane(helpFile);
        this.fContent.add("Center", this.fHtmlPane);
        this.validate();
    }

    public void setCurrentPanel(int panel) {
        if (panel == this.fCurrentPanel || panel < 0 || panel > this.fHelpFileNames.length) {
            return;
        }
        this.rawSetCurrentPanel(panel);
    }

    private void rawSetCurrentPanel(int panel) {
        this.fCurrentPanel = panel;
        this.showHelp(new File(this.fPathToHelpFiles, this.fHelpFileNames[panel]));
    }

    private void rawSetCurrentPanel(int panel, URL pathToHelpFiles) {
        this.fCurrentPanel = panel;
        this.showHelp(pathToHelpFiles);
    }

    public void advancePanel() {
        this.setCurrentPanel(this.fCurrentPanel++);
    }

    public void retreatPanel() {
        this.setCurrentPanel(this.fCurrentPanel--);
    }
}

