/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import javax.swing.JScrollPane;

public class ScrollAwareFlowLayout
extends FlowLayout {
    private static final long serialVersionUID = -8116736369001630773L;
    private JScrollPane fScrollPane;

    public ScrollAwareFlowLayout(JScrollPane scrollPane) {
        super(1, 5, 5);
        this.fScrollPane = scrollPane;
    }

    public ScrollAwareFlowLayout(JScrollPane scrollPane, int align) {
        super(align, 5, 5);
        this.fScrollPane = scrollPane;
    }

    public ScrollAwareFlowLayout(JScrollPane scrollPane, int align, int hgap, int vgap) {
        super(align, hgap, vgap);
        this.fScrollPane = scrollPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container target) {
        Dimension maxBounds = null;
        Object object = target.getTreeLock();
        synchronized (object) {
            maxBounds = new Dimension(0, 0);
            Dimension rowBounds = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getPreferredSize();
                if (i > 0) {
                    rowBounds.width += this.getHgap();
                }
                if (rowBounds.width + d.width > this.calculateMaxWidth()) {
                    maxBounds.width = Math.max(rowBounds.width, maxBounds.width);
                    maxBounds.height += rowBounds.height;
                    rowBounds.width = d.width;
                    rowBounds.height = d.height;
                    continue;
                }
                rowBounds.width = (int)((double)rowBounds.width + d.getWidth());
                rowBounds.height = Math.max(rowBounds.height, d.height);
            }
            maxBounds.width = Math.max(rowBounds.width, maxBounds.width);
            maxBounds.height += rowBounds.height;
            Insets insets = target.getInsets();
            maxBounds.width += insets.left + insets.right + this.getHgap() * 2;
            maxBounds.height += insets.top + insets.bottom + this.getVgap() * 2;
        }
        return maxBounds;
    }

    public Dimension minimumLayoutSize(Container target) {
        Dimension maxBounds = new Dimension(0, 0);
        Dimension rowBounds = new Dimension(0, 0);
        int nmembers = target.getComponentCount();
        for (int i = 0; i < nmembers; ++i) {
            Component m = target.getComponent(i);
            if (!m.isVisible()) continue;
            Dimension d = m.getMinimumSize();
            if (i > 0) {
                rowBounds.width += this.getHgap();
            }
            if (rowBounds.width + d.width > this.calculateMaxWidth()) {
                maxBounds.width = Math.max(rowBounds.width, maxBounds.width);
                maxBounds.height += rowBounds.height;
                rowBounds.width = d.width;
                rowBounds.height = d.height;
                continue;
            }
            rowBounds.width = (int)((double)rowBounds.width + d.getWidth());
            rowBounds.height = Math.max(rowBounds.height, d.height);
        }
        maxBounds.width = Math.max(rowBounds.width, maxBounds.width);
        maxBounds.height += rowBounds.height;
        Insets insets = target.getInsets();
        maxBounds.width += insets.left + insets.right + this.getHgap() * 2;
        maxBounds.height += insets.top + insets.bottom + this.getVgap() * 2;
        return maxBounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveComponents(Container target, int x, int y, int width, int height, int rowStart, int rowEnd, boolean ltr) {
        Object object = target.getTreeLock();
        synchronized (object) {
            switch (this.getAlignment()) {
                case 0: {
                    x += ltr ? 0 : width;
                    break;
                }
                case 1: {
                    x += width / 2;
                    break;
                }
                case 2: {
                    x += ltr ? width : 0;
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    x += width;
                }
            }
            for (int i = rowStart; i < rowEnd; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                if (ltr) {
                    m.setLocation(x, y + (height - m.getHeight()) / 2);
                } else {
                    m.setLocation(target.getWidth() - x - m.getWidth(), y + (height - m.getHeight()) / 2);
                }
                x += m.getWidth() + this.getHgap();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int maxwidth = this.calculateMaxWidth() - (insets.left + insets.right + this.getHgap() * 2);
            int nmembers = target.getComponentCount();
            int x = 0;
            int y = insets.top + this.getVgap();
            int rowh = 0;
            int start = 0;
            boolean ltr = target.getComponentOrientation().isLeftToRight();
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getPreferredSize();
                m.setSize(d.width, d.height);
                if (x == 0 || x + d.width <= maxwidth) {
                    if (x > 0) {
                        x += this.getHgap();
                    }
                    x += d.width;
                    rowh = Math.max(rowh, d.height);
                    continue;
                }
                this.moveComponents(target, insets.left + this.getHgap(), y, maxwidth - x, rowh, start, i, ltr);
                x = d.width;
                y += this.getVgap() + rowh;
                rowh = d.height;
                start = i;
            }
            this.moveComponents(target, insets.left + this.getHgap(), y, maxwidth - x, rowh, start, nmembers, ltr);
        }
    }

    private int calculateMaxWidth() {
        int maxWidth = this.fScrollPane.getWidth();
        maxWidth = maxWidth > 18 ? maxWidth - 18 : maxWidth;
        return maxWidth;
    }
}

