/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class WilyOrderedFlowLayout
implements LayoutManager {
    private boolean fGrowIntoEmptySpace;
    private int fMaxWidth;

    public WilyOrderedFlowLayout() {
        this(false, Integer.MAX_VALUE);
    }

    public WilyOrderedFlowLayout(boolean growIntoEmptySpace) {
        this(growIntoEmptySpace, Integer.MAX_VALUE);
    }

    public WilyOrderedFlowLayout(boolean growIntoEmptySpace, int maxWidth) {
        this.fGrowIntoEmptySpace = growIntoEmptySpace;
        this.fMaxWidth = maxWidth;
    }

    public void addLayoutComponent(String name, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.minimumLayoutSize(container);
    }

    public Dimension minimumLayoutSize(Container container) {
        Insets insets = container.getInsets();
        int maxWidth = this.fMaxWidth;
        Container ancestor = SwingUtilities.getAncestorOfClass(JViewport.class, container);
        if (ancestor != null) {
            maxWidth = Math.min(maxWidth, ancestor.getSize().width);
        }
        maxWidth -= insets.left + insets.right;
        int myWidth = 0;
        int myHeight = 0;
        Stack<Point> corners = new Stack<Point>();
        Point current = new Point(0, 0);
        Component[] children = container.getComponents();
        for (int i = 0; i < children.length; ++i) {
            Dimension minSize = children[i].getMinimumSize();
            while (current.x + minSize.width > maxWidth && !corners.empty()) {
                current = (Point)corners.pop();
            }
            myWidth = Math.max(myWidth, current.x + insets.left + insets.right + minSize.width);
            myHeight = Math.max(myHeight, current.y + insets.top + insets.bottom + minSize.height);
            Point next = new Point(current.x, current.y + minSize.height);
            while (!corners.empty() && ((Point)corners.peek()).y <= next.y) {
                next.x = ((Point)corners.pop()).x;
            }
            corners.push(next);
            current.x += minSize.width;
        }
        return new Dimension(myWidth, myHeight);
    }

    public void layoutContainer(Container container) {
        Point next;
        Dimension useSize;
        Container parent = container.getParent();
        Dimension totalSize = parent != null && parent instanceof JViewport ? parent.getSize() : container.getSize();
        Insets insets = container.getInsets();
        Dimension actualSize = new Dimension(totalSize.width - insets.left - insets.right, totalSize.height - insets.top - insets.bottom);
        Stack<Point> corners = new Stack<Point>();
        Point current = new Point(0, 0);
        int myWidth = 0;
        int myHeight = 0;
        Component[] children = container.getComponents();
        for (int i = 0; i < children.length; ++i) {
            useSize = children[i].getMinimumSize();
            while (current.x + useSize.width > actualSize.width && !corners.empty()) {
                current = (Point)corners.pop();
            }
            myWidth = Math.max(myWidth, current.x + insets.left + insets.right + useSize.width);
            myHeight = Math.max(myHeight, current.y + insets.top + insets.bottom + useSize.height);
            children[i].setLocation(new Point(current.x + insets.left, current.y + insets.top));
            children[i].setSize(useSize);
            next = new Point(current.x, current.y + useSize.height);
            while (!corners.empty() && ((Point)corners.peek()).y <= next.y) {
                next.x = ((Point)corners.pop()).x;
            }
            corners.push(next);
            current.x += useSize.width;
        }
        if (this.fGrowIntoEmptySpace) {
            Vector<Point> stairs = new Vector<Point>();
            useSize = new Dimension(0, 0);
            next = new Point(Math.max(myWidth, totalSize.width) - insets.right, insets.top);
            Point prev = new Point(insets.left, Math.max(myHeight, totalSize.height) - insets.bottom);
            stairs.addElement(prev);
            stairs.addElement(next);
            for (int i = children.length - 1; i >= 0; --i) {
                int j;
                Dimension maxSize = children[i].getMaximumSize();
                current = children[i].getLocation();
                for (j = 1; j < stairs.size(); ++j) {
                    next = (Point)stairs.elementAt(j);
                    if (current.x < next.x) break;
                }
                prev = (Point)stairs.elementAt(j - 1);
                useSize = (Dimension)maxSize.clone();
                useSize.width = Math.min(useSize.width, next.x - current.x);
                useSize.height = Math.min(useSize.height, prev.y - current.y);
                children[i].setSize(useSize);
                stairs.insertElementAt(current, j);
                if (current.y == next.y) {
                    stairs.removeElementAt(j + 1);
                }
                if (current.x != prev.x) continue;
                stairs.removeElementAt(j - 1);
            }
        }
    }
}

