/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui;

import com.wily.properties.KUICommonStringsKeys;
import com.wily.ui.IGenericServices;
import com.wily.ui.WilyDurationPanel;
import com.wily.util.validate.ValidationException;
import com.wily.util.validate.ValidationInvalidQuantizedBoundedLongException;

public final class WilyQuantizedDurationPanel
extends WilyDurationPanel
implements KUICommonStringsKeys {
    private static final long serialVersionUID = -2529722772626403076L;
    private final int fQuantum;
    private final boolean fRequireNonZero;

    public WilyQuantizedDurationPanel(IGenericServices genericServices, int quantum) {
        this(genericServices, 0, quantum, true);
    }

    public WilyQuantizedDurationPanel(IGenericServices genericServices, int quantum, boolean requireNonZero) {
        this(genericServices, 0, quantum, requireNonZero);
    }

    public WilyQuantizedDurationPanel(IGenericServices genericServices, int initialDuration, int quantum) {
        this(genericServices, initialDuration, quantum, true);
    }

    public WilyQuantizedDurationPanel(IGenericServices genericServices, int initialDuration, int quantum, boolean requireNonZero) {
        super(genericServices, initialDuration);
        this.fRequireNonZero = requireNonZero;
        this.fQuantum = quantum;
    }

    private boolean requiresNonZeroValue() {
        return this.fRequireNonZero;
    }

    protected int getQuantumInSeconds() {
        return this.fQuantum;
    }

    protected void doIncrementFocusedField(int incrementBy) {
        if (incrementBy < this.getQuantumInSeconds()) {
            int durationInSecs = this.getDurationInSeconds();
            int offset = durationInSecs % this.getQuantumInSeconds();
            this.setDurationInSeconds(durationInSecs - offset + this.getQuantumInSeconds());
        } else {
            super.doIncrementFocusedField(incrementBy);
        }
    }

    protected void doDecrementFocusedField(int decrementBy) {
        if (decrementBy < this.getQuantumInSeconds()) {
            int durationInSecs = this.getDurationInSeconds() - 1;
            int offset = durationInSecs % this.getQuantumInSeconds();
            this.setDurationInSeconds(durationInSecs - offset);
        } else {
            super.doDecrementFocusedField(decrementBy);
        }
    }

    protected boolean doComputeDecrementEnableState() {
        boolean result = super.doComputeDecrementEnableState();
        if (result && this.requiresNonZeroValue()) {
            result = this.getDurationInSeconds() > this.getQuantumInSeconds();
        }
        return result;
    }

    private void checkTimeIsMultipleOfQuantum() {
        if (this.requiresNonZeroValue() && this.getDurationInMillis() == 0) {
            throw new IllegalArgumentException("Time value must not be zero");
        }
        if (this.getDurationInMillis() / 1000 % this.getQuantumInSeconds() != 0) {
            throw new IllegalArgumentException("Time value is not a multiple of the quantum: " + this.getQuantumInSeconds());
        }
    }

    private int getMaxTimeValueForQuantumInSeconds() {
        int maxMilliseconds = Integer.MAX_VALUE - Integer.MAX_VALUE % (this.getQuantumInSeconds() * 1000);
        return maxMilliseconds / 1000;
    }

    public void IValidatable_validate(int validationConstraints) throws ValidationException {
        try {
            super.IValidatable_validate(validationConstraints);
        }
        catch (ValidationException ve) {
            throw new ValidationInvalidQuantizedBoundedLongException(this.getQuantumInSeconds(), (long)this.getMaxTimeValueForQuantumInSeconds(), (long)this.getQuantumInSeconds());
        }
        try {
            this.checkTimeIsMultipleOfQuantum();
        }
        catch (IllegalArgumentException iae) {
            throw new ValidationInvalidQuantizedBoundedLongException(this.getQuantumInSeconds(), (long)this.getMaxTimeValueForQuantumInSeconds(), (long)this.getQuantumInSeconds());
        }
    }
}

