/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui;

import com.wily.properties.KUICommonStringsKeys;
import com.wily.ui.IGenericServices;
import com.wily.ui.WilyTimeTextField;
import com.wily.util.validate.ValidationException;
import com.wily.util.validate.ValidationInvalidQuantizedBoundedLongException;
import com.wily.wilyassert.Assertion;

public class WilyQuantizedTimeTextField
extends WilyTimeTextField
implements KUICommonStringsKeys {
    private static final long serialVersionUID = 2789418255363475041L;
    private int fQuantum;
    private static final String kWilyQuantizedTimeTextFieldContentsStateKey = "WilyQuantizedTimeTextField_Contents";

    protected WilyQuantizedTimeTextField() {
        Assertion.unimplemented("Must at least specify GenericServices");
    }

    public WilyQuantizedTimeTextField(IGenericServices genericServices, int units, int quantum) {
        super(genericServices, units);
        this.setQuantumInMilliseconds(quantum * units);
    }

    public WilyQuantizedTimeTextField(IGenericServices genericServices, int initialValue, int units, int quantum) {
        super(genericServices, initialValue, units);
        this.setQuantumInMilliseconds(quantum * units);
    }

    public WilyQuantizedTimeTextField(IGenericServices genericServices, int initialValue, int units, int quantum, int columns) {
        super(genericServices, initialValue, units, columns);
        this.setQuantumInMilliseconds(quantum * units);
    }

    protected String getContentsStateKey() {
        return kWilyQuantizedTimeTextFieldContentsStateKey;
    }

    protected void setQuantumInMilliseconds(int quantum) {
        this.checkCanHandleQuantumAndUnit(quantum, 1);
        this.fQuantum = quantum;
    }

    protected int getQuantumInMilliseconds() {
        return this.fQuantum;
    }

    protected void setQuantumInSeconds(int quantum) {
        this.checkCanHandleQuantumAndUnit(quantum, 1000);
        this.setQuantumInMilliseconds(quantum * 1000);
    }

    protected int getQantumInSeconds() {
        return this.getQuantumInMilliseconds() / 1000;
    }

    protected int getQuantumInUnits() {
        return this.getQuantumInMilliseconds() / this.getUnitsToMillisecondsRatio();
    }

    private void checkTimeIsMultipleOfQuantum() {
        if (this.getTimeValueInMilliseconds() <= 0 || this.getTimeValueInMilliseconds() % this.getQuantumInMilliseconds() != 0) {
            throw new IllegalArgumentException("Time value is not a multiple of the quantum: " + this.getQuantumInMilliseconds());
        }
    }

    private void checkCanHandleQuantumAndUnit(int quantum, int unit) {
        if (quantum > this.getMaxTimeValueForUnit(unit)) {
            throw new IllegalArgumentException("Quantum exceeds limit for given units: " + this.getMaxTimeValueForUnit(unit));
        }
    }

    protected int getMaxTimeValueForUnitAndQuantum(int units) {
        int quantumlessMax = this.getMaxTimeValueForUnit(units);
        return quantumlessMax - quantumlessMax % this.getQuantumInUnits();
    }

    public void IValidatable_validate(int validationConstraints) throws ValidationException {
        super.IValidatable_validate(validationConstraints);
        try {
            this.checkCanHandleQuantumAndUnit(this.getTimeValueInMilliseconds(), this.getUnitsToMillisecondsRatio());
            this.checkTimeIsMultipleOfQuantum();
        }
        catch (NumberFormatException nfe) {
            throw new ValidationInvalidQuantizedBoundedLongException(this.getQuantumInUnits(), (long)this.getMaxTimeValueForUnitAndQuantum(this.getUnits()), (long)this.getQuantumInUnits());
        }
        catch (IllegalArgumentException iae) {
            throw new ValidationInvalidQuantizedBoundedLongException(this.getQuantumInUnits(), (long)this.getMaxTimeValueForUnitAndQuantum(this.getUnits()), (long)this.getQuantumInUnits());
        }
    }
}

